/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.data;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.formatter.data.DataLoader;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class DataManager
implements Listener {
    private final DataLoader loader;

    public String getDataProfile(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        boolean hasUnresolvedProfile = this.containsNoCase(this.loader.dataConfig, playerName);
        if (player != null) {
            this.loader.dataConfig.set("player_data.resolved_profiles." + player.getUniqueId() + ".last_known_name", (Object)player.getName());
            if (hasUnresolvedProfile) {
                this.mergeProfiles(player);
            }
            return "player_data.resolved_profiles." + player.getUniqueId();
        }
        return "player_data.unresolved_profiles." + playerName;
    }

    public DataManager(DataLoader dataLoader) {
        this.loader = dataLoader;
    }

    public List<String> getPlayerNames() {
        ArrayList<String> players = new ArrayList<String>();
        ConfigurationSection unresolved = this.loader.dataConfig.getConfigurationSection("player_data.unresolved_profiles");
        ConfigurationSection resolved = this.loader.dataConfig.getConfigurationSection("player_data.resolved_profiles");
        if (unresolved != null) {
            players.addAll(unresolved.getKeys(false));
        }
        if (resolved != null) {
            for (String uuidKey : resolved.getKeys(false)) {
                String path = "player_data.resolved_profiles." + uuidKey + ".last_known_name";
                String lastKnownName = this.loader.dataConfig.getString(path);
                if (lastKnownName == null || lastKnownName.isEmpty()) continue;
                players.add(lastKnownName);
            }
        }
        return players;
    }

    private boolean containsNoCase(YamlConfiguration config, String targetKey) {
        ConfigurationSection section = config.getConfigurationSection("player_data.unresolved_profiles");
        if (section == null) {
            return false;
        }
        for (String key : section.getKeys(false)) {
            if (!key.equalsIgnoreCase(targetKey)) continue;
            return true;
        }
        return false;
    }

    private void mergeProfiles(Player player) {
        ConfigurationSection source = this.loader.dataConfig.getConfigurationSection("player_data.unresolved_profiles." + player.getName() + ".data");
        ConfigurationSection target = this.loader.dataConfig.getConfigurationSection("player_data.resolved_profiles." + player.getUniqueId() + ".data");
        if (source == null) {
            return;
        }
        if (target == null) {
            target = this.loader.dataConfig.createSection("player_data.resolved_profiles." + player.getUniqueId() + ".data");
        }
        for (String key : source.getKeys(false)) {
            Object sourceValue = source.get(key);
            target.set(key, sourceValue);
        }
        this.loader.dataConfig.set("player_data.unresolved_profiles." + player.getName(), null);
    }
}

