/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.data;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.formatter.data.DataFileConverter;
import me.rockyhawk.commandpanels.formatter.data.DataManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataLoader {
    Context ctx;
    public YamlConfiguration dataConfig;
    public DataManager dataPlayers = new DataManager(this);
    public DataFileConverter dataFileConverter = new DataFileConverter(this);

    public DataLoader(Context pl) {
        this.ctx = pl;
    }

    public String getUserData(String playerName, String dataPoint) {
        return this.dataConfig.getString(this.dataPlayers.getDataProfile(playerName) + ".data." + dataPoint);
    }

    public void setUserData(String playerName, String dataPoint, String dataValue, boolean overwrite) {
        String profile = this.dataPlayers.getDataProfile(playerName);
        if (!overwrite && this.dataConfig.isSet(profile + ".data." + dataPoint)) {
            return;
        }
        this.dataConfig.set(profile + ".data." + dataPoint, (Object)dataValue);
    }

    public void delUserData(String playerName, String dataPoint) {
        String profile = this.dataPlayers.getDataProfile(playerName);
        this.dataConfig.set(profile + ".data." + dataPoint, null);
    }

    public void clearData(String playerName) {
        String profile = this.dataPlayers.getDataProfile(playerName);
        this.dataConfig.set(profile, null);
    }

    public void saveDataFile() {
        try {
            this.dataConfig.save(this.ctx.plugin.getDataFolder() + File.separator + "data.yml");
        }
        catch (IOException s) {
            s.printStackTrace();
            this.ctx.debug.send(s, null, this.ctx);
        }
    }

    public void doDataMath(String playerName, String dataPoint, String dataValue) {
        BigDecimal output;
        BigDecimal originalValue;
        String profile = this.dataPlayers.getDataProfile(playerName);
        try {
            originalValue = new BigDecimal(this.dataConfig.getString(profile + ".data." + dataPoint));
        }
        catch (Exception ex) {
            this.ctx.debug.send(ex, null, this.ctx);
            originalValue = new BigDecimal("1");
        }
        switch (dataValue.charAt(0)) {
            case '+': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                output = originalValue.add(newValue);
                break;
            }
            case '-': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                output = originalValue.subtract(newValue);
                break;
            }
            case '*': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                output = originalValue.multiply(newValue);
                break;
            }
            case '/': {
                BigDecimal newValue = new BigDecimal(dataValue.substring(1));
                try {
                    output = originalValue.divide(newValue);
                }
                catch (ArithmeticException ex) {
                    this.ctx.debug.send(ex, null, this.ctx);
                    output = originalValue;
                }
                break;
            }
            default: {
                BigDecimal newValue;
                output = newValue = new BigDecimal(dataValue);
            }
        }
        if (output.stripTrailingZeros().scale() <= 0) {
            this.dataConfig.set(profile + ".data." + dataPoint, (Object)output.stripTrailingZeros().toPlainString());
            return;
        }
        this.dataConfig.set(profile + ".data." + dataPoint, (Object)output.toPlainString());
    }
}

