/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.data;

import java.util.Optional;
import java.util.UUID;
import me.rockyhawk.commandpanels.formatter.data.DataLoader;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class DataFileConverter {
    private final DataLoader loader;

    public DataFileConverter(DataLoader dataLoader) {
        this.loader = dataLoader;
    }

    public void convertOldProfileLayout() {
        ConfigurationSection oldProfiles = this.loader.dataConfig.getConfigurationSection("playerData");
        if (oldProfiles == null) {
            return;
        }
        for (String uuid : oldProfiles.getKeys(false)) {
            ConfigurationSection oldData = oldProfiles.getConfigurationSection(uuid);
            if (oldData == null) continue;
            String playerName = Optional.ofNullable(Bukkit.getPlayer((UUID)UUID.fromString(uuid))).map(Player::getName).orElse("Unknown");
            String basePath = "player_data.resolved_profiles." + uuid;
            this.loader.dataConfig.set(basePath + ".last_known_name", (Object)playerName);
            ConfigurationSection newDataSection = this.loader.dataConfig.createSection(basePath + ".data");
            for (String key : oldData.getKeys(false)) {
                Object value = oldData.get(key);
                newDataSection.set(key, value);
            }
        }
        this.loader.dataConfig.set("playerData", null);
        this.loader.saveDataFile();
        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[CommandPanels] Data file (data.yml) has been converted to the newest format!");
    }
}

