/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.Context;

public class HexColours {
    Context ctx;

    public HexColours(Context pl) {
        this.ctx = pl;
    }

    public String translateHexColorCodes(String message) {
        message = this.doTranslation(message, this.formatRegex("hexcodes.start_tag"), this.formatRegex("hexcodes.end_tag"));
        return message;
    }

    private String doTranslation(String message, String startTag, String endTag) {
        Pattern hexPattern = Pattern.compile(startTag + "([A-Fa-f0-9]{6})" + endTag);
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    private String formatRegex(String path) {
        String[] metaCharacters;
        String inputString = this.ctx.configHandler.config.getString(path);
        for (String metaCharacter : metaCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", ".", "*", "+", "?", "|", "<", ">", "-", "&", "%"}) {
            assert (inputString != null);
            if (!inputString.contains(metaCharacter)) continue;
            inputString = inputString.replace(metaCharacter, "\\" + metaCharacter);
        }
        return inputString;
    }
}

