/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import me.rockyhawk.commandpanels.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler {
    private final Context ctx;
    public YamlConfiguration config;
    public YamlConfiguration blockConfig;
    public final File panelsFolder;

    public ConfigHandler(Context pl) {
        this.ctx = pl;
        this.panelsFolder = new File(this.ctx.plugin.getDataFolder() + File.separator + "panels");
        this.onPluginLoad();
    }

    public boolean eqlNoCase(String path, String value) {
        return this.config.getString(path).equalsIgnoreCase(value);
    }

    public boolean isTrue(String path) {
        return this.config.getString(path).equalsIgnoreCase("true");
    }

    public Reader getReaderFromStream(InputStream initialStream) throws IOException {
        byte[] buffer = IOUtils.toByteArray(initialStream);
        return new CharSequenceReader(new String(buffer));
    }

    public void onPluginLoad() {
        this.blockConfig = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder() + File.separator + "blocks.yml"));
        this.ctx.panelData.dataConfig = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder() + File.separator + "data.yml"));
        this.ctx.inventorySaver.inventoryConfig = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder() + File.separator + "inventories.yml"));
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder() + File.separator + "config.yml"));
        this.ctx.panelData.dataFileConverter.convertOldProfileLayout();
        File configFile = new File(this.ctx.plugin.getDataFolder() + File.separator + "config.yml");
        if (!configFile.exists()) {
            try {
                YamlConfiguration configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("config.yml")));
                configFileConfiguration.save(configFile);
                this.config = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder() + File.separator + "config.yml"));
            }
            catch (IOException var11) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " WARNING: Could not save the config file!");
            }
        } else {
            try {
                YamlConfiguration configFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("config.yml")));
                this.config.addDefaults((Configuration)configFileConfiguration);
                this.config.options().copyDefaults(true);
                this.config.save(new File(this.ctx.plugin.getDataFolder() + File.separator + "config.yml"));
            }
            catch (IOException var10) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " WARNING: Could not save the config file!");
            }
        }
        this.saveExamplePanels();
    }

    private void saveExamplePanels() {
        if (!this.panelsFolder.exists()) {
            try {
                YamlConfiguration exampleFileConfiguration;
                if (this.ctx.version.isBelow("1.13")) {
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("exampleLegacy.yml")));
                    exampleFileConfiguration.save(new File(this.panelsFolder + File.separator + "example.yml"));
                } else {
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("example_top.yml")));
                    exampleFileConfiguration.save(new File(this.panelsFolder + File.separator + "example_top.yml"));
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("example_middle_one.yml")));
                    exampleFileConfiguration.save(new File(this.panelsFolder + File.separator + "example_middle_one.yml"));
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("example_middle_two.yml")));
                    exampleFileConfiguration.save(new File(this.panelsFolder + File.separator + "example_middle_two.yml"));
                    exampleFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("example_bottom.yml")));
                    exampleFileConfiguration.save(new File(this.panelsFolder + File.separator + "example_bottom.yml"));
                }
                YamlConfiguration templateFileConfiguration = YamlConfiguration.loadConfiguration((Reader)this.getReaderFromStream(this.ctx.plugin.getResource("template.yml")));
                templateFileConfiguration.save(new File(this.panelsFolder + File.separator + "template.yml"));
            }
            catch (IOException var11) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " WARNING: Could not save the example file!");
            }
        }
    }
}

