/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commands.tabcomplete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DataTabComplete
implements TabCompleter {
    Context ctx;

    public DataTabComplete(Context pl) {
        this.ctx = pl;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("commandpanel.data")) {
            ArrayList<String> output = new ArrayList<String>();
            if (args.length >= 1 && args[0].equalsIgnoreCase("-s")) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (args.length == 1) {
                String arg1 = args[0].toLowerCase();
                if ("set".startsWith(arg1)) {
                    output.add("set");
                }
                if ("add".startsWith(arg1)) {
                    output.add("add");
                }
                if ("get".startsWith(arg1)) {
                    output.add("get");
                }
                if ("remove".startsWith(arg1)) {
                    output.add("remove");
                }
                if ("clear".startsWith(arg1)) {
                    output.add("clear");
                }
            } else if (args.length == 2) {
                output.addAll(this.ctx.panelData.dataPlayers.getPlayerNames());
                String[] finalArgs = args;
                output.removeIf(s -> !s.toLowerCase().startsWith(finalArgs[1]));
                if (!args[0].equalsIgnoreCase("get")) {
                    output.add("all");
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("clear")) {
                    return new ArrayList<String>();
                }
                try {
                    HashSet<String> set = new HashSet<String>();
                    for (String player : this.ctx.panelData.dataPlayers.getPlayerNames()) {
                        String profile = this.ctx.panelData.dataPlayers.getDataProfile(player);
                        set.addAll(this.ctx.panelData.dataConfig.getConfigurationSection(profile + ".data").getKeys(false));
                    }
                    String[] finalArgs = args;
                    set.removeIf(s -> !s.toLowerCase().startsWith(finalArgs[2]));
                    return new ArrayList<String>(set);
                }
                catch (Exception ex) {
                    return new ArrayList<String>();
                }
            }
            return output;
        }
        return null;
    }
}

