/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commands.editor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandPanelsEditor
implements CommandExecutor {
    Context ctx;

    public CommandPanelsEditor(Context pl) {
        this.ctx = pl;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("commandpanel.edit")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Cannot execute command in Console!"));
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.GREEN + "Access the web editor at the link below"));
                sender.sendMessage(this.ctx.text.colour(ChatColor.YELLOW + "https://CommandPanels.net/editor"));
                return true;
            }
            if (args.length == 1) {
                for (Panel panel : this.ctx.plugin.panelList) {
                    if (panel.getFile() == null || !panel.getFile().getName().equals(args[0])) continue;
                    String filePath = panel.getFile().getAbsolutePath();
                    String fileContents = this.readFileAsString(filePath);
                    String yamlWithFileNameAndPath = this.getYamlText(panel, fileContents);
                    byte[] contentBytes = yamlWithFileNameAndPath.getBytes(StandardCharsets.UTF_8);
                    if (contentBytes.length > 65535) {
                        sender.sendMessage(this.ctx.tag + ChatColor.RED + "Content too long to paste in chat. Please copy and paste the panel file into the editor manually.");
                    } else {
                        BaseComponent[] components = new ComponentBuilder(this.ctx.tag + net.md_5.bungee.api.ChatColor.GREEN + "Click here to copy " + net.md_5.bungee.api.ChatColor.WHITE + panel.getFile().getName() + net.md_5.bungee.api.ChatColor.GREEN + " to the clipboard!").event(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, yamlWithFileNameAndPath)).create();
                        Player player = (Player)sender;
                        player.spigot().sendMessage(components);
                    }
                    return true;
                }
                sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Could not find panel!"));
                return true;
            }
            if (args.length == 3) {
                this.downloadPanel(sender, args[1], args[0], args[2]).thenAccept(ignored -> {
                    this.ctx.reloader.reloadPanelFiles();
                    this.ctx.hotbar.reloadHotbarSlots();
                });
                return true;
            }
        } else {
            sender.sendMessage(this.ctx.text.colour(this.ctx.tag + this.ctx.configHandler.config.getString("config.format.perms")));
            return true;
        }
        sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Usage: /cpe <parameters>"));
        return true;
    }

    private String getYamlText(Panel panel, String fileContents) {
        Path panelsFolderPath = this.ctx.configHandler.panelsFolder.toPath();
        Path panelFilePath = panel.getFile().toPath();
        Path relativePanelPath = panelsFolderPath.relativize(panelFilePath);
        String relativePath = relativePanelPath.toString();
        return "fileName: " + relativePath.replaceFirst("[.][^.]+$", "") + "\n" + fileContents;
    }

    private CompletableFuture<Void> downloadPanel(CommandSender sender, String userID, String fileName, String token) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        String url = "https://firebasestorage.googleapis.com/v0/b/commandpanels-website.appspot.com/o/pastes%2F" + userID + "%2F" + fileName + "?alt=media&token=" + token;
        this.ctx.scheduler.runTaskAsynchronously(() -> {
            this.ctx.downloader.downloadPanel(sender, url, fileName);
            future.complete(null);
        });
        return future;
    }

    private String readFileAsString(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

