/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.generate.deluxecompatibility.CompatibilityConverter;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;

public class ReloadCommand
implements CommandExecutor {
    Context ctx;

    public ReloadCommand(Context pl) {
        this.ctx = pl;
        this.reloadPanelFiles();
    }

    @EventHandler
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (label.equalsIgnoreCase("cpr") || label.equalsIgnoreCase("commandpanelreload") || label.equalsIgnoreCase("cpanelr")) {
            if (!sender.hasPermission("commandpanel.reload")) {
                sender.sendMessage(this.ctx.text.colour(this.ctx.tag + this.ctx.configHandler.config.getString("config.format.perms")));
                return true;
            }
            this.ctx.scheduler.runTaskAsynchronously(() -> {
                this.reloadPanelFiles();
                this.ctx.scheduler.runTask(() -> {
                    for (String name : this.ctx.openPanels.openPanels.keySet()) {
                        this.ctx.openPanels.closePanelForLoader(name, PanelPosition.Top);
                        try {
                            Bukkit.getPlayer((String)name).closeInventory();
                        }
                        catch (Exception exception) {}
                    }
                    this.ctx.configHandler.onPluginLoad();
                    this.checkDuplicatePanel(sender);
                    this.ctx.hotbar.reloadHotbarSlots();
                    if (this.ctx.configHandler.isTrue("config.auto-register-commands")) {
                        this.ctx.openCommands.registerCommands();
                    }
                    sender.sendMessage(this.ctx.text.colour(this.ctx.tag + this.ctx.configHandler.config.getString("config.format.reload")));
                });
            });
            return true;
        }
        sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Usage: /cpr"));
        return true;
    }

    public void reloadPanelFiles() {
        this.ctx.plugin.panelList.clear();
        this.ctx.plugin.openWithItem = false;
        this.fileNamesFromDirectory(new File(this.ctx.plugin.getDataFolder() + File.separator + "panels"));
        this.ctx.tag = this.ctx.text.colour(this.ctx.configHandler.config.getString("config.format.tag")) + " ";
    }

    private void fileNamesFromDirectory(File directory) {
        for (String fileName : Objects.requireNonNull(directory.list())) {
            if (new File(directory + File.separator + fileName).isDirectory()) {
                this.fileNamesFromDirectory(new File(directory + File.separator + fileName));
                continue;
            }
            try {
                int ind = fileName.lastIndexOf(".");
                if (!fileName.substring(ind).equalsIgnoreCase(".yml") && !fileName.substring(ind).equalsIgnoreCase(".yaml")) {
                }
            }
            catch (Exception ex) {}
            continue;
            if (!this.checkPanels(YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)))) {
                CompatibilityConverter deluxeConverter = new CompatibilityConverter(this.ctx);
                YamlConfiguration convertedYaml = deluxeConverter.tryConversion(fileName, YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)));
                if (convertedYaml != null) {
                    for (String tempName : Objects.requireNonNull(convertedYaml.getConfigurationSection("panels")).getKeys(false)) {
                        this.ctx.plugin.panelList.add(new Panel((ConfigurationSection)convertedYaml, tempName));
                        if (!convertedYaml.contains("panels." + tempName + ".open-with-item")) continue;
                        this.ctx.plugin.openWithItem = true;
                    }
                    continue;
                }
                this.ctx.scheduler.runTask(() -> this.ctx.plugin.getServer().getConsoleSender().sendMessage("[CommandPanels]" + ChatColor.RED + " Error in: " + fileName));
                continue;
            }
            for (String tempName : Objects.requireNonNull(YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)).getConfigurationSection("panels")).getKeys(false)) {
                this.ctx.plugin.panelList.add(new Panel(new File(directory + File.separator + fileName), tempName));
                if (!YamlConfiguration.loadConfiguration((File)new File(directory + File.separator + fileName)).contains("panels." + tempName + ".open-with-item")) continue;
                this.ctx.plugin.openWithItem = true;
            }
        }
    }

    private boolean checkPanels(YamlConfiguration temp) {
        try {
            return temp.contains("panels");
        }
        catch (Exception var3) {
            return false;
        }
    }

    private boolean checkDuplicatePanel(CommandSender sender) {
        ArrayList<String> apanels = new ArrayList<String>();
        for (Panel panel : this.ctx.plugin.panelList) {
            apanels.add(panel.getName());
        }
        HashSet oset = new HashSet(apanels);
        if (oset.size() < apanels.size()) {
            ArrayList<String> opanelsTemp = new ArrayList<String>();
            for (String tempName : apanels) {
                if (opanelsTemp.contains(tempName)) {
                    sender.sendMessage(this.ctx.text.colour(this.ctx.tag) + ChatColor.RED + "Error duplicate panel name: " + tempName);
                    return false;
                }
                opanelsTemp.add(tempName);
            }
            return false;
        }
        return true;
    }
}

