/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder.floodgate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.events.PanelOpenedEvent;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class OpenFloodgateGUI
implements Listener {
    private Context ctx;

    public OpenFloodgateGUI(Context pl) {
        this.ctx = pl;
    }

    @EventHandler
    public void onPanelOpen(PanelOpenedEvent e) {
        if (!FloodgateApi.getInstance().isFloodgatePlayer(e.getPlayer().getUniqueId()) || !e.getPanel().getConfig().contains("floodgate")) {
            return;
        }
        FloodgatePlayer fgPlayer = FloodgateApi.getInstance().getPlayer(e.getPlayer().getUniqueId());
        ConfigurationSection fgPanel = e.getPanel().getConfig().getConfigurationSection("floodgate");
        if (fgPanel.contains("simple")) {
            this.createAndSendSimpleForm(e, fgPlayer, fgPanel);
        } else {
            this.createAndSendCustomForm(e, fgPlayer, fgPanel);
        }
        e.setCancelled(true);
    }

    private void createAndSendSimpleForm(PanelOpenedEvent e, FloodgatePlayer fgPlayer, ConfigurationSection fgPanel) {
        List<String> buttonCommands;
        SimpleForm.Builder form = ((SimpleForm.Builder)SimpleForm.builder().title(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), e.getPanel().getConfig().getString("title"))))).content(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fgPanel.getString("simple")).replaceAll("\\\\n", "\n")));
        try {
            buttonCommands = this.processButtons(fgPanel, form, e.getPanel(), e.getPlayer());
        }
        catch (Exception err) {
            e.getPlayer().sendMessage(this.ctx.tag + ChatColor.RED + "FloodGate panel button config error");
            this.ctx.debug.send(err, e.getPlayer(), this.ctx);
            return;
        }
        form.validResultHandler(response -> {
            int clickedButtonId = response.clickedButtonId();
            String configKey = (String)buttonCommands.get(clickedButtonId);
            String section = this.ctx.has.hasSection(e.getPanel(), PanelPosition.Top, fgPanel.getConfigurationSection(configKey), e.getPlayer());
            ConfigurationSection buttonConfig = fgPanel.getConfigurationSection(configKey + section);
            if (buttonConfig.contains("commands")) {
                this.ctx.commands.runCommands(e.getPanel(), PanelPosition.Top, e.getPlayer(), buttonConfig.getStringList("commands"), null);
            }
        });
        fgPlayer.sendForm(form.build());
    }

    private List<String> processButtons(ConfigurationSection fgPanel, SimpleForm.Builder form, Panel panel, Player p) {
        return fgPanel.getKeys(false).stream().filter(key -> key.matches("\\d+")).sorted(Comparator.comparingInt(Integer::parseInt)).filter(key -> {
            ConfigurationSection buttonConfig = fgPanel.getConfigurationSection(key);
            if (buttonConfig == null) {
                return false;
            }
            String section = this.ctx.has.hasSection(panel, PanelPosition.Top, buttonConfig, p);
            ConfigurationSection resolvedConfig = fgPanel.getConfigurationSection(key + section);
            return resolvedConfig != null && resolvedConfig.contains("text");
        }).map(key -> {
            String section = this.ctx.has.hasSection(panel, PanelPosition.Top, fgPanel.getConfigurationSection(key), p);
            ConfigurationSection buttonConfig = fgPanel.getConfigurationSection(key + section);
            String buttonContent = this.ctx.text.placeholders(panel, null, p, buttonConfig.getString("text").replaceAll("\\\\n", "\n"));
            if (!buttonConfig.contains("icon")) {
                form.button(buttonContent);
            } else {
                FormImage.Type type = FormImage.Type.valueOf((String)this.ctx.text.placeholders(panel, null, p, buttonConfig.getString("icon.type")).toUpperCase());
                String texture = this.ctx.text.placeholders(panel, null, p, buttonConfig.getString("icon.texture"));
                form.button(buttonContent, type, texture);
            }
            return key;
        }).collect(Collectors.toList());
    }

    private void createAndSendCustomForm(PanelOpenedEvent e, FloodgatePlayer fgPlayer, ConfigurationSection fgPanel) {
        CustomForm.Builder form = (CustomForm.Builder)CustomForm.builder().title(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), e.getPanel().getConfig().getString("title")));
        ArrayList commandsOrder = new ArrayList();
        fgPanel.getKeys(false).forEach(key -> {
            if (key.matches("\\d+")) {
                String section = this.ctx.has.hasSection(e.getPanel(), e.getPosition(), fgPanel.getConfigurationSection(key), e.getPlayer());
                ConfigurationSection fieldConfig = fgPanel.getConfigurationSection(key + section);
                if (!fieldConfig.contains("text")) {
                    return;
                }
                try {
                    String type = "toggle";
                    if (fieldConfig.contains("type")) {
                        type = fieldConfig.getString("type").toLowerCase();
                    }
                    switch (type) {
                        case "toggle": {
                            form.toggle(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("text").replaceAll("\\\\n", "\n")), Boolean.parseBoolean(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("default"))));
                            commandsOrder.add(key);
                            break;
                        }
                        case "slider": {
                            form.slider(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("text").replaceAll("\\\\n", "\n")), (float)Long.parseLong(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("min"))), (float)Long.parseLong(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("max"))), (float)Long.parseLong(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("step"))), (float)Long.parseLong(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("default"))));
                            commandsOrder.add(key);
                            break;
                        }
                        case "input": {
                            form.input(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("text").replaceAll("\\\\n", "\n")), this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("placeholder")), this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("default")));
                            commandsOrder.add(key);
                            break;
                        }
                        case "dropdown": {
                            form.dropdown(this.ctx.text.placeholders(e.getPanel(), null, e.getPlayer(), fieldConfig.getString("text").replaceAll("\\\\n", "\n")), this.ctx.text.placeholdersList(e.getPanel(), null, e.getPlayer(), fieldConfig.getStringList("options")));
                            commandsOrder.add(key);
                        }
                    }
                }
                catch (Exception err) {
                    e.getPlayer().sendMessage(this.ctx.tag + ChatColor.RED + "FloodGate panel button config error");
                    this.ctx.debug.send(err, e.getPlayer(), this.ctx);
                }
            }
        });
        form.validResultHandler(response -> {
            for (String configKey : commandsOrder) {
                if (!response.hasNext()) break;
                String section = this.ctx.has.hasSection(e.getPanel(), e.getPosition(), fgPanel.getConfigurationSection(configKey), e.getPlayer());
                ConfigurationSection fieldConfig = fgPanel.getConfigurationSection(configKey + section);
                if (!fieldConfig.contains("commands")) continue;
                Object fieldValue = response.next();
                String value = String.valueOf(fieldValue);
                List commands = fieldConfig.getStringList("commands");
                ArrayList<String> processedCommands = new ArrayList<String>();
                for (String command : commands) {
                    processedCommands.add(command.replaceAll("%cp-input%", value));
                }
                this.ctx.commands.runCommands(e.getPanel(), PanelPosition.Top, e.getPlayer(), processedCommands, null);
            }
        });
        fgPlayer.sendForm(form.build());
    }
}

