/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder;

import java.util.HashSet;
import java.util.Set;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.builder.storagecontents.GetStorageContents;
import me.rockyhawk.commandpanels.builder.storagecontents.GetStorageContentsLegacy;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SlotManager {
    private final PanelBuilder bld;
    protected HashSet<Integer> takenSlots = new HashSet();

    public SlotManager(PanelBuilder bld) {
        this.bld = bld;
    }

    public void populateSlots(Panel panel, Player p, PanelPosition position, int animateValue, Inventory inv) {
        ConfigurationSection config = panel.getConfig();
        Set itemKeys = config.getConfigurationSection("item").getKeys(false);
        for (String itemKey : itemKeys) {
            String section = this.bld.ctx.has.hasSection(panel, position, config.getConfigurationSection("item." + itemKey), p);
            if (config.contains("item." + itemKey + section + ".animate" + animateValue)) {
                section = section + ".animate" + animateValue;
            }
            ItemStack item = this.bld.ctx.itemBuilder.buildItem(panel, position, config.getConfigurationSection("item." + itemKey + section), p, true);
            int slot = Integer.parseInt(this.bld.ctx.text.placeholdersNoColour(panel, position, p, itemKey));
            if (config.contains("item." + itemKey + section + ".itemType") && config.getStringList("item." + itemKey + section + ".itemType").contains("placeable") && !this.bld.isFirstBuild) {
                this.setItem(p.getOpenInventory().getItem(slot), slot, inv, p, position);
                this.takenSlots.add(slot);
                continue;
            }
            this.setItem(item, slot, inv, p, position);
            this.takenSlots.add(slot);
            this.bld.itemPlacer.placeDuplicates(inv, position, p, config, itemKey, item, section);
        }
    }

    protected void setItem(ItemStack item, int slot, Inventory inv, Player p, PanelPosition position) {
        try {
            if (position == PanelPosition.Top) {
                inv.setItem(slot, item);
            } else if (position == PanelPosition.Middle) {
                if (slot + 9 < 36) {
                    p.getInventory().setItem(slot + 9, item);
                }
            } else if (slot < 9) {
                p.getInventory().setItem(slot, item);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void setStorageContents(Player player, ItemStack[] items) {
        if (this.bld.ctx.version.isBelow("1.16")) {
            new GetStorageContentsLegacy().setStorageContents(player, items);
        } else {
            new GetStorageContents().setStorageContents(player, items);
        }
    }

    protected ItemStack[] getStorageContents(Inventory inventory) {
        if (this.bld.ctx.version.isBelow("1.13")) {
            return new GetStorageContentsLegacy().getStorageContents(inventory);
        }
        return new GetStorageContents().getStorageContents(inventory);
    }
}

