/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.builder.ItemPlacer;
import me.rockyhawk.commandpanels.builder.PanelFactory;
import me.rockyhawk.commandpanels.builder.SlotManager;
import me.rockyhawk.commandpanels.builder.TitleHandler;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class PanelBuilder {
    protected final Context ctx;
    protected final PanelFactory factory;
    protected final SlotManager slotManager;
    protected final ItemPlacer itemPlacer;
    protected boolean isFirstBuild;

    public PanelBuilder(Context ctx) {
        this.ctx = ctx;
        this.factory = new PanelFactory(ctx);
        this.slotManager = new SlotManager(this);
        this.itemPlacer = new ItemPlacer(this);
    }

    public void openInv(Panel panel, Player p, PanelPosition position, int animateValue) {
        this.isFirstBuild = true;
        Inventory inv = this.buildInv(panel, p, position, animateValue);
        if (position == PanelPosition.Top) {
            p.openInventory(inv);
        }
        this.ctx.openPanels.openPanelForLoader(p.getName(), panel, position);
    }

    public void refreshInv(Panel panel, Player p, PanelPosition position, int animateValue) {
        this.isFirstBuild = false;
        Inventory inv = this.buildInv(panel, p, position, animateValue);
        if (this.ctx.version.isAtLeast("1.21.5") && position == PanelPosition.Top) {
            TitleHandler title = new TitleHandler();
            p.getOpenInventory().setTitle(title.getTitle(this.ctx, panel, p, position, animateValue));
        }
        if (position == PanelPosition.Top) {
            this.slotManager.setStorageContents(p, this.slotManager.getStorageContents(inv));
        }
    }

    public Inventory getInv(Panel panel, Player p, PanelPosition position, int animateValue) {
        this.isFirstBuild = true;
        return this.buildInv(panel, p, position, animateValue);
    }

    private Inventory buildInv(Panel panel, Player p, PanelPosition position, int animateValue) {
        Inventory inv = this.factory.createInventory(panel, p, position, animateValue);
        this.slotManager.takenSlots.clear();
        this.slotManager.populateSlots(panel, p, position, animateValue, inv);
        this.itemPlacer.placeEmptyItems(panel, p, position, inv);
        return inv;
    }
}

