/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.builder;

import java.lang.reflect.Method;
import java.util.Objects;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemPlacer {
    private final PanelBuilder bld;

    public ItemPlacer(PanelBuilder bld) {
        this.bld = bld;
    }

    public void placeEmptyItems(Panel panel, Player p, PanelPosition pos, Inventory inv) {
        ConfigurationSection config = panel.getConfig();
        String materialName = config.contains("empty") ? this.bld.ctx.text.placeholdersNoColour(panel, pos, p, config.getString("empty")) : "AIR";
        try {
            ItemStack empty;
            short id;
            short s = id = config.contains("emptyID") ? Short.parseShort(this.bld.ctx.text.placeholdersNoColour(panel, pos, p, config.getString("emptyID"))) : (short)0;
            if (config.contains("custom-item." + materialName)) {
                empty = this.bld.ctx.itemBuilder.buildItem(panel, pos, config.getConfigurationSection("custom-item." + materialName), p, true);
            } else {
                empty = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)materialName.toUpperCase())), 1, id);
                ItemMeta meta = empty.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(" ");
                    if (this.bld.ctx.version.isAtLeast("1.21.4")) {
                        try {
                            Method m = ItemMeta.class.getMethod("setHideTooltip", Boolean.TYPE);
                            m.invoke((Object)meta, true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    empty.setItemMeta(meta);
                }
            }
            for (int i = 0; i < inv.getSize(); ++i) {
                if (this.bld.slotManager.takenSlots.contains(i)) continue;
                this.bld.slotManager.setItem(empty, i, inv, p, pos);
            }
        }
        catch (Exception e) {
            this.bld.ctx.debug.send(e, p, this.bld.ctx);
        }
    }

    public void placeDuplicates(Inventory inv, PanelPosition position, Player p, ConfigurationSection config, String itemKey, ItemStack item, String section) {
        String[] duplicates;
        if (!config.contains("item." + itemKey + section + ".duplicate")) {
            return;
        }
        for (String d : duplicates = config.getString("item." + itemKey + section + ".duplicate").split(",")) {
            try {
                if (d.contains("-")) {
                    int start = Integer.parseInt(d.split("-")[0]);
                    int end = Integer.parseInt(d.split("-")[1]);
                    for (int i = start; i <= end; ++i) {
                        if (config.contains("item." + i)) continue;
                        this.bld.slotManager.setItem(item, i, inv, p, position);
                        this.bld.slotManager.takenSlots.add(i);
                    }
                    continue;
                }
                int slot = Integer.parseInt(d);
                if (config.contains("item." + slot)) continue;
                this.bld.slotManager.setItem(item, slot, inv, p, position);
                this.bld.slotManager.takenSlots.add(slot);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

