/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.api;

import java.io.File;
import java.io.IOException;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandPanelsAPI {
    public Context ctx;

    public CommandPanelsAPI(Context pl) {
        this.ctx = pl;
    }

    public boolean isPanelOpen(Player p) {
        return this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top);
    }

    public Panel getOpenPanel(Player p, PanelPosition position) {
        return this.ctx.openPanels.getOpenPanel(p.getName(), position);
    }

    public List<Panel> getPanelsLoaded() {
        return this.ctx.plugin.panelList;
    }

    public void addPanel(Panel panel) throws IOException {
        File addedFile = new File(this.ctx.configHandler.panelsFolder, panel.getName() + ".yml");
        YamlConfiguration newYaml = new YamlConfiguration();
        if (panel.getConfig().contains("panels")) {
            newYaml.set("", (Object)panel.getConfig());
        } else {
            newYaml.set("panels." + panel.getName(), (Object)panel.getConfig());
        }
        newYaml.save(addedFile);
        this.ctx.reloader.reloadPanelFiles();
    }

    public void removePanel(String panelName) {
        for (Panel panels : this.ctx.plugin.panelList) {
            if (!panels.getName().equals(panelName) || !panels.getFile().delete()) continue;
            this.ctx.reloader.reloadPanelFiles();
        }
    }

    public Panel getPanel(String panelName) {
        for (Panel panel : this.ctx.plugin.panelList) {
            if (!panel.getName().equals(panelName)) continue;
            return panel;
        }
        return null;
    }

    public boolean hasNormalInventory(Player p) {
        return this.ctx.inventorySaver.hasNormalInventory(p);
    }

    public ItemStack makeItem(Player p, ConfigurationSection itemSection) {
        return this.ctx.itemBuilder.buildItem(null, PanelPosition.Top, itemSection, p, false);
    }
}

