/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.builder.floodgate.OpenFloodgateGUI;
import me.rockyhawk.commandpanels.commands.DataCommand;
import me.rockyhawk.commandpanels.commands.DebugCommand;
import me.rockyhawk.commandpanels.commands.ImportCommand;
import me.rockyhawk.commandpanels.commands.ListCommand;
import me.rockyhawk.commandpanels.commands.PanelCommand;
import me.rockyhawk.commandpanels.commands.ReloadCommand;
import me.rockyhawk.commandpanels.commands.UpdateCommand;
import me.rockyhawk.commandpanels.commands.VersionCommand;
import me.rockyhawk.commandpanels.commands.editor.CommandPanelsEditor;
import me.rockyhawk.commandpanels.commands.editor.EditorTabComplete;
import me.rockyhawk.commandpanels.commands.editor.PanelDownloader;
import me.rockyhawk.commandpanels.commands.opencommands.OpenCommands;
import me.rockyhawk.commandpanels.commands.tabcomplete.DataTabComplete;
import me.rockyhawk.commandpanels.commands.tabcomplete.ImportTabComplete;
import me.rockyhawk.commandpanels.commands.tabcomplete.PanelTabComplete;
import me.rockyhawk.commandpanels.commands.tabcomplete.UpdateTabComplete;
import me.rockyhawk.commandpanels.configuration.ConfigHandler;
import me.rockyhawk.commandpanels.configuration.DebugManager;
import me.rockyhawk.commandpanels.formatter.CreateText;
import me.rockyhawk.commandpanels.formatter.HexColours;
import me.rockyhawk.commandpanels.formatter.MiniMessage;
import me.rockyhawk.commandpanels.formatter.data.DataLoader;
import me.rockyhawk.commandpanels.formatter.placeholders.PlaceholderAPI;
import me.rockyhawk.commandpanels.formatter.placeholders.Placeholders;
import me.rockyhawk.commandpanels.generate.GenTabComplete;
import me.rockyhawk.commandpanels.generate.GenUtils;
import me.rockyhawk.commandpanels.generate.GenerateCommand;
import me.rockyhawk.commandpanels.interaction.blocks.BlockCommand;
import me.rockyhawk.commandpanels.interaction.blocks.BlockEvents;
import me.rockyhawk.commandpanels.interaction.blocks.BlockTabComplete;
import me.rockyhawk.commandpanels.interaction.click.InteractionHandler;
import me.rockyhawk.commandpanels.interaction.commands.CommandRunner;
import me.rockyhawk.commandpanels.interaction.input.PlayerInputUtils;
import me.rockyhawk.commandpanels.inventory.InventorySaver;
import me.rockyhawk.commandpanels.inventory.ItemStackSerializer;
import me.rockyhawk.commandpanels.inventory.pickupevent.EntityPickupEvent;
import me.rockyhawk.commandpanels.inventory.pickupevent.LegacyPlayerEvent;
import me.rockyhawk.commandpanels.items.HasSections;
import me.rockyhawk.commandpanels.items.builder.ItemBuilder;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.potions.Potion_1_20_4;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.potions.Potion_1_8;
import me.rockyhawk.commandpanels.items.customheads.GetCustomHeads;
import me.rockyhawk.commandpanels.items.dropitem.DroppedItemHandler;
import me.rockyhawk.commandpanels.manager.PlayerJoinEvent;
import me.rockyhawk.commandpanels.manager.open.OpenPanel;
import me.rockyhawk.commandpanels.manager.refresh.PanelRefresher;
import me.rockyhawk.commandpanels.manager.refresh.SchedulerAdapter;
import me.rockyhawk.commandpanels.manager.session.SessionHandler;
import me.rockyhawk.commandpanels.manager.session.SessionUtils;
import me.rockyhawk.commandpanels.nbt.NBTManager;
import me.rockyhawk.commandpanels.openwithitem.HotbarItemLoader;
import me.rockyhawk.commandpanels.openwithitem.events.HotbarEvents;
import me.rockyhawk.commandpanels.openwithitem.events.SwapItemEvent;
import me.rockyhawk.commandpanels.openwithitem.events.UtilsChestSortEvent;
import me.rockyhawk.commandpanels.updater.Updater;
import me.rockyhawk.commandpanels.versions.VersionManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Context {
    public CommandPanels plugin;
    public String tag = "[CommandPanels] ";
    public PanelDownloader downloader;
    public ConfigHandler configHandler;
    public Economy econ;
    public ReloadCommand reloader;
    public CommandRunner commands;
    public DataLoader panelData;
    public OpenCommands openCommands;
    public Placeholders placeholders;
    public DebugManager debug;
    public CreateText text;
    public HexColours hex;
    public MiniMessage miniMessage;
    public OpenPanel openPanel;
    public ItemBuilder itemBuilder;
    public HasSections has;
    public GetCustomHeads customHeads;
    public Updater updater;
    public Potion_1_8 potion_1_8;
    public Potion_1_20_4 potion_1_20_4;
    public VersionManager version;
    public SessionHandler openPanels;
    public HotbarItemLoader hotbar;
    public NBTManager nbt;
    public GenUtils generator;
    public InventorySaver inventorySaver;
    public ItemStackSerializer itemSerializer;
    public PlayerInputUtils inputUtils;
    public SchedulerAdapter scheduler;

    public Context(CommandPanels pl) {
        this.plugin = pl;
        this.init();
    }

    private void init() {
        this.version = new VersionManager();
        this.downloader = new PanelDownloader(this);
        try {
            Class.forName("net.kyori.adventure.text.Component");
            Class.forName("net.kyori.adventure.text.format.TextDecoration");
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
            Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            this.miniMessage = new MiniMessage(this);
        }
        catch (ClassNotFoundException ignore) {
            this.miniMessage = null;
        }
        this.placeholders = new Placeholders(this);
        this.debug = new DebugManager();
        this.text = new CreateText(this);
        this.hex = new HexColours(this);
        this.panelData = new DataLoader(this);
        this.inventorySaver = new InventorySaver(this);
        this.configHandler = new ConfigHandler(this);
        this.econ = null;
        this.scheduler = new SchedulerAdapter((Plugin)this.plugin);
        this.openCommands = new OpenCommands(this);
        this.reloader = new ReloadCommand(this);
        this.commands = new CommandRunner(this);
        this.openPanel = new OpenPanel(this);
        this.itemBuilder = new ItemBuilder(this);
        this.has = new HasSections(this);
        this.customHeads = new GetCustomHeads(this);
        this.updater = new Updater(this);
        this.potion_1_8 = new Potion_1_8();
        this.potion_1_20_4 = new Potion_1_20_4();
        this.openPanels = new SessionHandler(this);
        this.hotbar = new HotbarItemLoader(this);
        this.nbt = new NBTManager(this);
        this.generator = new GenUtils(this);
        this.itemSerializer = new ItemStackSerializer(this);
        this.inputUtils = new PlayerInputUtils(this);
        this.setupEconomy();
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
        this.plugin.getCommand("commandpanel").setExecutor((CommandExecutor)new PanelCommand(this));
        this.plugin.getCommand("commandpanel").setTabCompleter((TabCompleter)new PanelTabComplete(this));
        this.plugin.getCommand("commandpanelgenerate").setTabCompleter((TabCompleter)new GenTabComplete());
        this.plugin.getCommand("commandpanelgenerate").setExecutor((CommandExecutor)new GenerateCommand(this));
        this.plugin.getCommand("commandpaneldata").setTabCompleter((TabCompleter)new DataTabComplete(this));
        this.plugin.getCommand("commandpaneldata").setExecutor((CommandExecutor)new DataCommand(this));
        this.plugin.getCommand("commandpanelupdate").setTabCompleter((TabCompleter)new UpdateTabComplete());
        this.plugin.getCommand("commandpanelupdate").setExecutor((CommandExecutor)new UpdateCommand(this));
        this.plugin.getCommand("commandpanelimport").setExecutor((CommandExecutor)new ImportCommand(this));
        this.plugin.getCommand("commandpanelimport").setTabCompleter((TabCompleter)new ImportTabComplete(this));
        this.plugin.getCommand("commandpaneledit").setExecutor((CommandExecutor)new CommandPanelsEditor(this));
        this.plugin.getCommand("commandpaneledit").setTabCompleter((TabCompleter)new EditorTabComplete(this));
        this.plugin.getCommand("commandpanelreload").setExecutor((CommandExecutor)this.reloader);
        this.plugin.getCommand("commandpaneldebug").setExecutor((CommandExecutor)new DebugCommand(this));
        this.plugin.getCommand("commandpanelversion").setExecutor((CommandExecutor)new VersionCommand(this));
        this.plugin.getCommand("commandpanellist").setExecutor((CommandExecutor)new ListCommand(this));
        if (this.version.isAtLeast("1.12")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new EntityPickupEvent(this), (Plugin)this.plugin);
        } else {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new LegacyPlayerEvent(this), (Plugin)this.plugin);
        }
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new InteractionHandler(this), (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.inventorySaver, (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.inputUtils, (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.openCommands, (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new SessionUtils(this), (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.generator, (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new DroppedItemHandler(this), (Plugin)this.plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinEvent(this), (Plugin)this.plugin);
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("floodgate")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new OpenFloodgateGUI(this), (Plugin)this.plugin);
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPI(this).register();
        }
        if (this.configHandler.isTrue("updater.update-checks")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this.updater, (Plugin)this.plugin);
        }
        if (this.configHandler.isTrue("config.refresh-panels")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new PanelRefresher(this), (Plugin)this.plugin);
        }
        if (this.configHandler.isTrue("config.hotbar-items")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new HotbarEvents(this), (Plugin)this.plugin);
        }
        if (this.configHandler.isTrue("config.panel-blocks")) {
            Objects.requireNonNull(this.plugin.getCommand("commandpanelblock")).setExecutor((CommandExecutor)new BlockCommand(this));
            Objects.requireNonNull(this.plugin.getCommand("commandpanelblock")).setTabCompleter((TabCompleter)new BlockTabComplete(this));
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new BlockEvents(this), (Plugin)this.plugin);
        }
        if (!Bukkit.getVersion().contains("1.8")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new SwapItemEvent(this), (Plugin)this.plugin);
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("ChestSort")) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new UtilsChestSortEvent(this), (Plugin)this.plugin);
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider rsp;
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") != null && (rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.econ = (Economy)rsp.getProvider();
        }
    }
}

