/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class Maybe<T> {
    private Maybe() {
    }

    public static <T> Maybe<T> just(T value) {
        if (value == null) {
            return Just.NULL;
        }
        return new Just<T>(value);
    }

    public static <T> Maybe<T> nothing() {
        return Nothing.INSTANCE;
    }

    public abstract boolean isPresent();

    public abstract T get() throws NoSuchElementException;

    private static class Just<T>
    extends Maybe<T> {
        private static final Just NULL = new Just<Object>(null);
        private final T value;

        Just(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Just)) {
                return false;
            }
            Just that = (Just)obj;
            return Objects.equals(this.get(), that.get());
        }

        public String toString() {
            return "Just(" + this.value + ")";
        }
    }

    private static class Nothing
    extends Maybe {
        static Nothing INSTANCE = new Nothing();

        private Nothing() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        public Object get() throws NoSuchElementException {
            throw new NoSuchElementException("Nothing");
        }

        public String toString() {
            return "Nothing";
        }
    }
}

