/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Compat {
    private Compat() {
    }

    static void checkFromToIndex(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex must be 0 or greater.");
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex must not be greater than size.");
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex must be smaller than toIndex.");
        }
    }

    static void checkIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index out of range: " + index + ", range: [0-" + size + ")");
        }
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> mapOfEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static Stream<String> lines(String string) {
        return new BufferedReader(new StringReader(string)).lines();
    }

    public static <T> List<T> listCopy(Collection<T> coll) {
        return new ArrayList<T>(coll);
    }

    public static <T> List<T> listOf(T ... items) {
        return Collections.unmodifiableList(Arrays.asList(items));
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <T> List<T> singletonList(T item) {
        return Collections.singletonList(item);
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> action, Runnable emptyAction) {
        if (optional.isPresent()) {
            action.accept(optional.get());
        } else {
            emptyAction.run();
        }
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] data = new byte[4096];
            while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                outputStream.write(data, 0, bytesRead);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

