/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.utils;

import java.util.LinkedHashMap;
import java.util.Locale;

public class CaseInsensitiveMap<V>
extends LinkedHashMap<String, V> {
    @Override
    public V put(String key, V value) {
        if (key != null) {
            return super.put(key.toLowerCase(Locale.ROOT), value);
        }
        return super.put(null, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String || key == null) {
            return this.remove((String)key);
        }
        throw new IllegalArgumentException("Called CaseInsensitiveMap#remove(Object) with a key that is not a String. Instead got: " + key);
    }

    public V remove(String key) {
        if (key != null) {
            return super.remove(key.toLowerCase(Locale.ROOT));
        }
        return super.remove(null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key instanceof String || key == null) {
            return this.remove((String)key, value);
        }
        throw new IllegalArgumentException("Called CaseInsensitiveMap#remove(Object,Object) with a key that is not a String. Instead got: " + key);
    }

    public boolean remove(String key, Object value) {
        if (key != null) {
            return super.remove(key.toLowerCase(Locale.ROOT), value);
        }
        return super.remove(null, value);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String || key == null) {
            return this.get((String)key);
        }
        throw new IllegalArgumentException("Called CaseInsensitiveMap#get(Object) with a key that is not a String. Instead got: " + key);
    }

    public V get(String key) {
        if (key != null) {
            return super.get(key.toLowerCase(Locale.ROOT));
        }
        return super.get(null);
    }
}

