/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventoryHook;
import com.janboerman.invsee.spigot.perworldinventory.PwiCommandArgs;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import me.ebonjaeger.perworldinventory.Group;
import me.ebonjaeger.perworldinventory.data.ProfileKey;
import org.bukkit.GameMode;

public class ProfileId {
    final ProfileKey profileKey;

    public ProfileId(ProfileKey profileKey) {
        this.profileKey = Objects.requireNonNull(profileKey);
    }

    public ProfileId(PerWorldInventoryHook hook, PwiCommandArgs commandArgs, UUID playerId) {
        Group group;
        GameMode gameMode = commandArgs.gameMode;
        if (gameMode == null || !hook.pwiInventoriesPerGameMode()) {
            gameMode = GameMode.SURVIVAL;
        }
        if (commandArgs.group != null) {
            group = commandArgs.group;
            if (commandArgs.world != null) {
                group.addWorld(commandArgs.world);
            }
        } else {
            group = commandArgs.world != null ? hook.getGroupForWorld(commandArgs.world) : new Group("", Collections.emptySet(), gameMode, null);
        }
        this.profileKey = new ProfileKey(playerId, group, gameMode);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileId)) {
            return false;
        }
        ProfileId that = (ProfileId)o;
        return this.profileKey.equals((Object)that.profileKey);
    }

    public int hashCode() {
        return this.profileKey.hashCode();
    }

    public String toString() {
        return "ProfileId(" + this.profileKey.toString() + ")";
    }
}

