/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SaveResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.janboerman.invsee.spigot.internal.inventory.Personal;
import com.janboerman.invsee.spigot.perworldinventory.FakePlayer;
import com.janboerman.invsee.spigot.perworldinventory.PerWorldInventoryHook;
import com.janboerman.invsee.spigot.perworldinventory.ProfileId;
import com.janboerman.invsee.utils.Compat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import me.ebonjaeger.perworldinventory.Group;
import me.ebonjaeger.perworldinventory.data.PlayerProfile;
import me.ebonjaeger.perworldinventory.data.ProfileKey;
import me.ebonjaeger.perworldinventory.event.InventoryLoadCompleteEvent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PerWorldInventorySeeApi
extends InvseeAPI
implements InvseePlatform {
    private final InvseePlatform wrapped;
    private final PerWorldInventoryHook pwiHook;
    private final Map<ProfileKey, MainSpectatorInventory> inventories = new HashMap<ProfileKey, MainSpectatorInventory>();
    private final Map<MainSpectatorInventory, ProfileKey> inventoryKeys = new HashMap<MainSpectatorInventory, ProfileKey>();
    private final Map<ProfileKey, EnderSpectatorInventory> enderchests = new HashMap<ProfileKey, EnderSpectatorInventory>();
    private final Map<EnderSpectatorInventory, ProfileKey> enderchestKeys = new HashMap<EnderSpectatorInventory, ProfileKey>();
    private PwiEventListener pwiEventListener;
    private TiedInventoryListener tiedInventoryListener;
    private TiedPlayerListener tiedPlayerListener;
    private final OpenSpectatorsCache cache;
    private final Scheduler scheduler;

    public PerWorldInventorySeeApi(Plugin plugin, NamesAndUUIDs lookup, Scheduler scheduler, OpenSpectatorsCache cachedInventories, InvseePlatform wrapped, PerWorldInventoryHook pwiHook) {
        super(plugin, null, lookup, scheduler, cachedInventories);
        this.wrapped = Objects.requireNonNull(wrapped);
        this.pwiHook = Objects.requireNonNull(pwiHook);
        this.cache = Objects.requireNonNull(cachedInventories);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.setMainInventoryTransferPredicate((spectatorInventory, player) -> {
            if (!pwiHook.pwiManagedInventories()) {
                return true;
            }
            ProfileKey profileKey = this.inventoryKeys.get(spectatorInventory);
            if (profileKey == null) {
                return true;
            }
            return pwiHook.isMatchedByProfile((HumanEntity)player, profileKey);
        });
        this.setEnderChestTransferPredicate((spectatorInventory, player) -> {
            if (!pwiHook.pwiManagedEnderChests()) {
                return true;
            }
            ProfileKey profileKey = this.enderchestKeys.get(spectatorInventory);
            if (profileKey == null) {
                return true;
            }
            return pwiHook.isMatchedByProfile((HumanEntity)player, profileKey);
        });
    }

    @Override
    protected InvseePlatform getPlatform() {
        return this;
    }

    @Override
    public void registerListeners() {
        super.registerListeners();
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        this.pwiEventListener = new PwiEventListener();
        pluginManager.registerEvents((Listener)this.pwiEventListener, this.plugin);
        this.tiedInventoryListener = new TiedInventoryListener();
        pluginManager.registerEvents((Listener)this.tiedInventoryListener, this.plugin);
        this.tiedPlayerListener = new TiedPlayerListener();
        pluginManager.registerEvents((Listener)this.tiedPlayerListener, this.plugin);
    }

    @Override
    public void unregisterListeners() {
        HandlerList.unregisterAll((Listener)this.pwiEventListener);
        HandlerList.unregisterAll((Listener)this.tiedInventoryListener);
        HandlerList.unregisterAll((Listener)this.tiedPlayerListener);
        super.unregisterListeners();
    }

    public PerWorldInventoryHook getHook() {
        return this.pwiHook;
    }

    @Override
    public OpenResponse<MainSpectatorInventoryView> openMainSpectatorInventory(Player spectator, MainSpectatorInventory spectatorInventory, CreationOptions<PlayerInventorySlot> options) {
        return this.wrapped.openMainSpectatorInventory(spectator, spectatorInventory, options);
    }

    @Override
    public MainSpectatorInventory spectateInventory(HumanEntity player, CreationOptions<PlayerInventorySlot> options) {
        return this.wrapped.spectateInventory(player, options);
    }

    public MainSpectatorInventory spectateInventory(HumanEntity player, CreationOptions<PlayerInventorySlot> options, ProfileKey profileKey) {
        MainSpectatorInventory spectatorInv = this.spectateInventory(player, options);
        this.inventories.put(profileKey, spectatorInv);
        this.inventoryKeys.put(spectatorInv, profileKey);
        return spectatorInv;
    }

    public final CompletableFuture<SpectateResponse<MainSpectatorInventory>> spectateInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options, ProfileId profileId) {
        Player player = this.plugin.getServer().getPlayer(playerId);
        ProfileKey profileKey = profileId.profileKey;
        if (player != null && this.getHook().isMatchedByProfile((HumanEntity)player, profileKey)) {
            return CompletableFuture.completedFuture(SpectateResponse.succeed(this.spectateInventory((HumanEntity)player, options, profileKey)));
        }
        return this.createOfflineInventory(playerId, playerName, options, profileKey);
    }

    @Override
    public CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options) {
        Location logoutLocation = this.pwiHook.getDataSource().getLogout((Player)new FakePlayer(playerId, playerName, this.plugin.getServer()));
        World world = logoutLocation != null ? logoutLocation.getWorld() : (World)this.plugin.getServer().getWorlds().get(0);
        Group group = this.pwiHook.getGroupForWorld(world.getName());
        ProfileKey profileKey = new ProfileKey(playerId, group, GameMode.SURVIVAL);
        return this.createOfflineInventory(playerId, playerName, options, profileKey, false);
    }

    @Override
    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory inventory) {
        World logoutWorld;
        ProfileKey profileKey = this.inventoryKeys.get(inventory);
        boolean saveVanilla = false;
        Location location = null;
        Player target = this.plugin.getServer().getPlayer(inventory.getSpectatedPlayerId());
        if (target != null) {
            location = target.getLocation();
        }
        if (location == null) {
            location = this.pwiHook.getDataSource().getLogout((Player)new FakePlayer(inventory.getSpectatedPlayerId(), inventory.getSpectatedPlayerName(), this.plugin.getServer()));
        }
        World world = logoutWorld = location != null ? location.getWorld() : (World)this.plugin.getServer().getWorlds().get(0);
        assert (logoutWorld != null);
        if (profileKey == null) {
            saveVanilla = true;
            profileKey = new ProfileKey(inventory.getSpectatedPlayerId(), this.pwiHook.getGroupForWorld(logoutWorld.getName()), GameMode.SURVIVAL);
        } else if (!this.pwiHook.pwiLoadDataOnJoin() && profileKey.getGroup().containsWorld(logoutWorld.getName())) {
            saveVanilla = true;
        }
        return this.saveInventory(inventory, profileKey, saveVanilla);
    }

    @Override
    public OpenResponse<EnderSpectatorInventoryView> openEnderSpectatorInventory(Player spectator, EnderSpectatorInventory spectatorInventory, CreationOptions<EnderChestSlot> options) {
        return this.wrapped.openEnderSpectatorInventory(spectator, spectatorInventory, options);
    }

    @Override
    public EnderSpectatorInventory spectateEnderChest(HumanEntity player, CreationOptions<EnderChestSlot> options) {
        return this.wrapped.spectateEnderChest(player, options);
    }

    public EnderSpectatorInventory spectateEnderChest(HumanEntity player, CreationOptions<EnderChestSlot> options, ProfileKey profileKey) {
        EnderSpectatorInventory spectatorInv = this.spectateEnderChest(player, options);
        this.enderchests.put(profileKey, spectatorInv);
        this.enderchestKeys.put(spectatorInv, profileKey);
        return spectatorInv;
    }

    public final CompletableFuture<SpectateResponse<EnderSpectatorInventory>> spectateEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options, ProfileId profileId) {
        Player player = this.plugin.getServer().getPlayer(playerId);
        ProfileKey profileKey = profileId.profileKey;
        if (player != null && this.pwiHook.isMatchedByProfile((HumanEntity)player, profileKey)) {
            return CompletableFuture.completedFuture(SpectateResponse.succeed(this.spectateEnderChest((HumanEntity)player, options, profileKey)));
        }
        return this.createOfflineEnderChest(playerId, playerName, options, profileKey);
    }

    @Override
    public CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options) {
        Optional<EnderSpectatorInventory> cached = Optional.ofNullable(this.cache.getEnderSpectatorInventory(playerId));
        if (cached.isPresent()) {
            return CompletableFuture.completedFuture(SpectateResponse.succeed(cached.get()));
        }
        Location logoutLocation = this.pwiHook.getDataSource().getLogout((Player)new FakePlayer(playerId, playerName, this.plugin.getServer()));
        World world = logoutLocation != null ? logoutLocation.getWorld() : (World)this.plugin.getServer().getWorlds().get(0);
        Group group = this.pwiHook.getGroupForWorld(world.getName());
        ProfileKey profileKey = new ProfileKey(playerId, group, GameMode.SURVIVAL);
        return this.createOfflineEnderChest(playerId, playerName, options, profileKey, false);
    }

    @Override
    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory enderChest) {
        World logoutWorld;
        ProfileKey profileKey = this.inventoryKeys.get(enderChest);
        boolean saveVanilla = false;
        Location location = null;
        Player player = this.plugin.getServer().getPlayer(enderChest.getSpectatedPlayerId());
        if (player != null) {
            location = player.getLocation();
        }
        if (location == null) {
            location = this.pwiHook.getDataSource().getLogout((Player)new FakePlayer(enderChest.getSpectatedPlayerId(), enderChest.getSpectatedPlayerName(), this.plugin.getServer()));
        }
        World world = logoutWorld = location != null ? location.getWorld() : (World)this.plugin.getServer().getWorlds().get(0);
        if (profileKey == null) {
            saveVanilla = true;
            profileKey = new ProfileKey(enderChest.getSpectatedPlayerId(), this.pwiHook.getGroupForWorld(logoutWorld.getName()), GameMode.SURVIVAL);
        } else if (!this.pwiHook.pwiLoadDataOnJoin() && profileKey.getGroup().containsWorld(logoutWorld.getName())) {
            saveVanilla = true;
        }
        return this.saveEnderChest(enderChest, profileKey, saveVanilla);
    }

    public CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options, ProfileKey profileKey) {
        return this.createOfflineInventory(playerId, playerName, options, profileKey, this.pwiHook.isGroupManagedByPWI(profileKey.getGroup()));
    }

    private CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options, ProfileKey profileKey, boolean tieToProfile) {
        World logoutWorld;
        Target target = Target.byGameProfile(playerId, playerName);
        if (profileKey.getGroup().getWorlds().stream().anyMatch(world -> this.exempt.isExemptedFromHavingMainInventorySpectated(target, (String)world))) {
            return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(target)));
        }
        CompletableFuture<SpectateResponse<MainSpectatorInventory>> fromVanillaStorageOfflineInv = this.wrapped.createOfflineInventory(playerId, playerName, options);
        if (!this.pwiHook.pwiManagedInventories()) {
            return fromVanillaStorageOfflineInv;
        }
        FakePlayer player = new FakePlayer(playerId, playerName, this.plugin.getServer());
        PlayerInventory playerInv = player.getInventory();
        AtomicBoolean loadFromPWI = new AtomicBoolean(true);
        Location location = this.pwiHook.getDataSource().getLogout((Player)player);
        World world2 = logoutWorld = location != null ? location.getWorld() : (World)this.plugin.getServer().getWorlds().get(0);
        if (!this.pwiHook.pwiLoadDataOnJoin() && profileKey.getGroup().containsWorld(logoutWorld.getName())) {
            loadFromPWI.set(false);
        }
        return fromVanillaStorageOfflineInv.thenApplyAsync(optionalSpectatorInv -> {
            optionalSpectatorInv.ifSuccess(spectatorInv -> {
                playerInv.setStorageContents(spectatorInv.getStorageContents());
                playerInv.setArmorContents(spectatorInv.getArmourContents());
                playerInv.setExtraContents(spectatorInv.getOffHandContents());
                player.setItemOnCursor(spectatorInv.getCursorContents());
                if (loadFromPWI.get()) {
                    PlayerProfile profile = this.pwiHook.getOrCreateProfile(player, profileKey);
                    spectatorInv.setStorageContents(Arrays.copyOf(profile.getInventory(), 36));
                    spectatorInv.setArmourContents(Arrays.copyOfRange(profile.getInventory(), 36, 40));
                    spectatorInv.setOffHandContents(Arrays.copyOfRange(profile.getInventory(), 40, 41));
                }
                if (tieToProfile) {
                    this.inventoryKeys.put((MainSpectatorInventory)spectatorInv, profileKey);
                    this.inventories.put(profileKey, (MainSpectatorInventory)spectatorInv);
                }
            });
            return optionalSpectatorInv;
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
    }

    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory inventory, ProfileKey profileKey, boolean saveVanilla) {
        CompletableFuture<SaveResponse> vanillaTask;
        if (!this.pwiHook.pwiManagedInventories()) {
            return this.wrapped.saveInventory(inventory);
        }
        Player player = this.plugin.getServer().getPlayer(inventory.getSpectatedPlayerId());
        if (player == null) {
            player = new FakePlayer(inventory.getSpectatedPlayerId(), inventory.getSpectatedPlayerName(), this.plugin.getServer());
        }
        PlayerInventory playerInv = player.getInventory();
        playerInv.setStorageContents(inventory.getStorageContents());
        playerInv.setArmorContents(inventory.getArmourContents());
        playerInv.setItemInOffHand(inventory.getOffHandContents()[0]);
        player.setItemOnCursor(inventory.getCursorContents());
        PlayerProfile profile = this.pwiHook.getOrCreateProfile(player, profileKey);
        ItemStack[] profileArmour = inventory.getArmourContents();
        ItemStack[] profileInventory = new ItemStack[41];
        System.arraycopy(inventory.getStorageContents(), 0, profileInventory, 0, 36);
        System.arraycopy(inventory.getArmourContents(), 0, profileInventory, 36, 4);
        System.arraycopy(inventory.getOffHandContents(), 0, profileInventory, 40, 1);
        PlayerProfile updatedProfile = profile.copy(profileArmour, profile.getEnderChest(), profileInventory, profile.getAllowFlight(), profile.getDisplayName(), profile.getExhaustion(), profile.getExperience(), profile.isFlying(), profile.getFoodLevel(), profile.getMaxHealth(), profile.getHealth(), profile.getGameMode(), profile.getLevel(), profile.getSaturation(), profile.getPotionEffects(), profile.getFallDistance(), profile.getFireTicks(), profile.getMaximumAir(), profile.getRemainingAir(), profile.getBalance());
        this.pwiHook.getProfileCache().put((Object)profileKey, (Object)updatedProfile);
        CompletableFuture<Void> saveTask = CompletableFuture.runAsync(() -> this.pwiHook.getDataSource().savePlayer(profileKey, updatedProfile), this.scheduler::executeAsync);
        if (saveVanilla) {
            vanillaTask = this.wrapped.saveInventory(inventory);
            saveTask = CompletableFuture.allOf(saveTask, vanillaTask);
        } else {
            vanillaTask = null;
        }
        return saveTask.thenApply(_void -> vanillaTask == null ? SaveResponse.saved(inventory) : (SaveResponse)vanillaTask.join());
    }

    public CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options, ProfileKey profileKey) {
        return this.createOfflineEnderChest(playerId, playerName, options, profileKey, this.pwiHook.isGroupManagedByPWI(profileKey.getGroup()));
    }

    private CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options, ProfileKey profileKey, boolean tieToProfile) {
        World logoutWorld;
        Target target = Target.byGameProfile(playerId, playerName);
        if (profileKey.getGroup().getWorlds().stream().anyMatch(world -> this.exempt.isExemptedFromHavingEnderchestSpectated(target, (String)world))) {
            return CompletableFuture.completedFuture(SpectateResponse.fail(NotCreatedReason.targetHasExemptPermission(target)));
        }
        CompletableFuture<SpectateResponse<EnderSpectatorInventory>> nonPwiEnderSpectatorFuture = this.wrapped.createOfflineEnderChest(playerId, playerName, options);
        if (!this.pwiHook.pwiManagedEnderChests()) {
            return nonPwiEnderSpectatorFuture;
        }
        FakePlayer player = new FakePlayer(playerId, playerName, this.plugin.getServer());
        Inventory enderInv = player.getEnderChest();
        AtomicBoolean loadFromPWI = new AtomicBoolean(true);
        Location location = this.pwiHook.getDataSource().getLogout((Player)player);
        World world2 = logoutWorld = location != null ? location.getWorld() : (World)this.plugin.getServer().getWorlds().get(0);
        if (!this.pwiHook.pwiLoadDataOnJoin() && profileKey.getGroup().containsWorld(logoutWorld.getName())) {
            loadFromPWI.set(false);
        }
        return nonPwiEnderSpectatorFuture.thenApplyAsync(optionalSpectatorInv -> {
            optionalSpectatorInv.ifSuccess(spectatorInv -> {
                enderInv.setStorageContents(spectatorInv.getStorageContents());
                if (loadFromPWI.get()) {
                    PlayerProfile profile = this.pwiHook.getOrCreateProfile(player, profileKey);
                    spectatorInv.setStorageContents(profile.getEnderChest());
                }
                if (tieToProfile) {
                    this.enderchestKeys.put((EnderSpectatorInventory)spectatorInv, profileKey);
                    this.enderchests.put(profileKey, (EnderSpectatorInventory)spectatorInv);
                }
            });
            return optionalSpectatorInv;
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
    }

    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory enderChest, ProfileKey profileKey, boolean saveVanilla) {
        CompletableFuture<SaveResponse> vanillaTask;
        if (!this.pwiHook.pwiManagedEnderChests()) {
            return this.wrapped.saveEnderChest(enderChest);
        }
        FakePlayer fakePlayer = new FakePlayer(enderChest.getSpectatedPlayerId(), enderChest.getSpectatedPlayerName(), this.plugin.getServer());
        Inventory playerEC = fakePlayer.getEnderChest();
        playerEC.setStorageContents(enderChest.getStorageContents());
        PlayerProfile profile = this.pwiHook.getOrCreateProfile(fakePlayer, profileKey);
        ItemStack[] profileEnderChest = enderChest.getStorageContents();
        PlayerProfile updatedProfile = profile.copy(profile.getArmor(), profileEnderChest, profile.getInventory(), profile.getAllowFlight(), profile.getDisplayName(), profile.getExhaustion(), profile.getExperience(), profile.isFlying(), profile.getFoodLevel(), profile.getMaxHealth(), profile.getHealth(), profile.getGameMode(), profile.getLevel(), profile.getSaturation(), profile.getPotionEffects(), profile.getFallDistance(), profile.getFireTicks(), profile.getMaximumAir(), profile.getRemainingAir(), profile.getBalance());
        this.pwiHook.getProfileCache().put((Object)profileKey, (Object)updatedProfile);
        CompletableFuture<Void> saveTask = CompletableFuture.runAsync(() -> this.pwiHook.getDataSource().savePlayer(profileKey, updatedProfile), this.scheduler::executeAsync);
        if (saveVanilla) {
            vanillaTask = this.wrapped.saveEnderChest(enderChest);
            saveTask = CompletableFuture.allOf(saveTask, vanillaTask);
        } else {
            vanillaTask = null;
        }
        return saveTask.thenApply(_void -> vanillaTask == null ? SaveResponse.saved(enderChest) : (SaveResponse)vanillaTask.join());
    }

    private <Slot, S extends SpectatorInventory<Slot>> Optional<S> asLiveInventory(S snapshotInventory, boolean transferToLiveInventory) {
        assert (this.plugin.getServer().isPrimaryThread()) : "can't call asLiveInventory asynchronously";
        Player player = this.plugin.getServer().getPlayer(snapshotInventory.getSpectatedPlayerId());
        if (player == null) {
            return Optional.empty();
        }
        String title = snapshotInventory.getTitle();
        SpectatorInventory<PlayerInventorySlot> live = null;
        if (snapshotInventory instanceof MainSpectatorInventory) {
            Mirror<PlayerInventorySlot> mirror = snapshotInventory.getMirror();
            live = this.spectateInventory((HumanEntity)player, title, mirror);
        } else if (snapshotInventory instanceof EnderSpectatorInventory) {
            Mirror<EnderChestSlot> mirror = snapshotInventory.getMirror();
            live = this.spectateEnderChest((HumanEntity)player, title, mirror);
        } else {
            throw new RuntimeException("Unreachable");
        }
        if (transferToLiveInventory) {
            live.setContents(snapshotInventory.getContents());
        }
        return Optional.of(live);
    }

    private <S extends SpectatorInventory> CompletableFuture<Optional<S>> asSnapShotInventory(S liveSpectatorInventory) {
        assert (this.plugin.getServer().isPrimaryThread()) : "can't call asSnapShotInventory asynchronously";
        UUID id = liveSpectatorInventory.getSpectatedPlayerId();
        String name = liveSpectatorInventory.getSpectatedPlayerName();
        Player player = this.plugin.getServer().getPlayer(id);
        if (player == null) {
            return CompletableFuture.completedFuture(Optional.of(liveSpectatorInventory));
        }
        ProfileKey profileKey = this.inventoryKeys.get(liveSpectatorInventory);
        if (profileKey != null && !this.pwiHook.isMatchedByProfile((HumanEntity)player, profileKey)) {
            return CompletableFuture.completedFuture(Optional.of(liveSpectatorInventory));
        }
        if (profileKey == null) {
            profileKey = this.pwiHook.getActiveProfileKey((HumanEntity)player);
        }
        Target target = Target.byPlayer((HumanEntity)player);
        String title = liveSpectatorInventory.getTitle();
        if (liveSpectatorInventory instanceof MainSpectatorInventory) {
            MainSpectatorInventory liveSpectator = (MainSpectatorInventory)liveSpectatorInventory;
            Mirror<PlayerInventorySlot> mirror = liveSpectator.getMirror();
            CreationOptions<PlayerInventorySlot> options = CreationOptions.defaultMainInventory().withTitle(title).withMirror(mirror);
            return (CompletableFuture)this.createOfflineInventory(id, name, options, profileKey).thenApplyAsync(Function.identity(), runnable -> this.scheduler.executeSyncPlayer(id, runnable, null));
        }
        if (liveSpectatorInventory instanceof EnderSpectatorInventory) {
            EnderSpectatorInventory liveSpectator = (EnderSpectatorInventory)liveSpectatorInventory;
            Mirror<EnderChestSlot> mirror = liveSpectator.getMirror();
            CreationOptions<EnderChestSlot> options = CreationOptions.defaultEnderInventory().withTitle(title).withMirror(mirror);
            return (CompletableFuture)this.createOfflineEnderChest(id, name, options, profileKey).thenApplyAsync(Function.identity(), runnable -> this.scheduler.executeSyncPlayer(id, runnable, null));
        }
        assert (false) : "Unreachable: liveSpectatorInventory is neither a MainSpectatorInventory nor EnderSpectatorInventory";
        return CompletedEmpty.the();
    }

    private final class PwiEventListener
    implements Listener {
        private PwiEventListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onTeleport(PlayerTeleportEvent event) {
            if (PerWorldInventorySeeApi.this.pwiHook.bypassesWorldChange(event.getPlayer())) {
                return;
            }
            World from = event.getFrom().getWorld();
            assert (from != null);
            World to = event.getTo().getWorld();
            assert (to != null);
            if (!from.equals((Object)to) && !PerWorldInventorySeeApi.this.pwiHook.worldsShareInventory(from.toString(), to.toString())) {
                this.giveSnapshotInventoryToSpectators(PerWorldInventorySeeApi.this.pwiHook.getActiveProfileKey((HumanEntity)event.getPlayer()));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onGameModeChange(PlayerGameModeChangeEvent event) {
            if (PerWorldInventorySeeApi.this.pwiHook.bypassesGameModeChange(event.getPlayer())) {
                return;
            }
            if (PerWorldInventorySeeApi.this.pwiHook.pwiInventoriesPerGameMode()) {
                this.giveSnapshotInventoryToSpectators(PerWorldInventorySeeApi.this.pwiHook.getActiveProfileKey((HumanEntity)event.getPlayer()));
            }
        }

        private void giveSnapshotInventoryToSpectators(ProfileKey oldProfileKey) {
            CompletableFuture snapshotFuture;
            ItemStack[] contents;
            ArrayList viewers;
            MainSpectatorInventory mainSpectator = (MainSpectatorInventory)PerWorldInventorySeeApi.this.inventories.get(oldProfileKey);
            EnderSpectatorInventory enderSpectator = (EnderSpectatorInventory)PerWorldInventorySeeApi.this.enderchests.get(oldProfileKey);
            if (mainSpectator != null) {
                viewers = new ArrayList(mainSpectator.getViewers());
                contents = mainSpectator.getContents();
                viewers.forEach(HumanEntity::closeInventory);
                snapshotFuture = PerWorldInventorySeeApi.this.asSnapShotInventory(mainSpectator);
                snapshotFuture.thenAccept(optional -> Compat.ifPresentOrElse(optional, newSpectatorInventory -> {
                    PerWorldInventorySeeApi.this.inventories.put(oldProfileKey, newSpectatorInventory);
                    PerWorldInventorySeeApi.this.inventoryKeys.put(newSpectatorInventory, oldProfileKey);
                    newSpectatorInventory.setContents(contents);
                    viewers.forEach(v -> v.openInventory((Inventory)newSpectatorInventory));
                }, () -> PerWorldInventorySeeApi.this.inventories.remove(oldProfileKey)));
            }
            if (enderSpectator != null) {
                viewers = new ArrayList(enderSpectator.getViewers());
                contents = enderSpectator.getContents();
                snapshotFuture = PerWorldInventorySeeApi.this.asSnapShotInventory(enderSpectator);
                snapshotFuture.thenAccept(optional -> Compat.ifPresentOrElse(optional, newSpectatorInventory -> {
                    PerWorldInventorySeeApi.this.enderchests.put(oldProfileKey, newSpectatorInventory);
                    PerWorldInventorySeeApi.this.enderchestKeys.put(newSpectatorInventory, oldProfileKey);
                    newSpectatorInventory.setContents(contents);
                    viewers.forEach(v -> v.openInventory((Inventory)newSpectatorInventory));
                }, () -> PerWorldInventorySeeApi.this.enderchests.remove(oldProfileKey)));
            }
        }

        @EventHandler
        public void onPwiLoadComplete(InventoryLoadCompleteEvent event) {
            ProfileKey newProfileKey = new ProfileKey(event.getPlayer().getUniqueId(), event.getGroup(), event.getGameMode());
            this.giveLiveInventoryToSpectators(newProfileKey);
        }

        private void giveLiveInventoryToSpectators(ProfileKey newProfileKey) {
            Executor executor;
            ItemStack[] contents;
            ArrayList viewers;
            MainSpectatorInventory mainSpectator = (MainSpectatorInventory)PerWorldInventorySeeApi.this.inventories.get(newProfileKey);
            EnderSpectatorInventory enderSpectator = (EnderSpectatorInventory)PerWorldInventorySeeApi.this.enderchests.get(newProfileKey);
            if (mainSpectator != null) {
                viewers = new ArrayList(mainSpectator.getViewers());
                contents = mainSpectator.getContents();
                viewers.forEach(HumanEntity::closeInventory);
                executor = runnable -> PerWorldInventorySeeApi.this.scheduler.executeSyncPlayer(newProfileKey.getUuid(), runnable, null);
                executor.execute(() -> {
                    Optional liveFuture = PerWorldInventorySeeApi.this.asLiveInventory(mainSpectator, false);
                    Compat.ifPresentOrElse(liveFuture, liveSpectator -> {
                        PerWorldInventorySeeApi.this.inventories.put(newProfileKey, liveSpectator);
                        PerWorldInventorySeeApi.this.inventoryKeys.put(liveSpectator, newProfileKey);
                        liveSpectator.setContents(contents);
                        viewers.forEach(v -> v.openInventory((Inventory)liveSpectator));
                    }, () -> PerWorldInventorySeeApi.this.inventories.remove(newProfileKey));
                });
            }
            if (enderSpectator != null) {
                viewers = new ArrayList(enderSpectator.getViewers());
                contents = enderSpectator.getContents();
                viewers.forEach(HumanEntity::closeInventory);
                executor = runnable -> PerWorldInventorySeeApi.this.scheduler.executeSyncPlayer(newProfileKey.getUuid(), runnable, null);
                executor.execute(() -> {
                    Optional liveFuture = PerWorldInventorySeeApi.this.asLiveInventory(enderSpectator, false);
                    Compat.ifPresentOrElse(liveFuture, liveSpectator -> {
                        PerWorldInventorySeeApi.this.enderchests.put(newProfileKey, liveSpectator);
                        PerWorldInventorySeeApi.this.enderchestKeys.put(liveSpectator, newProfileKey);
                        liveSpectator.setContents(contents);
                        viewers.forEach(v -> v.openInventory((Inventory)liveSpectator));
                    }, () -> PerWorldInventorySeeApi.this.inventories.remove(newProfileKey));
                });
            }
        }
    }

    private final class TiedInventoryListener
    implements Listener {
        private TiedInventoryListener() {
        }

        @EventHandler
        public void onSpectatorClose(InventoryCloseEvent event) {
            Inventory inventory = event.getInventory();
            if (inventory instanceof MainSpectatorInventory) {
                MainSpectatorInventory main = (MainSpectatorInventory)inventory;
                ProfileKey key = (ProfileKey)PerWorldInventorySeeApi.this.inventoryKeys.get(main);
                if (key != null) {
                    PerWorldInventorySeeApi.this.scheduler.executeLaterGlobal(() -> {
                        if (main.getViewers().isEmpty()) {
                            PerWorldInventorySeeApi.this.inventories.remove(key, main);
                            PerWorldInventorySeeApi.this.inventoryKeys.remove(main, key);
                        }
                    }, 100L);
                }
            } else if (inventory instanceof EnderSpectatorInventory) {
                EnderSpectatorInventory ender = (EnderSpectatorInventory)inventory;
                ProfileKey key = (ProfileKey)PerWorldInventorySeeApi.this.enderchestKeys.get(ender);
                if (key != null) {
                    PerWorldInventorySeeApi.this.scheduler.executeLaterGlobal(() -> {
                        if (ender.getViewers().isEmpty()) {
                            PerWorldInventorySeeApi.this.enderchests.remove(key, ender);
                            PerWorldInventorySeeApi.this.enderchestKeys.remove(ender, key);
                        }
                    }, 100L);
                }
            }
        }

        @EventHandler
        public void onTargetInventoryOpen(InventoryOpenEvent event) {
            MainSpectatorInventory spectator;
            HumanEntity player = event.getPlayer();
            ProfileKey activeProfileKey = PerWorldInventorySeeApi.this.pwiHook.getActiveProfileKey(player);
            MainSpectatorInventory mainSpectator = (MainSpectatorInventory)PerWorldInventorySeeApi.this.inventories.get(activeProfileKey);
            if (mainSpectator instanceof Personal) {
                ((Personal)((Object)mainSpectator)).watch(event.getView());
            }
            if ((spectator = PerWorldInventorySeeApi.this.cache.getMainSpectatorInventory(player.getUniqueId())) instanceof Personal) {
                ((Personal)((Object)spectator)).watch(event.getView());
            }
        }

        @EventHandler
        public void onTargetInventoryClose(InventoryCloseEvent event) {
            MainSpectatorInventory spectator;
            HumanEntity player = event.getPlayer();
            ProfileKey activeProfileKey = PerWorldInventorySeeApi.this.pwiHook.getActiveProfileKey(player);
            MainSpectatorInventory mainSpectator = (MainSpectatorInventory)PerWorldInventorySeeApi.this.inventories.get(activeProfileKey);
            if (mainSpectator instanceof Personal) {
                ((Personal)((Object)mainSpectator)).unwatch();
            }
            if ((spectator = PerWorldInventorySeeApi.this.cache.getMainSpectatorInventory(player.getUniqueId())) instanceof Personal) {
                ((Personal)((Object)spectator)).unwatch();
            }
        }
    }

    private final class TiedPlayerListener
    implements Listener {
        private TiedPlayerListener() {
        }

        @EventHandler
        public void onTargetQuit(PlayerQuitEvent event) {
            EnderSpectatorInventory enderSpectator;
            Player player = event.getPlayer();
            ProfileKey key = PerWorldInventorySeeApi.this.pwiHook.getActiveProfileKey((HumanEntity)player);
            MainSpectatorInventory mainSpectator = (MainSpectatorInventory)PerWorldInventorySeeApi.this.inventories.get(key);
            if (mainSpectator != null && mainSpectator.getViewers().isEmpty()) {
                PerWorldInventorySeeApi.this.inventories.remove(key);
                PerWorldInventorySeeApi.this.inventoryKeys.remove(mainSpectator, key);
            }
            if ((enderSpectator = (EnderSpectatorInventory)PerWorldInventorySeeApi.this.enderchests.get(key)) != null && enderSpectator.getViewers().isEmpty()) {
                PerWorldInventorySeeApi.this.enderchests.remove(key);
                PerWorldInventorySeeApi.this.enderchestKeys.remove(enderSpectator, key);
            }
        }
    }
}

