/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import com.google.common.cache.Cache;
import java.io.File;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import me.ebonjaeger.perworldinventory.Group;
import me.ebonjaeger.perworldinventory.GroupManager;
import me.ebonjaeger.perworldinventory.PerWorldInventory;
import me.ebonjaeger.perworldinventory.api.PerWorldInventoryAPI;
import me.ebonjaeger.perworldinventory.configuration.PlayerSettings;
import me.ebonjaeger.perworldinventory.configuration.PluginSettings;
import me.ebonjaeger.perworldinventory.configuration.Settings;
import me.ebonjaeger.perworldinventory.data.DataSource;
import me.ebonjaeger.perworldinventory.data.PlayerProfile;
import me.ebonjaeger.perworldinventory.data.ProfileFactory;
import me.ebonjaeger.perworldinventory.data.ProfileKey;
import me.ebonjaeger.perworldinventory.data.ProfileManager;
import me.ebonjaeger.perworldinventory.permission.PlayerPermission;
import me.ebonjaeger.perworldinventory.service.EconomyService;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerWorldInventoryHook {
    final Plugin plugin;
    private PerWorldInventory perWorldInventory;
    private PerWorldInventoryAPI api;
    private Settings settings;
    private ProfileManager profileManager;
    private DataSource dataSource;
    private ProfileFactory profileFactory;
    private Cache<ProfileKey, PlayerProfile> profileCache;
    private GroupManager groupManager;
    private EconomyService economyService;

    public PerWorldInventoryHook(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean trySetup() {
        boolean success;
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Plugin pwi = pluginManager.getPlugin("PerWorldInventory");
        boolean bl = success = pwi != null && pwi.isEnabled();
        if (success) {
            this.perWorldInventory = (PerWorldInventory)pwi;
            this.api = this.perWorldInventory.getApi();
            this.getGroupManager().loadGroups();
        }
        return success;
    }

    public boolean managesEitherInventory() {
        return this.pwiManagedInventories() || this.pwiManagedEnderChests();
    }

    protected PerWorldInventoryAPI getPerWorldInventoryAPI() {
        return this.api;
    }

    protected Settings getSettings() {
        if (this.settings != null) {
            return this.settings;
        }
        try {
            Field field = PerWorldInventoryAPI.class.getDeclaredField("settings");
            field.setAccessible(true);
            this.settings = (Settings)field.get(this.getPerWorldInventoryAPI());
            return this.settings;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.settings = Settings.Companion.create(new File(this.perWorldInventory.getDataFolder(), "config.yml"));
            return this.settings;
        }
    }

    protected GroupManager getGroupManager() {
        if (this.groupManager != null) {
            return this.groupManager;
        }
        try {
            Field field = PerWorldInventoryAPI.class.getDeclaredField("groupManager");
            field.setAccessible(true);
            this.groupManager = (GroupManager)field.get(this.getPerWorldInventoryAPI());
            return this.groupManager;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ProfileManager getProfileManager() {
        if (this.profileManager != null) {
            return this.profileManager;
        }
        try {
            Field field = PerWorldInventoryAPI.class.getDeclaredField("profileManager");
            field.setAccessible(true);
            this.profileManager = (ProfileManager)field.get(this.api);
            return this.profileManager;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected DataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        try {
            Field field = ProfileManager.class.getDeclaredField("dataSource");
            field.setAccessible(true);
            this.dataSource = (DataSource)field.get(this.getProfileManager());
            return this.dataSource;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected EconomyService getEconomyService() {
        if (this.economyService != null) {
            return this.economyService;
        }
        try {
            Field field = ProfileManager.class.getDeclaredField("economyService");
            field.setAccessible(true);
            this.economyService = (EconomyService)field.get(this.getProfileManager());
            return this.economyService;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ProfileFactory getProfileFactory() {
        if (this.profileFactory != null) {
            return this.profileFactory;
        }
        try {
            Field field = ProfileManager.class.getDeclaredField("profileFactory");
            field.setAccessible(true);
            this.profileFactory = (ProfileFactory)field.get(this.getProfileManager());
            return this.profileFactory;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Cache<ProfileKey, PlayerProfile> getProfileCache() {
        if (this.profileCache != null) {
            return this.profileCache;
        }
        try {
            Field field = ProfileManager.class.getDeclaredField("profileCache");
            field.setAccessible(true);
            this.profileCache = (Cache)field.get(this.getProfileManager());
            return this.profileCache;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PlayerProfile getOrCreateProfile(Player player, ProfileKey profileKey) {
        Cache<ProfileKey, PlayerProfile> cache = this.getProfileCache();
        try {
            return (PlayerProfile)cache.get((Object)profileKey, () -> {
                PlayerProfile loaded = this.getDataSource().getPlayer(profileKey, player);
                if (loaded != null) {
                    return loaded;
                }
                return this.getProfileFactory().create(player);
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PlayerProfile getOrCreateProfile(Player player, Group group, GameMode gameMode) {
        if (!this.pwiInventoriesPerGameMode()) {
            gameMode = GameMode.SURVIVAL;
        }
        ProfileKey profileKey = new ProfileKey(player.getUniqueId(), group, gameMode);
        return this.getOrCreateProfile(player, profileKey);
    }

    @Nullable
    public Group getGroupByName(String group) {
        return this.getPerWorldInventoryAPI().getGroup(group);
    }

    @NotNull
    public Group getGroupForWorld(String world) {
        return this.getPerWorldInventoryAPI().getGroupFromWorld(world);
    }

    public boolean worldsShareInventory(String world1, String world2) {
        return this.getPerWorldInventoryAPI().canWorldsShare(world1, world2);
    }

    public ProfileKey getActiveProfileKey(HumanEntity player) {
        GameMode gameMode = this.pwiInventoriesPerGameMode() ? player.getGameMode() : GameMode.SURVIVAL;
        Group group = this.getGroupForWorld(player.getWorld().getName());
        UUID uuid = player.getUniqueId();
        return new ProfileKey(uuid, group, gameMode);
    }

    public boolean isMatchedByProfile(HumanEntity player, ProfileKey profileKey) {
        return this.isMatchedByProfile(player.getUniqueId(), player.getWorld().getName(), player.getGameMode(), profileKey);
    }

    public boolean isMatchedByProfile(UUID playerId, Group group, GameMode gameMode, ProfileKey profileKey) {
        return profileKey.getUuid().equals(playerId) && profileKey.getGroup().getWorlds().equals(group.getWorlds()) && (!this.pwiInventoriesPerGameMode() || profileKey.getGameMode() == gameMode);
    }

    public boolean isMatchedByProfile(UUID playerId, String world, GameMode gameMode, ProfileKey profileKey) {
        return profileKey.getUuid().equals(playerId) && profileKey.getGroup().getWorlds().contains(world) && (!this.pwiInventoriesPerGameMode() || profileKey.getGameMode() == gameMode);
    }

    public boolean isWorldManagedByPWI(String world) {
        return this.pwiUnmanagedWorldsSameGroup() || this.getGroupManager().getGroups().values().stream().anyMatch(g2 -> g2.getWorlds().contains(world));
    }

    public boolean isGroupManagedByPWI(String group) {
        Group g2 = this.getGroupByName(group);
        if (g2 == null) {
            return false;
        }
        return this.isGroupManagedByPWI(g2);
    }

    public boolean isGroupManagedByPWI(Group group) {
        return group.getConfigured();
    }

    public boolean bypassesGameModeChange(Player player) {
        return !this.pwiBypassDisabled() && player.hasPermission(PlayerPermission.BYPASS_GAMEMODE.getNode());
    }

    public boolean bypassesWorldChange(Player player) {
        return !this.pwiBypassDisabled() && player.hasPermission(PlayerPermission.BYPASS_WORLDS.getNode());
    }

    public boolean pwiManagedInventories() {
        return (Boolean)this.getSettings().getProperty(PlayerSettings.LOAD_INVENTORY);
    }

    public boolean pwiManagedEnderChests() {
        return (Boolean)this.getSettings().getProperty(PlayerSettings.LOAD_ENDER_CHEST);
    }

    public boolean pwiBypassDisabled() {
        return (Boolean)this.getSettings().getProperty(PluginSettings.DISABLE_BYPASS);
    }

    public boolean pwiInventoriesPerGameMode() {
        return (Boolean)this.getSettings().getProperty(PluginSettings.SEPARATE_GM_INVENTORIES);
    }

    public boolean pwiUnmanagedWorldsSameGroup() {
        return (Boolean)this.getSettings().getProperty(PluginSettings.SHARE_IF_UNCONFIGURED);
    }

    public boolean pwiLoadDataOnJoin() {
        return (Boolean)this.getSettings().getProperty(PluginSettings.LOAD_DATA_ON_JOIN);
    }
}

