/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import com.janboerman.invsee.spigot.perworldinventory.FakeInventory;
import java.util.Arrays;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakePlayerInventory
extends FakeInventory
implements PlayerInventory,
EntityEquipment {
    private float itemInHandDropChance = 1.0f;
    private float itemInMainHandDropChance = 1.0f;
    private float itemInOffHandDropChance = 1.0f;
    private float helmetDropChance = 1.0f;
    private float chestPlateDropChance = 1.0f;
    private float leggingsDropChance = 1.0f;
    private float bootsDropChance = 1.0f;
    private int mainHandIndex;

    public FakePlayerInventory(ItemStack[] items, HumanEntity player) {
        super(InventoryType.PLAYER, items, (InventoryHolder)player);
        assert (items.length == 41) : "player inventory items length must equal 41!";
    }

    @Override
    public ItemStack[] getStorageContents() {
        return Arrays.copyOf(this.items, 36);
    }

    @Override
    public void setStorageContents(ItemStack[] itemStacks) {
        System.arraycopy(itemStacks, 0, this.items, 0, 36);
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.items[this.mainHandIndex];
    }

    public void setItemInMainHand(@Nullable ItemStack itemStack) {
        this.items[this.mainHandIndex] = itemStack;
    }

    public void setItemInMainHand(@Nullable ItemStack itemStack, boolean silent) {
        this.setItemInMainHand(itemStack);
    }

    @NotNull
    public ItemStack[] getArmorContents() {
        return Arrays.copyOfRange(this.items, 36, 40);
    }

    @NotNull
    public ItemStack[] getExtraContents() {
        return Arrays.copyOfRange(this.items, 40, 41);
    }

    public void setExtraContents(@Nullable ItemStack[] itemStacks) {
        System.arraycopy(itemStacks, 0, this.items, 40, 1);
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.items[40];
    }

    public void setItemInOffHand(@Nullable ItemStack itemStack) {
        this.items[40] = itemStack;
    }

    public void setItemInOffHand(@Nullable ItemStack itemStack, boolean silent) {
        this.setItemInOffHand(itemStack);
    }

    @Nullable
    public ItemStack getHelmet() {
        return this.items[39];
    }

    public void setHelmet(@Nullable ItemStack itemStack) {
        this.items[39] = itemStack;
    }

    public void setHelmet(@Nullable ItemStack itemStack, boolean silent) {
        this.setHelmet(itemStack);
    }

    @Nullable
    public ItemStack getChestplate() {
        return this.items[38];
    }

    public void setChestplate(@Nullable ItemStack itemStack) {
        this.items[38] = itemStack;
    }

    public void setChestplate(@Nullable ItemStack itemStack, boolean silent) {
        this.setChestplate(itemStack);
    }

    @Nullable
    public ItemStack getLeggings() {
        return this.items[37];
    }

    public void setLeggings(@Nullable ItemStack itemStack) {
        this.items[37] = itemStack;
    }

    public void setLeggings(@Nullable ItemStack itemStack, boolean silent) {
        this.setLeggings(itemStack);
    }

    @Nullable
    public ItemStack getBoots() {
        return this.items[36];
    }

    public void setBoots(@Nullable ItemStack itemStack) {
        this.items[36] = itemStack;
    }

    public void setBoots(@Nullable ItemStack itemStack, boolean silent) {
        this.setBoots(itemStack);
    }

    public void setItem(@NotNull EquipmentSlot equipmentSlot, @Nullable ItemStack itemStack) {
        switch (equipmentSlot) {
            case FEET: {
                this.setBoots(itemStack);
                break;
            }
            case LEGS: {
                this.setLeggings(itemStack);
                break;
            }
            case CHEST: {
                this.setChestplate(itemStack);
                break;
            }
            case HEAD: {
                this.setHelmet(itemStack);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(itemStack);
                break;
            }
            case HAND: {
                this.setItemInMainHand(itemStack);
            }
        }
    }

    public void setItem(@NotNull EquipmentSlot equipmentSlot, @Nullable ItemStack itemStack, boolean silent) {
        this.setItem(equipmentSlot, itemStack);
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot equipmentSlot) {
        switch (equipmentSlot) {
            case FEET: {
                return this.getBoots();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case CHEST: {
                return this.getChestplate();
            }
            case HEAD: {
                return this.getHelmet();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
            case HAND: {
                return this.getItemInMainHand();
            }
        }
        return null;
    }

    public void setArmorContents(@Nullable ItemStack[] itemStacks) {
        System.arraycopy(itemStacks, 0, this.items, 36, 4);
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(@Nullable ItemStack itemStack) {
        this.setItemInMainHand(itemStack);
    }

    public int getHeldItemSlot() {
        return this.mainHandIndex;
    }

    public void setHeldItemSlot(int i) {
        if (i < 0 || i >= 9) {
            throw new IllegalArgumentException("held item slot must be in range of 0-8 (inclusive)");
        }
        this.mainHandIndex = i;
    }

    public void forEach(Consumer<? super ItemStack> action) {
        for (ItemStack itemStack : this.items) {
            action.accept((ItemStack)itemStack);
        }
    }

    public Spliterator<ItemStack> spliterator() {
        return Spliterators.spliterator(this.items, 16);
    }

    public HumanEntity getHolder() {
        return (HumanEntity)super.getHolder();
    }

    public float getItemInHandDropChance() {
        return this.itemInHandDropChance;
    }

    public void setItemInHandDropChance(float v) {
        this.itemInHandDropChance = v;
        this.setItemInMainHandDropChance(v);
        this.setItemInOffHandDropChance(v);
    }

    public float getItemInMainHandDropChance() {
        return this.itemInMainHandDropChance;
    }

    public void setItemInMainHandDropChance(float v) {
        this.itemInMainHandDropChance = v;
    }

    public float getItemInOffHandDropChance() {
        return this.itemInOffHandDropChance;
    }

    public void setItemInOffHandDropChance(float v) {
        this.itemInOffHandDropChance = v;
    }

    public float getHelmetDropChance() {
        return this.helmetDropChance;
    }

    public void setHelmetDropChance(float v) {
        this.helmetDropChance = v;
    }

    public float getChestplateDropChance() {
        return this.chestPlateDropChance;
    }

    public void setChestplateDropChance(float v) {
        this.chestPlateDropChance = v;
    }

    public float getLeggingsDropChance() {
        return this.leggingsDropChance;
    }

    public void setLeggingsDropChance(float v) {
        this.leggingsDropChance = v;
    }

    public float getBootsDropChance() {
        return this.bootsDropChance;
    }

    public void setBootsDropChance(float v) {
        this.bootsDropChance = v;
    }
}

