/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.perworldinventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeInventory
implements Inventory {
    protected final InventoryType type;
    protected final ItemStack[] items;
    protected final InventoryHolder holder;
    private int maxStack = 64;
    private List<HumanEntity> viewers;

    public FakeInventory(InventoryType type, ItemStack[] items, InventoryHolder holder) {
        this.type = type;
        this.items = items;
        this.holder = holder;
    }

    public int getSize() {
        return this.items.length;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public void setMaxStackSize(int i) {
        this.maxStack = i;
    }

    @Nullable
    public ItemStack getItem(int i) {
        return this.items[i];
    }

    public void setItem(int i, @Nullable ItemStack itemStack) {
        this.items[i] = itemStack;
    }

    @NotNull
    public HashMap<Integer, ItemStack> addItem(ItemStack ... itemStacks) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> result = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack toAdd = itemStacks[i];
            if (toAdd == null || toAdd.getType().isAir()) continue;
            for (int j = 0; j < this.getStorageContents().length; ++j) {
                ItemStack inSlot = this.items[j];
                if (inSlot == null) {
                    this.getStorageContents()[j] = toAdd.clone();
                    toAdd = null;
                    break;
                }
                if (!inSlot.isSimilar(toAdd)) continue;
                int transferAmount = Math.min(inSlot.getMaxStackSize() - inSlot.getAmount(), toAdd.getAmount());
                toAdd.setAmount(toAdd.getAmount() - transferAmount);
                inSlot.setAmount(inSlot.getAmount() + transferAmount);
                if (toAdd.getAmount() > 0) continue;
                toAdd = null;
                break;
            }
            if (toAdd == null) continue;
            result.put(i, toAdd);
        }
        return result;
    }

    @NotNull
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... itemStacks) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> result = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack toRemove = itemStacks[i];
            if (toRemove == null || toRemove.getType().isAir()) continue;
            for (int j = 0; j < this.getStorageContents().length; ++j) {
                ItemStack inSlot = this.getStorageContents()[j];
                if (inSlot == null || !inSlot.isSimilar(toRemove)) continue;
                int transferAmount = Math.min(inSlot.getAmount(), toRemove.getAmount());
                toRemove.setAmount(toRemove.getAmount() - transferAmount);
                inSlot.setAmount(inSlot.getAmount() - transferAmount);
                if (inSlot.getAmount() <= 0) {
                    this.getStorageContents()[j] = null;
                }
                if (toRemove.getAmount() > 0) continue;
                toRemove = null;
                break;
            }
            if (toRemove == null) continue;
            result.put(i, toRemove);
        }
        return result;
    }

    @NotNull
    public ItemStack[] getContents() {
        return this.items;
    }

    public void setContents(@NotNull ItemStack[] itemStacks) throws IllegalArgumentException {
        System.arraycopy(itemStacks, 0, this.items, 0, this.items.length);
    }

    @NotNull
    public ItemStack[] getStorageContents() {
        return this.items;
    }

    public void setStorageContents(@NotNull ItemStack[] itemStacks) throws IllegalArgumentException {
        System.arraycopy(itemStacks, 0, this.items, 0, this.items.length);
    }

    public boolean contains(@NotNull Material material) throws IllegalArgumentException {
        return Arrays.stream(this.getStorageContents()).anyMatch(i -> material == i.getType());
    }

    public boolean contains(@Nullable ItemStack itemStack) {
        return Arrays.stream(this.getStorageContents()).anyMatch(i -> Objects.equals(i, itemStack));
    }

    public boolean contains(@NotNull Material material, int i) throws IllegalArgumentException {
        if (i < 1) {
            return true;
        }
        int sum = 0;
        for (ItemStack stack : this.getStorageContents()) {
            if (stack == null || stack.getType() != material || (sum += stack.getAmount()) < i) continue;
            return true;
        }
        return false;
    }

    public boolean contains(@Nullable ItemStack itemStack, int i) {
        if (i < 1 || itemStack == null) {
            return true;
        }
        int sum = 0;
        for (ItemStack stack : this.getStorageContents()) {
            if (stack == null || !stack.isSimilar(itemStack)) continue;
            sum += stack.getAmount();
        }
        return sum == i;
    }

    public boolean containsAtLeast(@Nullable ItemStack itemStack, int i) {
        if (i < 1 || itemStack == null) {
            return true;
        }
        int sum = 0;
        for (ItemStack stack : this.getStorageContents()) {
            if (stack == null || !stack.isSimilar(itemStack) || (sum += stack.getAmount()) < i) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public HashMap<Integer, ? extends ItemStack> all(@NotNull Material material) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> result = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (stack == null || stack.getType() != material) continue;
            result.put(i, stack);
        }
        return result;
    }

    @NotNull
    public HashMap<Integer, ? extends ItemStack> all(@Nullable ItemStack itemStack) {
        HashMap<Integer, ItemStack> result = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (!Objects.equals(stack, itemStack)) continue;
            result.put(i, stack);
        }
        return result;
    }

    public int first(@NotNull Material material) throws IllegalArgumentException {
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (stack == null || stack.getType() != material) continue;
            return i;
        }
        return -1;
    }

    public int first(@NotNull ItemStack itemStack) {
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (!Objects.equals(stack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int firstEmpty() {
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (stack != null) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.firstEmpty() == -1;
    }

    public void remove(@NotNull Material material) throws IllegalArgumentException {
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (stack.getType() != material) continue;
            this.items[i] = null;
        }
    }

    public void remove(@NotNull ItemStack itemStack) {
        for (int i = 0; i < this.getStorageContents().length; ++i) {
            ItemStack stack = this.getStorageContents()[i];
            if (!Objects.equals(itemStack, stack)) continue;
            this.items[i] = null;
        }
    }

    public void clear(int i) {
        this.getStorageContents()[i] = null;
    }

    public void clear() {
        Arrays.fill(this.getStorageContents(), null);
    }

    @NotNull
    public List<HumanEntity> getViewers() {
        if (this.viewers == null) {
            this.viewers = new ArrayList<HumanEntity>(1);
        }
        return this.viewers;
    }

    @NotNull
    public InventoryType getType() {
        return this.type;
    }

    @Nullable
    public InventoryHolder getHolder() {
        return this.holder;
    }

    @NotNull
    public ListIterator<ItemStack> iterator() {
        return this.iterator(0);
    }

    @NotNull
    public ListIterator<ItemStack> iterator(final int i) {
        return new ListIterator<ItemStack>(){
            int cursor;
            final /* synthetic */ FakeInventory this$0;
            {
                this.this$0 = this$0;
                this.cursor = i;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.this$0.items.length;
            }

            @Override
            public ItemStack next() {
                return this.this$0.items[this.cursor++];
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public ItemStack previous() {
                return this.this$0.items[--this.cursor];
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                this.this$0.items[this.cursor] = null;
            }

            @Override
            public void set(ItemStack itemStack) {
                this.this$0.items[this.cursor] = itemStack;
            }

            @Override
            public void add(ItemStack itemStack) {
                throw new UnsupportedOperationException("cannot add items to an inventory iterator");
            }
        };
    }

    @Nullable
    public Location getLocation() {
        InventoryHolder inventoryHolder = this.getHolder();
        if (inventoryHolder instanceof Entity) {
            return ((Entity)inventoryHolder).getLocation();
        }
        if (inventoryHolder instanceof BlockState) {
            return ((BlockState)inventoryHolder).getLocation();
        }
        return null;
    }
}

