/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal.version;

import com.janboerman.invsee.spigot.internal.version.MinecraftPlatform;
import com.janboerman.invsee.spigot.internal.version.ServerSoftware;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Server;

public class SupportedServerSoftware<ImplementationProvider> {
    private final Map<ServerSoftware, ImplementationProvider> supportedVersions = new LinkedHashMap<ServerSoftware, ImplementationProvider>();

    public void registerSupportedVersion(ServerSoftware software, ImplementationProvider implementationSupplier) {
        this.supportedVersions.put(software, implementationSupplier);
    }

    public void registerSupportedVersion(ImplementationProvider implementationSupplier, ServerSoftware ... softwares) {
        for (ServerSoftware software : softwares) {
            this.registerSupportedVersion(software, implementationSupplier);
        }
    }

    public ImplementationProvider getImplementationProvider(ServerSoftware software) {
        return this.supportedVersions.get(software);
    }

    public static String getUnsupportedPlatformMessage(Server server) {
        return server.getName() + " is not supported. Please run InvSee++ on (a fork of) one of the following server software: " + Arrays.stream(MinecraftPlatform.values()).map(MinecraftPlatform::toString).collect(Collectors.joining(", ", "[", "]")) + ".";
    }

    public String getUnsupportedVersionMessage(MinecraftPlatform platform, Server server) {
        return (Object)((Object)platform) + " version " + server.getVersion() + " is not supported by this release of InvSee++. Please use one of the following " + (Object)((Object)platform) + " versions: " + this.supportedVersions.keySet().stream().filter(software -> software.getPlatform() == platform).map(software -> software.getVersion().toString()).collect(Collectors.joining(", ", "[", "]")) + ". Alternatively you can try upgrading InvSee++ if any of the versions listed here is older than your server's Minecraft version. InvSee++ is available on SpigotMC (recommended): https://www.spigotmc.org/resources/invsee.82342/ and on GitHub: https://github.com/Jannyboy11/InvSee-plus-plus/releases";
    }
}

