/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal.version;

import com.janboerman.invsee.spigot.internal.version.CraftbukkitMappingsVersion;
import com.janboerman.invsee.spigot.internal.version.GlowstoneGameVersion;
import com.janboerman.invsee.spigot.internal.version.MinecraftPlatform;
import com.janboerman.invsee.spigot.internal.version.MinecraftVersion;
import java.util.Objects;
import org.bukkit.Server;

public class ServerSoftware {
    public static final ServerSoftware CRAFTBUKKIT_1_8_8 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_8_8);
    public static final ServerSoftware CRAFTBUKKIT_1_12_2 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_12_2);
    public static final ServerSoftware CRAFTBUKKIT_1_16_5 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_16_5);
    public static final ServerSoftware CRAFTBUKKIT_1_17_1 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_17_1);
    public static final ServerSoftware CRAFTBUKKIT_1_18_2 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_18_2);
    public static final ServerSoftware CRAFTBUKKIT_1_19_4 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_19_4);
    public static final ServerSoftware CRAFTBUKKIT_1_20_1 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20_1);
    public static final ServerSoftware CRAFTBUKKIT_1_20_4 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20_4);
    public static final ServerSoftware CRAFTBUKKIT_1_20_6 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20_6);
    public static final ServerSoftware CRAFTBUKKIT_1_21_1 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_1);
    public static final ServerSoftware CRAFTBUKKIT_1_21_3 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_3);
    public static final ServerSoftware CRAFTBUKKIT_1_21_4 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_4);
    public static final ServerSoftware CRAFTBUKKIT_1_21_5 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_5);
    public static final ServerSoftware CRAFTBUKKIT_1_21_6 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_6);
    public static final ServerSoftware CRAFTBUKKIT_1_21_7 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_7);
    public static final ServerSoftware CRAFTBUKKIT_1_21_8 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_8);
    public static final ServerSoftware CRAFTBUKKIT_1_21_9 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_9);
    public static final ServerSoftware CRAFTBUKKIT_1_21_10 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_10);
    public static final ServerSoftware CRAFTBUKKIT_1_21_11 = new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21_11);
    public static final ServerSoftware GLOWSTONE_1_8_8 = new ServerSoftware(MinecraftPlatform.GLOWSTONE, MinecraftVersion._1_8_8);
    public static final ServerSoftware GLOWSTONE_1_8_9 = new ServerSoftware(MinecraftPlatform.GLOWSTONE, MinecraftVersion._1_8_9);
    public static final ServerSoftware GLOWSTONE_1_12_2 = new ServerSoftware(MinecraftPlatform.GLOWSTONE, MinecraftVersion._1_12_2);
    private MinecraftPlatform platform;
    private MinecraftVersion version;

    public ServerSoftware(MinecraftPlatform platform, MinecraftVersion version) {
        this.platform = platform;
        this.version = version;
    }

    public static ServerSoftware detect(Server server) {
        String serverClassName;
        switch (serverClassName = server.getClass().getName()) {
            case "org.bukkit.craftbukkit.v1_8_R3.CraftServer": {
                return CRAFTBUKKIT_1_8_8;
            }
            case "org.bukkit.craftbukkit.v1_12_R1.CraftServer": {
                return CRAFTBUKKIT_1_12_2;
            }
            case "org.bukkit.craftbukkit.v1_15_R1.CraftServer": {
                return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_15_2);
            }
            case "org.bukkit.craftbukkit.v1_16_R3.CraftServer": {
                return CRAFTBUKKIT_1_16_5;
            }
            case "org.bukkit.craftbukkit.v1_17_R1.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "acd6e6c27e5a0a9440afba70a96c27c9": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_17);
                    }
                    case "f0e3dfc7390de285a4693518dd5bd126": {
                        return CRAFTBUKKIT_1_17_1;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_18_R1.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "9e9fe6961a80f3e586c25601590b51ec": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_18);
                    }
                    case "20b026e774dbf715e40a0b2afe114792": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_18_1);
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_18_R2.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "eaeedbff51b16ead3170906872fda334": {
                        return CRAFTBUKKIT_1_18_2;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_19_R1.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "7b9de0da1357e5b251eddde9aa762916": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_19);
                    }
                    case "4cc0cc97cac491651bff3af8b124a214": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_19_1);
                    }
                    case "69c84c88aeb92ce9fa9525438b93f4fe": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_19_2);
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_19_R2.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "1afe2ffe8a9d7fc510442a168b3d4338": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_19_3);
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_19_R3.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "3009edc0fff87fa34680686663bd59df": {
                        return CRAFTBUKKIT_1_19_4;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_20_R1.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "34f399b4f2033891290b7f0700e9e47b": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20);
                    }
                    case "bcf3dcb22ad42792794079f9443df2c0": {
                        return CRAFTBUKKIT_1_20_1;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_20_R2.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "3478a65bfd04b15b431fe107b3617dfc": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20_2);
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_20_R3.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "60a2bb6bf2684dc61c56b90d7c41bddc": {
                        switch (server.getBukkitVersion()) {
                            case "1.20.3-R0.1-SNAPSHOT": {
                                return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20_3);
                            }
                            case "1.20.4-R0.1-SNAPSHOT": {
                                return CRAFTBUKKIT_1_20_4;
                            }
                        }
                        return CRAFTBUKKIT_1_20_4;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_20_R4.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "ad1a88fd7eaf2277f2507bf34d7b994c": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_20_5);
                    }
                    case "ee13f98a43b9c5abffdcc0bb24154460": {
                        return CRAFTBUKKIT_1_20_6;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R1.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "229d7afc75b70a6c388337687ac4da1f": {
                        return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, MinecraftVersion._1_21);
                    }
                    case "7092ff1ff9352ad7e2260dc150e6a3ec": {
                        return CRAFTBUKKIT_1_21_1;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R2.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "61a218cda78417b6039da56e08194083": {
                        return CRAFTBUKKIT_1_21_3;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R3.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "60ac387ca8007aa018e6aeb394a6988c": {
                        return CRAFTBUKKIT_1_21_4;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R4.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "7ecad754373a5fbc43d381d7450c53a5": {
                        return CRAFTBUKKIT_1_21_5;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R5.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "164f8e872cb3dff744982fca079642b2": {
                        return CRAFTBUKKIT_1_21_6;
                    }
                    case "98b42190c84edaa346fd96106ee35d6f": {
                        return CRAFTBUKKIT_1_21_7;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R6.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "614efe5192cd0510bc2ddc5feefa155d": {
                        switch (server.getBukkitVersion()) {
                            case "1.21.9-R0.1-SNAPSHOT": {
                                return CRAFTBUKKIT_1_21_9;
                            }
                            case "1.21.10-R0.1-SNAPSHOT": {
                                return CRAFTBUKKIT_1_21_10;
                            }
                        }
                        return CRAFTBUKKIT_1_21_10;
                    }
                }
            }
            case "org.bukkit.craftbukkit.v1_21_R7.CraftServer": {
                switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                    case "e3cd927e07e6ff434793a0474c51b2b9": {
                        return CRAFTBUKKIT_1_21_11;
                    }
                }
            }
            case "org.bukkit.craftbukkit.CraftServer": {
                try {
                    return new ServerSoftware(MinecraftPlatform.PAPER, MinecraftVersion.fromString(server.getMinecraftVersion()));
                }
                catch (NoSuchMethodError nsme) {
                    switch (CraftbukkitMappingsVersion.getMappingsVersion(server)) {
                        case "ee13f98a43b9c5abffdcc0bb24154460": {
                            return CRAFTBUKKIT_1_20_6;
                        }
                        case "7092ff1ff9352ad7e2260dc150e6a3ec": {
                            return CRAFTBUKKIT_1_21_1;
                        }
                        case "61a218cda78417b6039da56e08194083": {
                            return CRAFTBUKKIT_1_21_3;
                        }
                        case "60ac387ca8007aa018e6aeb394a6988c": {
                            return CRAFTBUKKIT_1_21_4;
                        }
                        case "7ecad754373a5fbc43d381d7450c53a5": {
                            return CRAFTBUKKIT_1_21_5;
                        }
                        case "164f8e872cb3dff744982fca079642b2": {
                            return CRAFTBUKKIT_1_21_6;
                        }
                        case "98b42190c84edaa346fd96106ee35d6f": {
                            return CRAFTBUKKIT_1_21_7;
                        }
                        case "614efe5192cd0510bc2ddc5feefa155d": {
                            return CRAFTBUKKIT_1_21_9;
                        }
                        case "e3cd927e07e6ff434793a0474c51b2b9": {
                            return CRAFTBUKKIT_1_21_11;
                        }
                    }
                }
            }
            case "net.glowstone.GlowServer": {
                String glowstoneGameVersion;
                switch (glowstoneGameVersion = GlowstoneGameVersion.getGameVersion()) {
                    case "1.8.8": {
                        return GLOWSTONE_1_8_8;
                    }
                    case "1.8.9": {
                        return GLOWSTONE_1_8_9;
                    }
                    case "1.12.2": {
                        return GLOWSTONE_1_12_2;
                    }
                }
                return new ServerSoftware(MinecraftPlatform.GLOWSTONE, MinecraftVersion.fromString(glowstoneGameVersion));
            }
        }
        if (serverClassName.matches("org\\.bukkit\\.craftbukkit\\.v((.?)*)\\.CraftServer")) {
            return new ServerSoftware(MinecraftPlatform.CRAFTBUKKIT, null);
        }
        return null;
    }

    public String toString() {
        return (Object)((Object)this.platform) + " version " + (Object)((Object)this.version);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSoftware)) {
            return false;
        }
        ServerSoftware that = (ServerSoftware)o;
        return this.platform == that.platform && this.version == that.version;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.platform, this.version});
    }

    public MinecraftPlatform getPlatform() {
        return this.platform;
    }

    public MinecraftVersion getVersion() {
        return this.version;
    }
}

