/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal.template;

import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.utils.Compat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.IntStream;

public class EnderChestMirror
implements Mirror<EnderChestSlot> {
    public static final String DEFAULT_TEMPLATE = "e_00 e_01 e_02 e_03 e_04 e_05 e_06 e_07 e_08\ne_09 e_10 e_11 e_12 e_13 e_14 e_15 e_16 e_17\ne_18 e_19 e_20 e_21 e_22 e_23 e_24 e_25 e_26\ne_27 e_28 e_29 e_30 e_31 e_32 e_33 e_34 e_35\ne_36 e_37 e_38 e_39 e_40 e_41 e_42 e_43 e_44\ne_45 e_46 e_47 e_48 e_49 e_50 e_51 e_52 e_53";
    public static final EnderChestMirror DEFAULT = new EnderChestMirror("e_00 e_01 e_02 e_03 e_04 e_05 e_06 e_07 e_08\ne_09 e_10 e_11 e_12 e_13 e_14 e_15 e_16 e_17\ne_18 e_19 e_20 e_21 e_22 e_23 e_24 e_25 e_26\ne_27 e_28 e_29 e_30 e_31 e_32 e_33 e_34 e_35\ne_36 e_37 e_38 e_39 e_40 e_41 e_42 e_43 e_44\ne_45 e_46 e_47 e_48 e_49 e_50 e_51 e_52 e_53");
    private EnderChestSlot[] slots;
    private Map<EnderChestSlot, Integer> indices;
    private static final int CONTAINER_LENGTH = "CONTAINER_".length();

    @Deprecated
    public EnderChestMirror(String template) {
        this.slots = (EnderChestSlot[])Compat.lines(template).flatMap(line -> IntStream.range(0, 9).mapToObj(i -> EnderChestMirror.convert(line.substring(i * 5, i * 5 + 4)))).toArray(EnderChestSlot[]::new);
        this.indices = new HashMap<EnderChestSlot, Integer>();
        for (int i = 0; i < this.slots.length; ++i) {
            EnderChestSlot slot = this.slots[i];
            if (slot == null) continue;
            this.indices.put(this.slots[i], i);
        }
    }

    public static EnderChestMirror ofTemplate(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        if (template == DEFAULT_TEMPLATE) {
            return DEFAULT;
        }
        return new EnderChestMirror(template);
    }

    private static EnderChestSlot convert(String symbol) {
        if ("e_".equals(symbol.substring(0, 2))) {
            return EnderChestSlot.valueOf("CONTAINER_" + symbol.substring(2, 4));
        }
        return null;
    }

    @Override
    public Integer getIndex(EnderChestSlot slot) {
        if (slot == null) {
            return null;
        }
        return this.indices.get((Object)slot);
    }

    @Override
    public EnderChestSlot getSlot(int index) {
        return this.slots[index];
    }

    public EnderChestSlot[] getSlots() {
        return Arrays.copyOf(this.slots, this.slots.length);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ", "EnderChestTemplate(", ")");
        for (EnderChestSlot slot : this.slots) {
            sj.add(slot.toString());
        }
        return sj.toString();
    }

    public static String toTemplate(Mirror<EnderChestSlot> mirror) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 54; ++i) {
            EnderChestSlot slot = mirror.getSlot(i);
            if (slot != null) {
                String slotName = slot.name();
                stringBuilder.append("e_" + slotName.substring(CONTAINER_LENGTH, slotName.length()));
            } else {
                stringBuilder.append("_   ");
            }
            if (i % 9 == 0) {
                if (i == 0) continue;
                stringBuilder.append(System.lineSeparator());
                continue;
            }
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

