/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal.inventory;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.internal.inventory.ShallowCopy;
import com.janboerman.invsee.utils.UUIDHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public abstract class AbstractNmsInventory<Slot, Bukkit extends SpectatorInventory<Slot>, NMS extends AbstractNmsInventory<Slot, Bukkit, NMS>>
implements ShallowCopy<NMS> {
    public final UUID targetPlayerUuid;
    public final String targetPlayerName;
    public final CreationOptions<Slot> creationOptions;
    private Bukkit bukkit;
    protected int maxStack;
    private final List<HumanEntity> transaction = new ArrayList<HumanEntity>(1);
    protected InventoryHolder owner;

    protected AbstractNmsInventory(UUID targetPlayerUuid, String targetPlayerName, CreationOptions<Slot> creationOptions) {
        this.targetPlayerUuid = UUIDHelper.copy(targetPlayerUuid);
        this.targetPlayerName = targetPlayerName;
        this.maxStack = this.defaultMaxStack();
        this.creationOptions = creationOptions;
    }

    protected abstract Bukkit createBukkit();

    public Bukkit bukkit() {
        return this.bukkit == null ? (this.bukkit = this.createBukkit()) : this.bukkit;
    }

    public void onOpen(HumanEntity who) {
        this.transaction.add(who);
    }

    public void onClose(HumanEntity who) {
        this.transaction.remove(who);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public InventoryHolder getOwner() {
        return this.owner;
    }

    public Location getLocation() {
        return null;
    }
}

