/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Title;
import com.janboerman.invsee.spigot.api.logging.LogGranularity;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogTarget;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SaveResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public interface InvseePlatform {
    public MainSpectatorInventory spectateInventory(HumanEntity var1, CreationOptions<PlayerInventorySlot> var2);

    public CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID var1, String var2, CreationOptions<PlayerInventorySlot> var3);

    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory var1);

    public OpenResponse<MainSpectatorInventoryView> openMainSpectatorInventory(Player var1, MainSpectatorInventory var2, CreationOptions<PlayerInventorySlot> var3);

    public EnderSpectatorInventory spectateEnderChest(HumanEntity var1, CreationOptions<EnderChestSlot> var2);

    public CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID var1, String var2, CreationOptions<EnderChestSlot> var3);

    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory var1);

    public OpenResponse<EnderSpectatorInventoryView> openEnderSpectatorInventory(Player var1, EnderSpectatorInventory var2, CreationOptions<EnderChestSlot> var3);

    default public PlaceholderPalette getPlaceholderPalette(String name) {
        return PlaceholderPalette.empty();
    }

    default public CreationOptions<PlayerInventorySlot> defaultInventoryCreationOptions(Plugin plugin) {
        return CreationOptions.of(plugin, Title.defaultMainInventory(), true, Mirror.defaultPlayerInventory(), true, false, LogOptions.of(LogGranularity.LOG_ON_CLOSE, Collections.singleton(LogTarget.PLUGIN_LOG_FILE), LogOptions.defaultLogFormats()), PlaceholderPalette.empty());
    }

    default public CreationOptions<EnderChestSlot> defaultEnderChestCreationOptions(Plugin plugin) {
        return CreationOptions.of(plugin, Title.defaultEnderInventory(), true, Mirror.defaultEnderChest(), true, false, LogOptions.of(LogGranularity.LOG_ON_CLOSE, Collections.singleton(LogTarget.PLUGIN_LOG_FILE), LogOptions.defaultLogFormats()), PlaceholderPalette.empty());
    }

    default public Stream<Material> materials() {
        return Arrays.stream(Material.values());
    }
}

