/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.internal;

import com.janboerman.invsee.spigot.internal.FakePersistentDataAdapterContext;
import java.io.IOException;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class FakePersistentDataContainer
implements PersistentDataContainer {
    private final PersistentDataAdapterContext context;
    private final Map<NamespacedKey, Map<PersistentDataType, Object>> map = new HashMap<NamespacedKey, Map<PersistentDataType, Object>>();

    public FakePersistentDataContainer() {
        this(new FakePersistentDataAdapterContext());
    }

    FakePersistentDataContainer(PersistentDataAdapterContext context) {
        this.context = context;
    }

    public <T, Z> void set(NamespacedKey namespacedKey, PersistentDataType<T, Z> persistentDataType, Z z) {
        this.map.computeIfAbsent(namespacedKey, k -> new HashMap()).put(persistentDataType, z);
    }

    public <T, Z> boolean has(NamespacedKey namespacedKey, PersistentDataType<T, Z> persistentDataType) {
        Map<PersistentDataType, Object> inner = this.map.get(namespacedKey);
        if (inner == null) {
            return false;
        }
        return inner.containsKey(persistentDataType);
    }

    public boolean has(@NotNull NamespacedKey namespacedKey) {
        return this.map.containsKey(namespacedKey);
    }

    public <T, Z> Z get(NamespacedKey namespacedKey, PersistentDataType<T, Z> persistentDataType) {
        Map<PersistentDataType, Object> inner = this.map.get(namespacedKey);
        if (inner == null) {
            return null;
        }
        return (Z)inner.get(persistentDataType);
    }

    public <T, Z> Z getOrDefault(NamespacedKey namespacedKey, PersistentDataType<T, Z> persistentDataType, Z z) {
        Map<PersistentDataType, Object> inner = this.map.get(namespacedKey);
        if (inner == null) {
            return z;
        }
        if (inner.containsKey(persistentDataType)) {
            return (Z)inner.get(persistentDataType);
        }
        return z;
    }

    public Set<NamespacedKey> getKeys() {
        return this.map.keySet();
    }

    public void remove(NamespacedKey namespacedKey) {
        this.map.remove(namespacedKey);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void copyTo(@NotNull PersistentDataContainer persistentDataContainer, boolean replace) {
        FakePersistentDataContainer other = (FakePersistentDataContainer)persistentDataContainer;
        if (replace) {
            other.map.putAll(this.map);
        } else {
            for (Map.Entry<NamespacedKey, Map<PersistentDataType, Object>> entry : this.map.entrySet()) {
                other.map.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }

    public PersistentDataAdapterContext getAdapterContext() {
        return this.context;
    }

    public int hashCode() {
        return 3 + this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FakePersistentDataContainer) {
            FakePersistentDataContainer fakeThat = (FakePersistentDataContainer)obj;
            return Objects.equals(this.map, fakeThat.map);
        }
        if (obj instanceof PersistentDataContainer) {
            PersistentDataContainer that = (PersistentDataContainer)obj;
            if (!Objects.equals(this.getKeys(), that.getKeys())) {
                return false;
            }
            for (NamespacedKey key : this.getKeys()) {
                Map<PersistentDataType, Object> innerMap = this.map.get(key);
                for (Map.Entry<PersistentDataType, Object> entry : innerMap.entrySet()) {
                    Object otherValue;
                    PersistentDataType pdt = entry.getKey();
                    Object myValue = entry.getValue();
                    if (Objects.equals(myValue, otherValue = that.get(key, pdt))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public byte @NotNull [] serializeToBytes() throws IOException {
        throw new UnknownServiceException("Can't serialize fake data");
    }

    public void readFromBytes(byte @NotNull [] bytes, boolean b) throws IOException {
        throw new UnknownServiceException("Can't deserialize fake data");
    }

    public void readFromBytes(byte @NotNull [] bytes) throws IOException {
        super.readFromBytes(bytes);
    }
}

