/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_8_R3.BukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_8_R3.MainNmsContainer;
import javax.annotation.Nullable;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

class MainBukkitInventoryView
extends BukkitInventoryView<PlayerInventorySlot>
implements MainSpectatorInventoryView {
    final MainNmsContainer nms;

    MainBukkitInventoryView(MainNmsContainer nms) {
        super(nms.creationOptions);
        this.nms = nms;
    }

    @Override
    public MainSpectatorInventory getTopInventory() {
        return (MainSpectatorInventory)this.nms.top.bukkit();
    }

    public PlayerInventory getBottomInventory() {
        return this.nms.player.getBukkitEntity().getInventory();
    }

    public HumanEntity getPlayer() {
        return this.nms.player.getBukkitEntity();
    }

    public void setItem(int slot, ItemStack item) {
        net.minecraft.server.v1_8_R3.ItemStack stack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (slot >= 0) {
            this.nms.getSlot(slot).set(stack);
        } else {
            this.nms.player.drop(stack, false);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot < 0) {
            return null;
        }
        net.minecraft.server.v1_8_R3.ItemStack nmsStack = slot < this.nms.top.getSize() ? this.nms.top.getContents()[slot] : this.nms.getSlot(slot).getItem();
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R3.ItemStack)nmsStack);
    }

    @Override
    @Nullable
    public Difference getTrackedDifference() {
        DifferenceTracker tracker = this.nms.tracker;
        return tracker == null ? null : tracker.getDifference();
    }

    @Override
    public InventoryType getType() {
        return InventoryType.CHEST;
    }
}

