/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_8_R3;

import com.janboerman.invsee.spigot.api.OfflinePlayerProvider;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.impl_1_8_R3.HybridServerSupport;
import com.janboerman.invsee.spigot.internal.PlayerFileHelper;
import com.janboerman.invsee.utils.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.minecraft.server.v1_8_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.ReportedException;
import net.minecraft.server.v1_8_R3.WorldNBTStorage;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.plugin.Plugin;

public class KnownPlayersProvider
implements OfflinePlayerProvider {
    private final Plugin plugin;
    private final Scheduler scheduler;

    public KnownPlayersProvider(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    @Override
    public void getAll(Consumer<String> result) {
        File[] playerFiles;
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = (WorldNBTStorage)craftServer.getHandle().playerFileData;
        File playerDirectory = HybridServerSupport.getPlayerDir(worldNBTStorage);
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return;
        }
        for (File playerFile : playerFiles = playerDirectory.listFiles((directory, fileName) -> PlayerFileHelper.isPlayerSaveFile(fileName))) {
            try {
                KnownPlayersProvider.readName(result, playerFile);
            }
            catch (IOException | ReportedException e1) {
                UUID playerId = KnownPlayersProvider.uuidFromFileName(playerFile.getName());
                Executor executor = playerId == null ? this.scheduler::executeSyncGlobal : runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null);
                executor.execute(() -> this.lambda$getAll$2(result, playerFile, (Exception)e1));
            }
        }
    }

    @Override
    public void getWithPrefix(String prefix, Consumer<String> result) {
        File[] playerFiles;
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = (WorldNBTStorage)craftServer.getHandle().playerFileData;
        File playerDirectory = worldNBTStorage.getPlayerDir();
        if (!playerDirectory.exists() || !playerDirectory.isDirectory()) {
            return;
        }
        for (File playerFile : playerFiles = playerDirectory.listFiles((directory, fileName) -> PlayerFileHelper.isPlayerSaveFile(fileName))) {
            try {
                KnownPlayersProvider.readName(prefix, result, playerFile);
            }
            catch (IOException | ReportedException e1) {
                UUID playerId = KnownPlayersProvider.uuidFromFileName(playerFile.getName());
                Executor executor = playerId == null ? this.scheduler::executeSyncGlobal : runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null);
                executor.execute(() -> this.lambda$getWithPrefix$2(prefix, result, playerFile, (Exception)e1));
            }
        }
    }

    private static UUID uuidFromFileName(String fileName) {
        if (fileName == null | fileName.length() < 36) {
            return null;
        }
        try {
            return UUID.fromString(fileName.substring(0, 36));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void readName(Consumer<String> reader, File playerFile) throws IOException, ReportedException {
        String name = KnownPlayersProvider.readName(playerFile);
        if (name != null) {
            reader.accept(name);
        }
    }

    private static void readName(String prefix, Consumer<String> reader, File playerFile) throws IOException, ReportedException {
        String name = KnownPlayersProvider.readName(playerFile);
        if (name != null && StringHelper.startsWithIgnoreCase(name, prefix)) {
            reader.accept(name);
        }
    }

    private static String readName(File playerFile) throws IOException, ReportedException {
        NBTTagCompound bukkit;
        NBTTagCompound compound = NBTCompressedStreamTools.a((InputStream)new FileInputStream(playerFile));
        if (compound.hasKeyOfType("bukkit", 10) && (bukkit = compound.getCompound("bukkit")).hasKeyOfType("lastKnownName", 8)) {
            return bukkit.getString("lastKnownName");
        }
        return null;
    }

    private /* synthetic */ void lambda$getWithPrefix$2(String prefix, Consumer result, File playerFile, Exception e1) {
        try {
            KnownPlayersProvider.readName(prefix, result, playerFile);
        }
        catch (IOException | ReportedException e2) {
            e2.addSuppressed(e1);
            this.plugin.getLogger().log(Level.WARNING, "Error reading player's save file " + playerFile.getAbsolutePath(), e2);
        }
    }

    private /* synthetic */ void lambda$getAll$2(Consumer result, File playerFile, Exception e1) {
        try {
            KnownPlayersProvider.readName(result, playerFile);
        }
        catch (IOException | ReportedException e2) {
            e2.addSuppressed(e1);
            this.plugin.getLogger().log(Level.WARNING, "Error reading player's save file " + playerFile.getAbsolutePath(), e2);
        }
    }
}

