/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_9_R6;

import com.google.common.base.Preconditions;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.logging.Difference;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.BukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.MainNmsContainer;
import javax.annotation.Nullable;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

class MainBukkitInventoryView
extends BukkitInventoryView<PlayerInventorySlot>
implements MainSpectatorInventoryView {
    final MainNmsContainer nms;

    MainBukkitInventoryView(MainNmsContainer nms) {
        super(nms.creationOptions);
        this.nms = nms;
    }

    @Override
    public MainSpectatorInventory getTopInventory() {
        return (MainSpectatorInventory)this.nms.top.bukkit();
    }

    public PlayerInventory getBottomInventory() {
        return this.nms.player.getBukkitEntity().getInventory();
    }

    public HumanEntity getPlayer() {
        return this.nms.player.getBukkitEntity();
    }

    @Override
    public InventoryType getType() {
        return InventoryType.CHEST;
    }

    @Override
    public String getTitle() {
        return this.nms.title();
    }

    public String getOriginalTitle() {
        return this.nms.originalTitle;
    }

    public void setTitle(String title) {
        CraftInventoryView.sendInventoryTitleChange((InventoryView)this, (String)title);
        this.nms.title = title;
    }

    public void setItem(int slot, ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (slot >= 0) {
            this.nms.b(slot).f(stack);
        } else {
            this.nms.player.a(stack, false);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot < 0) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsStack = slot < this.nms.top.b() ? this.nms.top.getContents().get(slot) : this.nms.b(slot).g();
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsStack);
    }

    @Override
    public void setCursor(ItemStack itemStack) {
        this.getPlayer().setItemOnCursor(itemStack);
    }

    @Override
    public ItemStack getCursor() {
        return this.getPlayer().getItemOnCursor();
    }

    @Override
    public Inventory getInventory(int rawSlot) {
        if (rawSlot == -999 || rawSlot == -1) {
            return null;
        }
        Preconditions.checkArgument((rawSlot >= 0 ? 1 : 0) != 0, (String)"Negative, non outside slot %s", (int)rawSlot);
        Preconditions.checkArgument((rawSlot < this.countSlots() ? 1 : 0) != 0, (String)"Slot %s greater than inventory slot count", (int)rawSlot);
        return rawSlot < this.getTopInventory().getSize() ? this.getTopInventory() : this.getBottomInventory();
    }

    @Override
    public int convertSlot(int rawSlot) {
        int topSize = this.getTopInventory().getSize();
        if (rawSlot < topSize) {
            return rawSlot;
        }
        int slot = rawSlot - topSize;
        slot = slot >= 27 ? (slot -= 27) : (slot += 9);
        return slot;
    }

    @Override
    public InventoryType.SlotType getSlotType(int slot) {
        if (slot < 0) {
            return InventoryType.SlotType.OUTSIDE;
        }
        int slotCount = this.countSlots();
        if (slotCount - 9 <= slot && slot < slotCount) {
            return InventoryType.SlotType.QUICKBAR;
        }
        return InventoryType.SlotType.CONTAINER;
    }

    @Override
    public void close() {
        this.getPlayer().closeInventory();
    }

    @Override
    public int countSlots() {
        return this.getTopInventory().getSize() + this.getBottomInventory().getStorageContents().length;
    }

    @Override
    public boolean setProperty(InventoryView.Property property, int value) {
        return this.getPlayer().setWindowProperty(property, value);
    }

    @Override
    @Nullable
    public Difference getTrackedDifference() {
        DifferenceTracker tracker = this.nms.tracker;
        return tracker == null ? null : tracker.getDifference();
    }
}

