/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_9_R6;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.event.SpectatorInventorySaveEvent;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderGroup;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.NotOpenedReason;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SaveResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.BodySlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.BootsSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.ChestplateSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.CursorSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.EnderBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.EnderNmsContainer;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.EnderNmsInventory;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.FakeCraftHumanEntity;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.FakeCraftPlayer;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.FakeEntityHuman;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.FakeEntityPlayer;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.HelmetSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.HybridServerSupport;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.InaccessibleSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.LeggingsSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.MainBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.MainBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.MainNmsContainer;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.MainNmsInventory;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.NameSearchSaveFilesStrategy;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.OffhandSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.PersonalSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.Placeholders;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.SaddleSlot;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.ThrowingProblemReporter;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.UUIDSearchSaveFilesStrategy;
import com.janboerman.invsee.spigot.impl_1_21_9_R6.WrongNbtTypeException;
import com.janboerman.invsee.spigot.internal.EventHelper;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.janboerman.invsee.spigot.internal.TestingCompatLayer;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InvseeImpl
implements InvseePlatform,
TestingCompatLayer {
    private final Plugin plugin;
    private final OpenSpectatorsCache cache;
    private final Scheduler scheduler;

    public InvseeImpl(Plugin plugin, NamesAndUUIDs lookup, Scheduler scheduler, OpenSpectatorsCache cache) {
        this.plugin = plugin;
        this.cache = cache;
        this.scheduler = scheduler;
        if (lookup.onlineMode(plugin.getServer())) {
            lookup.uuidResolveStrategies.add(new UUIDSearchSaveFilesStrategy(plugin, scheduler));
        } else {
            lookup.uuidResolveStrategies.add(lookup.uuidResolveStrategies.size() - 1, new UUIDSearchSaveFilesStrategy(plugin, scheduler));
        }
        lookup.nameResolveStrategies.add(2, new NameSearchSaveFilesStrategy(plugin, scheduler));
    }

    @Override
    public OpenResponse<MainSpectatorInventoryView> openMainSpectatorInventory(Player spectator, MainSpectatorInventory inv, CreationOptions<PlayerInventorySlot> options) {
        Target target = Target.byGameProfile(inv.getSpectatedPlayerId(), inv.getSpectatedPlayerName());
        String title = options.getTitle().titleFor(target);
        CraftPlayer bukkitPlayer = (CraftPlayer)spectator;
        EntityPlayer nmsPlayer = bukkitPlayer.getHandle();
        MainBukkitInventory bukkitInventory = (MainBukkitInventory)inv;
        MainNmsInventory nmsInventory = bukkitInventory.getInventory();
        int windowId = HybridServerSupport.nextContainerCounter(nmsPlayer);
        PlayerInventory bottom = nmsPlayer.gB();
        MainNmsContainer nmsWindow = new MainNmsContainer(windowId, nmsInventory, bottom, (EntityHuman)nmsPlayer, options);
        nmsWindow.setTitle(CraftChatMessage.fromString((String)(title != null ? title : inv.getTitle()))[0]);
        Optional<InventoryOpenEvent> eventCancelled = InvseeImpl.callInventoryOpenEvent(nmsPlayer, nmsWindow);
        if (eventCancelled.isPresent()) {
            return OpenResponse.closed(NotOpenedReason.inventoryOpenEventCancelled(eventCancelled.get()));
        }
        nmsPlayer.cl = nmsWindow;
        nmsPlayer.g.b((Packet)new PacketPlayOutOpenWindow(windowId, nmsWindow.a(), nmsWindow.getTitle()));
        nmsPlayer.a((Container)nmsWindow);
        MainBukkitInventoryView bukkitWindow = nmsWindow.getBukkitView();
        Mirror<PlayerInventorySlot> mirror = options.getMirror();
        PlaceholderPalette palette = options.getPlaceholderPalette();
        net.minecraft.world.item.ItemStack inaccessible = CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
        for (int i = PlayerInventorySlot.CONTAINER_35.defaultIndex() + 1; i < nmsInventory.b(); ++i) {
            Integer idx = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(i));
            if (idx == null) {
                InvseeImpl.sendItemChange(nmsPlayer, i, inaccessible);
                continue;
            }
            int rawIndex = idx;
            Slot slot = nmsWindow.b(rawIndex);
            if (slot.h()) continue;
            if (slot instanceof InaccessibleSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, inaccessible);
                continue;
            }
            if (slot instanceof BootsSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourBoots()));
                continue;
            }
            if (slot instanceof LeggingsSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourLeggings()));
                continue;
            }
            if (slot instanceof ChestplateSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourChestplate()));
                continue;
            }
            if (slot instanceof HelmetSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourHelmet()));
                continue;
            }
            if (slot instanceof OffhandSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.offHand()));
                continue;
            }
            if (slot instanceof BodySlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.body()));
                continue;
            }
            if (slot instanceof SaddleSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.saddle()));
                continue;
            }
            if (slot instanceof CursorSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.cursor()));
                continue;
            }
            if (!(slot instanceof PersonalSlot)) continue;
            PersonalSlot personal = (PersonalSlot)slot;
            InvseeImpl.sendItemChange(nmsPlayer, rawIndex, personal.works() ? CraftItemStack.asNMSCopy((ItemStack)palette.generic()) : inaccessible);
        }
        return OpenResponse.open(bukkitWindow);
    }

    @Override
    public MainSpectatorInventory spectateInventory(HumanEntity player, CreationOptions<PlayerInventorySlot> options) {
        MainNmsInventory spectatorInv = new MainNmsInventory(((CraftHumanEntity)player).getHandle(), options);
        MainBukkitInventory bukkitInventory = (MainBukkitInventory)spectatorInv.bukkit();
        InventoryView targetView = player.getOpenInventory();
        bukkitInventory.watch(targetView);
        this.cache.cache(bukkitInventory);
        return bukkitInventory;
    }

    @Override
    public CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options) {
        return this.createOffline(playerId, playerName, options, this::spectateInventory);
    }

    @Override
    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory newInventory) {
        return this.save(newInventory, this::spectateInventory, MainSpectatorInventory::setContents);
    }

    @Override
    public OpenResponse<EnderSpectatorInventoryView> openEnderSpectatorInventory(Player spectator, EnderSpectatorInventory inv, CreationOptions<EnderChestSlot> options) {
        Target target = Target.byGameProfile(inv.getSpectatedPlayerId(), inv.getSpectatedPlayerName());
        String title = options.getTitle().titleFor(target);
        CraftPlayer bukkitPlayer = (CraftPlayer)spectator;
        EntityPlayer nmsPlayer = bukkitPlayer.getHandle();
        EnderBukkitInventory bukkitInventory = (EnderBukkitInventory)inv;
        EnderNmsInventory nmsInventory = bukkitInventory.getInventory();
        int windowId = HybridServerSupport.nextContainerCounter(nmsPlayer);
        PlayerInventory bottom = nmsPlayer.gB();
        EnderNmsContainer nmsWindow = new EnderNmsContainer(windowId, nmsInventory, bottom, (EntityHuman)nmsPlayer, options);
        nmsWindow.setTitle(CraftChatMessage.fromString((String)(title != null ? title : inv.getTitle()))[0]);
        Optional<InventoryOpenEvent> eventCancelled = InvseeImpl.callInventoryOpenEvent(nmsPlayer, nmsWindow);
        if (eventCancelled.isPresent()) {
            return OpenResponse.closed(NotOpenedReason.inventoryOpenEventCancelled(eventCancelled.get()));
        }
        nmsPlayer.cl = nmsWindow;
        nmsPlayer.g.b((Packet)new PacketPlayOutOpenWindow(windowId, nmsWindow.a(), nmsWindow.getTitle()));
        nmsPlayer.a((Container)nmsWindow);
        return OpenResponse.open(nmsWindow.getBukkitView());
    }

    @Override
    public EnderSpectatorInventory spectateEnderChest(HumanEntity player, CreationOptions<EnderChestSlot> options) {
        EnderNmsInventory spectatorInv = new EnderNmsInventory(((CraftHumanEntity)player).getHandle(), options);
        EnderBukkitInventory bukkitInventory = (EnderBukkitInventory)spectatorInv.bukkit();
        this.cache.cache(bukkitInventory);
        return bukkitInventory;
    }

    @Override
    public CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options) {
        return this.createOffline(playerId, playerName, options, this::spectateEnderChest);
    }

    @Override
    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory newInventory) {
        return this.save(newInventory, this::spectateEnderChest, EnderSpectatorInventory::setContents);
    }

    private <Slot, IS extends SpectatorInventory<Slot>> CompletableFuture<SpectateResponse<IS>> createOffline(UUID player, String name, CreationOptions<Slot> options, BiFunction<? super HumanEntity, ? super CreationOptions<Slot>, IS> invCreator) {
        CraftServer server = (CraftServer)this.plugin.getServer();
        DedicatedPlayerList playerList = server.getHandle();
        WorldNBTStorage worldNBTStorage = playerList.s;
        CraftWorld world = (CraftWorld)server.getWorlds().get(0);
        GameProfile gameProfile = new GameProfile(player, name);
        FakeEntityHuman fakeEntityHuman = new FakeEntityHuman((net.minecraft.world.level.World)world.getHandle(), gameProfile);
        return CompletableFuture.supplyAsync(() -> {
            Optional<ValueInput> playerCompound = HybridServerSupport.loadPlayerData(worldNBTStorage, fakeEntityHuman).map(tag -> TagValueInput.a((ProblemReporter)ThrowingProblemReporter.INSTANCE, (HolderLookup.a)fakeEntityHuman.ej(), (NBTTagCompound)tag));
            if (playerCompound.isEmpty()) {
                if (!options.isUnknownPlayerSupported()) {
                    return SpectateResponse.fail(NotCreatedReason.unknownTarget(Target.byGameProfile(player, name)));
                }
            } else {
                fakeEntityHuman.a(playerCompound.get());
            }
            FakeCraftHumanEntity craftHumanEntity = new FakeCraftHumanEntity(server, fakeEntityHuman);
            return SpectateResponse.succeed(EventHelper.callSpectatorInventoryOfflineCreatedEvent((Server)server, (SpectatorInventory)invCreator.apply((HumanEntity)craftHumanEntity, (Object)options)));
        }, runnable -> this.scheduler.executeSyncPlayer(player, runnable, null));
    }

    private <Slot, SI extends SpectatorInventory<Slot>> CompletableFuture<SaveResponse> save(SI newInventory, BiFunction<? super HumanEntity, ? super CreationOptions<Slot>, SI> currentInvProvider, BiConsumer<SI, SI> transfer) {
        CraftServer server = (CraftServer)this.plugin.getServer();
        SpectatorInventorySaveEvent event = EventHelper.callSpectatorInventorySaveEvent((Server)server, newInventory);
        if (event.isCancelled()) {
            return CompletableFuture.completedFuture(SaveResponse.notSaved(newInventory));
        }
        CraftWorld world = (CraftWorld)server.getWorlds().get(0);
        UUID playerId = newInventory.getSpectatedPlayerId();
        GameProfile gameProfile = new GameProfile(playerId, newInventory.getSpectatedPlayerName());
        ClientInformation clientInformation = ClientInformation.a();
        FakeEntityPlayer fakeEntityPlayer = new FakeEntityPlayer((MinecraftServer)server.getServer(), world.getHandle(), gameProfile, clientInformation);
        return CompletableFuture.supplyAsync(() -> {
            FakeCraftPlayer fakeCraftPlayer = fakeEntityPlayer.getBukkitEntity();
            fakeCraftPlayer.loadData();
            this.loadWorldDataAndGameMode(server, fakeEntityPlayer);
            CreationOptions creationOptions = newInventory.getCreationOptions();
            SpectatorInventory currentInv = (SpectatorInventory)currentInvProvider.apply((HumanEntity)fakeCraftPlayer, (Object)creationOptions);
            transfer.accept(currentInv, newInventory);
            fakeCraftPlayer.saveData();
            return SaveResponse.saved(currentInv);
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
    }

    private void loadWorldDataAndGameMode(CraftServer server, FakeEntityPlayer fakeEntityPlayer) {
        WorldNBTStorage playerDataStorage = server.getHandle().s;
        Optional<ValueInput> optional = HybridServerSupport.loadPlayerData(playerDataStorage, (EntityHuman)fakeEntityPlayer).map(tag -> TagValueInput.a((ProblemReporter)ThrowingProblemReporter.INSTANCE, (HolderLookup.a)fakeEntityPlayer.ej(), (NBTTagCompound)tag));
        if (optional.isPresent()) {
            ValueInput nbttagcompound = optional.get();
            World bWorld = null;
            Optional worldUUIDMost = nbttagcompound.f("WorldUUIDMost");
            Optional worldUUIDLeast = nbttagcompound.f("WorldUUIDLeast");
            if (worldUUIDMost.isPresent() && worldUUIDLeast.isPresent()) {
                bWorld = server.getWorld(new UUID((Long)worldUUIDMost.get(), (Long)worldUUIDLeast.get()));
            } else {
                Optional legacyBukkitWorld = nbttagcompound.g("world");
                if (legacyBukkitWorld.isPresent()) {
                    bWorld = server.getWorld((String)legacyBukkitWorld.get());
                }
            }
            if (bWorld != null) {
                WorldServer level = ((CraftWorld)bWorld).getHandle();
                fakeEntityPlayer.a(level);
            } else {
                DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = InvseeImpl.parseLegacyDimensionType(nbttagcompound);
                Optional optionalLevelKey = dataresult.resultOrPartial(message -> this.plugin.getLogger().severe((String)message));
                ResourceKey levelResourceKey = optionalLevelKey.orElse(net.minecraft.world.level.World.h);
                WorldServer level = server.getHandle().b().a(levelResourceKey);
                if (level != null) {
                    HybridServerSupport.spawnIn(fakeEntityPlayer, (net.minecraft.world.level.World)level);
                }
            }
            InvseeImpl.loadGameTypes(fakeEntityPlayer, nbttagcompound);
        }
    }

    private static void loadGameTypes(FakeEntityPlayer fakeEntityPlayer, ValueInput nbtTagCompound) {
        EnumGamemode gameType1 = nbtTagCompound == null ? null : (EnumGamemode)nbtTagCompound.a("playerGameType", EnumGamemode.h).orElse(null);
        EnumGamemode gameType2 = nbtTagCompound == null ? null : (EnumGamemode)nbtTagCompound.a("previousPlayerGameType", EnumGamemode.h).orElse(null);
        fakeEntityPlayer.setGameMode(gameType1, gameType2);
    }

    private static DataResult<ResourceKey<net.minecraft.world.level.World>> parseLegacyDimensionType(ValueInput nbttagcompound) {
        block9: {
            try {
                Optional dimensionInput = nbttagcompound.e("Dimension");
                if (dimensionInput.isPresent()) {
                    switch ((Integer)dimensionInput.get()) {
                        case -1: {
                            return DataResult.success((Object)net.minecraft.world.level.World.i);
                        }
                        case 0: {
                            return DataResult.success((Object)net.minecraft.world.level.World.h);
                        }
                        case 1: {
                            return DataResult.success((Object)net.minecraft.world.level.World.j);
                        }
                    }
                }
            }
            catch (WrongNbtTypeException e) {
                if (e.problem.c() == NBTTagString.a) break block9;
                return DataResult.error(() -> "Unexpected NBT type for field 'Dimension'. Expected number or string, but got: " + e.problem.c().a());
            }
        }
        Optional decodedLevel = nbttagcompound.a("Dimension", net.minecraft.world.level.World.g);
        if (decodedLevel.isPresent()) {
            return DataResult.success((Object)((ResourceKey)decodedLevel.get()));
        }
        return DataResult.error(() -> "No Dimension information in " + String.valueOf(nbttagcompound) + ".");
    }

    private static Optional<InventoryOpenEvent> callInventoryOpenEvent(EntityPlayer nmsPlayer, Container nmsView) {
        if (nmsPlayer.cl != nmsPlayer.ck) {
            nmsPlayer.g.a(new PacketPlayInCloseWindow(nmsPlayer.cl.l));
        }
        CraftServer server = HybridServerSupport.getServer((EntityPlayer)nmsPlayer).server;
        CraftPlayer bukkitPlayer = nmsPlayer.getBukkitEntity();
        nmsPlayer.cl.transferTo(nmsView, (CraftHumanEntity)bukkitPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(nmsView.getBukkitView());
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            nmsView.transferTo(nmsPlayer.cl, (CraftHumanEntity)bukkitPlayer);
            return Optional.of(event);
        }
        return Optional.empty();
    }

    @Override
    public PlaceholderPalette getPlaceholderPalette(String name) {
        return switch (name) {
            case "glass panes" -> Placeholders.PALETTE_GLASS;
            case "icons" -> Placeholders.PALETTE_ICONS;
            default -> PlaceholderPalette.empty();
        };
    }

    static void sendItemChange(EntityPlayer entityPlayer, int rawIndex, net.minecraft.world.item.ItemStack toSend) {
        Container container = entityPlayer.cl;
        entityPlayer.g.b((Packet)new PacketPlayOutSetSlot(container.l, container.k(), rawIndex, toSend));
    }

    static net.minecraft.world.item.ItemStack getItemOrPlaceholder(PlaceholderPalette palette, MainBukkitInventoryView view, int rawIndex, PlaceholderGroup group) {
        Slot slot = view.nms.b(rawIndex);
        if (slot.h()) {
            return slot.g();
        }
        if (slot instanceof InaccessibleSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
        }
        if (slot instanceof BootsSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourBoots());
        }
        if (slot instanceof LeggingsSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourLeggings());
        }
        if (slot instanceof ChestplateSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourChestplate());
        }
        if (slot instanceof HelmetSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourLeggings());
        }
        if (slot instanceof OffhandSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.offHand());
        }
        if (slot instanceof BodySlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.body());
        }
        if (slot instanceof SaddleSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.saddle());
        }
        if (slot instanceof CursorSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.cursor());
        }
        if (slot instanceof PersonalSlot) {
            PersonalSlot personalSlot = (PersonalSlot)slot;
            if (!personalSlot.works()) {
                return CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
            }
            if (group == null) {
                return net.minecraft.world.item.ItemStack.l;
            }
            Mirror<PlayerInventorySlot> mirror = view.nms.creationOptions.getMirror();
            PlayerInventorySlot pis = mirror.getSlot(rawIndex);
            if (pis == null) {
                return CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
            }
            return CraftItemStack.asNMSCopy((ItemStack)palette.getPersonalSlotPlaceholder(pis, group));
        }
        return net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public Stream<Material> materials() {
        Registry registry = Bukkit.getRegistry(Material.class);
        Stream res = registry != null ? registry.stream() : Registry.MATERIAL.stream();
        return res.filter(Material::isItem);
    }

    @Override
    public Object loadPlayerSaveCompound(UUID playerId, String playerName) {
        CraftServer craftServer = (CraftServer)this.plugin.getServer();
        WorldNBTStorage worldNBTStorage = craftServer.getHandle().s;
        IRegistryCustom registryAccess = CraftRegistry.getMinecraftRegistry();
        ThrowingProblemReporter problemReporter = ThrowingProblemReporter.INSTANCE;
        ValueInput valueInput = HybridServerSupport.load(worldNBTStorage, playerName, playerId.toString(), problemReporter, registryAccess).get();
        TagValueInput tagValueInput = (TagValueInput)valueInput;
        NBTTagCompound compoundTag = tagValueInput.c;
        return compoundTag;
    }
}

