/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_9_R6;

import com.google.common.base.Preconditions;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.SpectatorInventoryView;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.Mirror;
import java.util.Objects;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

abstract class BukkitInventoryView<Slot>
implements SpectatorInventoryView<Slot>,
InventoryView {
    private final CreationOptions<Slot> creationOptions;
    protected Target target;

    BukkitInventoryView(CreationOptions<Slot> creationOptions) {
        this.creationOptions = Objects.requireNonNull(creationOptions, "creation options cannot be null");
    }

    public void setCursor(ItemStack itemStack) {
        this.getPlayer().setItemOnCursor(itemStack);
    }

    public ItemStack getCursor() {
        return this.getPlayer().getItemOnCursor();
    }

    public Inventory getInventory(int rawSlot) {
        if (rawSlot == -999 || rawSlot == -1) {
            return null;
        }
        Preconditions.checkArgument((rawSlot >= 0 ? 1 : 0) != 0, (String)"Negative, non outside slot %s", (int)rawSlot);
        Preconditions.checkArgument((rawSlot < this.countSlots() ? 1 : 0) != 0, (String)"Slot %s greater than inventory slot count", (int)rawSlot);
        return rawSlot < this.getTopInventory().getSize() ? this.getTopInventory() : this.getBottomInventory();
    }

    public int convertSlot(int rawSlot) {
        int topSize = this.getTopInventory().getSize();
        if (rawSlot < topSize) {
            return rawSlot;
        }
        int slot = rawSlot - topSize;
        slot = slot >= 27 ? (slot -= 27) : (slot += 9);
        return slot;
    }

    public InventoryType.SlotType getSlotType(int slot) {
        if (slot < 0) {
            return InventoryType.SlotType.OUTSIDE;
        }
        int slotCount = this.countSlots();
        if (slotCount - 9 <= slot && slot < slotCount) {
            return InventoryType.SlotType.QUICKBAR;
        }
        return InventoryType.SlotType.CONTAINER;
    }

    public void close() {
        this.getPlayer().closeInventory();
    }

    public int countSlots() {
        return this.getTopInventory().getSize() + this.getBottomInventory().getStorageContents().length;
    }

    public boolean setProperty(InventoryView.Property property, int value) {
        return this.getPlayer().setWindowProperty(property, value);
    }

    @Override
    public CreationOptions<Slot> getCreationOptions() {
        return this.creationOptions.clone();
    }

    @Override
    public Mirror<Slot> getMirror() {
        return this.creationOptions.getMirror();
    }

    @Override
    public Target getTarget() {
        SpectatorInventory top = this.getTopInventory();
        return this.target == null ? (this.target = Target.byGameProfile(top.getSpectatedPlayerId(), top.getSpectatedPlayerName())) : this.target;
    }
}

