/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_5_R4;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderGroup;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_21_5_R4.InvseeImpl;
import com.janboerman.invsee.spigot.impl_1_21_5_R4.ItemUtils;
import com.janboerman.invsee.spigot.impl_1_21_5_R4.MainBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_21_5_R4.MainNmsInventory;
import com.janboerman.invsee.spigot.internal.inventory.MainInventory;
import com.janboerman.invsee.utils.Ref;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.InventoryCrafting;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryMerchant;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftResultInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

class MainBukkitInventory
extends CraftInventory
implements MainInventory<MainNmsInventory, MainBukkitInventory> {
    protected MainBukkitInventory(MainNmsInventory inventory) {
        super((IInventory)inventory);
    }

    @Override
    public MainNmsInventory getInventory() {
        return (MainNmsInventory)super.getInventory();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public void watch(InventoryView targetPlayerView) {
        Objects.requireNonNull(targetPlayerView, "targetPlayerView cannot be null");
        placeholderGroup = null;
        nms = this.getInventory();
        top = targetPlayerView.getTopInventory();
        if (top instanceof CraftInventoryCrafting) {
            cic = (CraftInventoryCrafting)top;
            targetCrafting = (InventoryCrafting)cic.getInventory();
            nms.personalContents = targetCrafting.getContents();
            placeholderGroup = PlaceholderGroup.CRAFTING;
        } else if (top instanceof CraftInventoryMerchant) {
            cim = (CraftInventoryMerchant)top;
            merchantItems = cim.getInventory();
            nms.personalContents = merchantItems.getContents().subList(0, 2);
            placeholderGroup = PlaceholderGroup.MERCHANT;
        } else if (top instanceof CraftInventoryEnchanting) {
            cie = (CraftInventoryEnchanting)top;
            enchantItems = cie.getInventory();
            nms.personalContents = enchantItems.getContents();
            placeholderGroup = PlaceholderGroup.ENCHANTING;
        } else if (top instanceof CraftResultInventory) {
            cri = (CraftResultInventory)top;
            inputItems = cri.getInventory();
            nms.personalContents = inputItems.getContents();
            switch (1.$SwitchMap$org$bukkit$event$inventory$InventoryType[cri.getType().ordinal()]) {
                case 1: {
                    v0 = PlaceholderGroup.ANVIL;
                    break;
                }
                case 2: {
                    v0 = PlaceholderGroup.CARTOGRAPHY;
                    break;
                }
                case 3: {
                    v0 = PlaceholderGroup.GRINDSTONE;
                    break;
                }
                case 4: {
                    v0 = PlaceholderGroup.LOOM;
                    break;
                }
                case 5: 
                case 6: {
                    v0 = PlaceholderGroup.SMITHING;
                    break;
                }
                case 7: {
                    v0 = PlaceholderGroup.STONECUTTER;
                    break;
                }
                case 8: {
                    v0 = null;
                    break;
                }
                default: {
                    throw new RuntimeException("CraftResultInventory with unexpected InventoryType: " + String.valueOf(cri.getType()));
                }
            }
            placeholderGroup = v0;
        }
        var5_5 = this.getViewers().iterator();
        block9: while (true) {
            if (!var5_5.hasNext()) {
                return;
            }
            viewer = (HumanEntity)var5_5.next();
            if (!(viewer instanceof CraftPlayer) || !((inputItems = (spectator = (CraftPlayer)viewer).getOpenInventory()) instanceof MainBukkitInventoryView)) continue;
            view = (MainBukkitInventoryView)inputItems;
            creationOptions = view.nms.creationOptions;
            mirror = creationOptions.getMirror();
            palette = creationOptions.getPlaceholderPalette();
            i = PlayerInventorySlot.PERSONAL_00.defaultIndex();
            while (true) {
                if (i <= PlayerInventorySlot.PERSONAL_08.defaultIndex()) ** break;
                continue block9;
                rawIndex = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(i));
                if (rawIndex != null) {
                    stack = InvseeImpl.getItemOrPlaceholder(palette, view, rawIndex, placeholderGroup);
                    InvseeImpl.sendItemChange(spectator.getHandle(), rawIndex, stack);
                } else {
                    InvseeImpl.sendItemChange(spectator.getHandle(), i, CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible()));
                }
                ++i;
            }
            break;
        }
    }

    @Override
    public void unwatch() {
        MainNmsInventory nms = this.getInventory();
        nms.personalContents = nms.craftingContents;
        for (HumanEntity viewer : this.getViewers()) {
            CraftPlayer spectator;
            InventoryView inventoryView;
            if (!(viewer instanceof CraftPlayer) || !((inventoryView = (spectator = (CraftPlayer)viewer).getOpenInventory()) instanceof MainBukkitInventoryView)) continue;
            MainBukkitInventoryView view = (MainBukkitInventoryView)inventoryView;
            CreationOptions<PlayerInventorySlot> creationOptions = view.nms.creationOptions;
            Mirror<PlayerInventorySlot> mirror = creationOptions.getMirror();
            PlaceholderPalette palette = creationOptions.getPlaceholderPalette();
            for (int i = PlayerInventorySlot.PERSONAL_00.defaultIndex(); i <= PlayerInventorySlot.PERSONAL_08.defaultIndex(); ++i) {
                Integer rawIndex = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(i));
                if (rawIndex != null) {
                    net.minecraft.world.item.ItemStack stack = InvseeImpl.getItemOrPlaceholder(palette, view, rawIndex, PlaceholderGroup.CRAFTING);
                    InvseeImpl.sendItemChange(spectator.getHandle(), rawIndex, stack);
                    continue;
                }
                InvseeImpl.sendItemChange(spectator.getHandle(), i, CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible()));
            }
        }
    }

    @Override
    public ItemStack[] getStorageContents() {
        return (ItemStack[])this.getInventory().nmsPlayerInventory.i().stream().map(CraftItemStack::asCraftMirror).toArray(ItemStack[]::new);
    }

    @Override
    public void setStorageContents(ItemStack[] storageContents) {
        Objects.requireNonNull(storageContents, "storageContents cannot be null");
        int storageContentsSize = this.getInventory().nmsPlayerInventory.i().size();
        if (storageContents.length != storageContentsSize) {
            throw new IllegalArgumentException("storage contents must be of length " + storageContentsSize);
        }
        for (int i = 0; i < storageContentsSize; ++i) {
            this.getInventory().nmsPlayerInventory.i().set(i, (Object)CraftItemStack.asNMSCopy((ItemStack)storageContents[i]));
        }
    }

    @Override
    public ItemStack[] getArmourContents() {
        PlayerInventory inv = this.getInventory().nmsPlayerInventory;
        int storageContents = inv.i().size();
        return new ItemStack[]{CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inv.a(storageContents)), CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inv.a(storageContents + 1)), CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inv.a(storageContents + 2)), CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inv.a(storageContents + 3))};
    }

    @Override
    public void setArmourContents(ItemStack[] armourContents) {
        Objects.requireNonNull(armourContents, "armourContents cannot be null");
        int armourContentsSize = PlayerInventory.g.size() - 1;
        if (armourContents.length != armourContentsSize) {
            throw new IllegalArgumentException("armour contents must be of length " + armourContentsSize);
        }
        PlayerInventory inv = this.getInventory().nmsPlayerInventory;
        int storageContents = inv.i().size();
        for (int i = 0; i < armourContentsSize; ++i) {
            inv.a(storageContents + i, CraftItemStack.asNMSCopy((ItemStack)armourContents[i]));
        }
    }

    @Override
    public ItemStack[] getOffHandContents() {
        PlayerInventory inv = this.getInventory().nmsPlayerInventory;
        return new ItemStack[]{CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inv.a(40))};
    }

    @Override
    public void setOffHandContents(ItemStack[] offHand) {
        Objects.requireNonNull(offHand, "offHand cannot be null");
        int offHandContentsSize = 1;
        if (offHand.length != offHandContentsSize) {
            throw new IllegalArgumentException("offHand must be of length " + offHandContentsSize);
        }
        PlayerInventory inv = this.getInventory().nmsPlayerInventory;
        for (int i = 0; i < offHandContentsSize; ++i) {
            inv.a(40 + i, CraftItemStack.asNMSCopy((ItemStack)offHand[i]));
        }
    }

    @Override
    public void setCursorContents(ItemStack cursor) {
        Ref<net.minecraft.world.item.ItemStack> onCursor = this.getInventory().onCursor;
        if (onCursor != null) {
            onCursor.set(CraftItemStack.asNMSCopy((ItemStack)cursor));
        }
    }

    @Override
    public ItemStack getCursorContents() {
        Ref<net.minecraft.world.item.ItemStack> onCursor = this.getInventory().onCursor;
        if (onCursor != null) {
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)onCursor.get());
        }
        return null;
    }

    @Override
    public void setPersonalContents(ItemStack[] craftingContents) {
        Objects.requireNonNull(craftingContents, "craftingContents cannot be null");
        MainNmsInventory nms = this.getInventory();
        List<net.minecraft.world.item.ItemStack> nmsCraftingItems = nms.personalContents;
        if (nmsCraftingItems != null) {
            int craftingContentsSize = nmsCraftingItems.size();
            if (craftingContents.length != craftingContentsSize) {
                throw new IllegalArgumentException("craftingContents must be of length " + craftingContentsSize);
            }
            for (int i = 0; i < craftingContentsSize; ++i) {
                nmsCraftingItems.set(i, CraftItemStack.asNMSCopy((ItemStack)craftingContents[i]));
            }
        }
    }

    @Override
    public ItemStack[] getPersonalContents() {
        List<net.minecraft.world.item.ItemStack> nmsCraftingItems = this.getInventory().personalContents;
        if (nmsCraftingItems != null) {
            return (ItemStack[])nmsCraftingItems.stream().map(CraftItemStack::asCraftMirror).toArray(ItemStack[]::new);
        }
        return new ItemStack[0];
    }

    @Override
    public int getPersonalContentsSize() {
        List<net.minecraft.world.item.ItemStack> nmsCraftingItems = this.getInventory().personalContents;
        if (nmsCraftingItems != null) {
            return nmsCraftingItems.size();
        }
        return 0;
    }

    public int first(ItemStack stack) {
        return this.first(stack, true);
    }

    public int first(ItemStack stack, boolean withAmount) {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (!(item != null ? (withAmount ? item.equals((Object)stack) : item.isSimilar(stack)) : stack == null)) continue;
            return slot;
        }
        return -1;
    }

    public int first(Material material) {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if ((item != null || material != null) && (item == null || item.getType() != material)) continue;
            return slot;
        }
        return -1;
    }

    public int firstEmpty() {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (!ItemUtils.isEmpty(item)) continue;
            return slot;
        }
        return -1;
    }

    public int firstPartial(Material material) {
        if (material == null) {
            return -1;
        }
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || item.getType() != material || item.getAmount() >= ItemUtils.getMaxStackSize(item)) continue;
            return slot;
        }
        return -1;
    }

    public int firstPartial(ItemStack item) {
        if (item == null) {
            return -1;
        }
        item = CraftItemStack.asCraftCopy((ItemStack)item);
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack cItem = this.getItem(slot);
            if (cItem == null || cItem.getAmount() >= ItemUtils.getMaxStackSize(cItem) || !cItem.isSimilar(item)) continue;
            return slot;
        }
        return -1;
    }

    public boolean contains(Material material) {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if ((item != null || material != null) && (item == null || item.getType() != material)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack stack) {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (!Objects.equals(item, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Material material, int amount) {
        if (amount <= 0) {
            return true;
        }
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || item.getType() != material || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemStack stack, int count) {
        if (count <= 0) {
            return true;
        }
        int encountered = 0;
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (!Objects.equals(item, stack) || ++encountered < count) continue;
            return true;
        }
        return false;
    }

    public boolean containsAtLeast(ItemStack stack, int amount) {
        if (amount <= 0) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        int encountered = 0;
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || !item.isSimilar(stack) || (encountered += item.getAmount()) < amount) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if ((item != null || material != null) && (item == null || item.getType() != material)) continue;
            slots.put(slot, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(ItemStack stack) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (!Objects.equals(item, stack)) continue;
            slots.put(slot, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack[] items) {
        HashMap<Integer, ItemStack> leftOvers = new HashMap<Integer, ItemStack>();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ItemStack leftOver = this.addItem(items[i]);
                if (leftOver == null || leftOver.getAmount() <= 0) continue;
                leftOvers.put(i, leftOver);
            }
        }
        return leftOvers;
    }

    private ItemStack addItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getAmount() == 0) {
            return null;
        }
        ItemStack[] storageContents = this.getStorageContents();
        MainBukkitInventory.addItem(storageContents, itemStack, this.getMaxStackSize());
        this.setStorageContents(storageContents);
        if (itemStack.getAmount() == 0) {
            return null;
        }
        ItemStack[] armourContents = this.getArmourContents();
        MainBukkitInventory.addItem(armourContents, itemStack, this.getMaxStackSize());
        this.setArmourContents(armourContents);
        if (itemStack.getAmount() == 0) {
            return null;
        }
        ItemStack[] offHand = this.getOffHandContents();
        MainBukkitInventory.addItem(offHand, itemStack, this.getMaxStackSize());
        this.setOffHandContents(offHand);
        return itemStack;
    }

    static void addItem(ItemStack[] contents, ItemStack add, int inventoryMaxStackSize) {
        assert (contents != null && add != null);
        for (int i = 0; i < contents.length && add.getAmount() > 0; ++i) {
            ItemStack existingStack = contents[i];
            if (!add.isSimilar(existingStack)) continue;
            int maxStackSizeForThisItem = Math.min(inventoryMaxStackSize, ItemUtils.getMaxStackSize(existingStack));
            if (existingStack.getAmount() >= maxStackSizeForThisItem) continue;
            int maxMergeAmount = Math.min(maxStackSizeForThisItem - existingStack.getAmount(), add.getAmount());
            assert (maxMergeAmount > 0) : "Trying to merge a non-positive number of items: " + maxMergeAmount;
            if (add.getAmount() <= maxMergeAmount) {
                existingStack.setAmount(existingStack.getAmount() + add.getAmount());
                add.setAmount(0);
                continue;
            }
            assert (maxStackSizeForThisItem == existingStack.getAmount() + maxMergeAmount);
            existingStack.setAmount(maxStackSizeForThisItem);
            add.setAmount(add.getAmount() - maxMergeAmount);
        }
        int maxStackSizeForThisItem = Math.min(inventoryMaxStackSize, Math.min(ItemUtils.getMaxStackSize(add), add.getAmount()));
        for (int i = 0; i < contents.length && add.getAmount() > 0; ++i) {
            if (!ItemUtils.isEmpty(contents[i])) continue;
            if (add.getAmount() <= maxStackSizeForThisItem) {
                contents[i] = add.clone();
                add.setAmount(0);
                continue;
            }
            ItemStack clone = add.clone();
            clone.setAmount(maxStackSizeForThisItem);
            contents[i] = clone;
            add.setAmount(add.getAmount() - maxStackSizeForThisItem);
        }
    }

    public void remove(Material material) {
        if (material == null) {
            return;
        }
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || item.getType() != material) continue;
            this.clear(slot);
        }
    }

    public void remove(ItemStack stack) {
        if (stack == null) {
            return;
        }
        for (int slot = 0; slot < this.getSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (item == null || !item.equals((Object)stack)) continue;
            this.clear(slot);
        }
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        HashMap<Integer, ItemStack> leftOvers = new HashMap<Integer, ItemStack>();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ItemStack leftOver = this.removeItem(items[i]);
                if (leftOver == null || leftOver.getAmount() <= 0) continue;
                leftOvers.put(i, leftOver);
            }
        }
        return leftOvers;
    }

    private ItemStack removeItem(ItemStack remove) {
        if (remove == null || remove.getAmount() == 0) {
            return null;
        }
        for (int slot = 0; slot < this.getSize() && remove.getAmount() > 0; ++slot) {
            ItemStack existingStack = this.getItem(slot);
            if (!remove.isSimilar(existingStack)) continue;
            int maxRemoveAmount = Math.min(existingStack.getAmount(), remove.getAmount());
            existingStack.setAmount(existingStack.getAmount() - maxRemoveAmount);
            remove.setAmount(remove.getAmount() - maxRemoveAmount);
        }
        return remove;
    }
}

