/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_1_R1;

import com.janboerman.invsee.spigot.impl_1_21_1_R1.EnderNmsInventory;
import com.janboerman.invsee.spigot.impl_1_21_1_R1.ItemUtils;
import com.janboerman.invsee.spigot.internal.inventory.EnderInventory;
import java.util.HashMap;
import net.minecraft.world.IInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.inventory.ItemStack;

class EnderBukkitInventory
extends CraftInventory
implements EnderInventory<EnderNmsInventory, EnderBukkitInventory> {
    protected EnderBukkitInventory(EnderNmsInventory inventory) {
        super((IInventory)inventory);
    }

    @Override
    public EnderNmsInventory getInventory() {
        return (EnderNmsInventory)super.getInventory();
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack[] items) {
        HashMap<Integer, ItemStack> leftOvers = new HashMap<Integer, ItemStack>();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ItemStack leftOver = this.addItem(items[i]);
                if (leftOver == null || leftOver.getAmount() <= 0) continue;
                leftOvers.put(i, leftOver);
            }
        }
        return leftOvers;
    }

    private ItemStack addItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getAmount() == 0) {
            return null;
        }
        ItemStack[] storageContents = this.getStorageContents();
        EnderBukkitInventory.addItem(storageContents, itemStack, this.getMaxStackSize());
        this.setStorageContents(storageContents);
        return itemStack;
    }

    private static void addItem(ItemStack[] contents, ItemStack add, int inventoryMaxStackSize) {
        assert (contents != null && add != null);
        for (int i = 0; i < contents.length && add.getAmount() > 0; ++i) {
            int maxMergeAmount;
            ItemStack existingStack = contents[i];
            if (!add.isSimilar(existingStack)) continue;
            int maxStackSizeForThisItem = Math.min(inventoryMaxStackSize, ItemUtils.getMaxStackSize(existingStack));
            if (existingStack.getAmount() >= maxStackSizeForThisItem || (maxMergeAmount = Math.min(maxStackSizeForThisItem - existingStack.getAmount(), add.getAmount())) <= 0) continue;
            if (add.getAmount() <= maxMergeAmount) {
                existingStack.setAmount(existingStack.getAmount() + add.getAmount());
                add.setAmount(0);
                continue;
            }
            assert (maxStackSizeForThisItem == existingStack.getAmount() + maxMergeAmount);
            existingStack.setAmount(maxStackSizeForThisItem);
            add.setAmount(add.getAmount() - maxMergeAmount);
        }
        int maxStackSizeForThisItem = Math.min(inventoryMaxStackSize, Math.min(ItemUtils.getMaxStackSize(add), add.getAmount()));
        for (int i = 0; i < contents.length && add.getAmount() > 0; ++i) {
            if (!ItemUtils.isEmpty(contents[i])) continue;
            if (add.getAmount() <= maxStackSizeForThisItem) {
                contents[i] = add.clone();
                add.setAmount(0);
                continue;
            }
            ItemStack clone = add.clone();
            clone.setAmount(maxStackSizeForThisItem);
            contents[i] = clone;
            add.setAmount(add.getAmount() - maxStackSizeForThisItem);
        }
    }
}

