/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_11_R7;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.BodySlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.BootsSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.ChestplateSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.CursorSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.HelmetSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.InaccessibleSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.LeggingsSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.MainBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.MainNmsInventory;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.OffhandSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.PersonalSlot;
import com.janboerman.invsee.spigot.impl_1_21_11_R7.SaddleSlot;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class MainNmsContainer
extends Container {
    final EntityHuman player;
    final MainNmsInventory top;
    final PlayerInventory bottom;
    final String originalTitle;
    String title;
    final CreationOptions<PlayerInventorySlot> creationOptions;
    private final boolean spectatingOwnInventory;
    private MainBukkitInventoryView bukkitView;
    final DifferenceTracker tracker;

    private static Slot makeSlot(Mirror<PlayerInventorySlot> mirror, boolean spectatingOwnInventory, MainNmsInventory top, int positionIndex, int magicX, int magicY, net.minecraft.world.item.ItemStack inaccessiblePlaceholder) {
        PlayerInventorySlot place = mirror.getSlot(positionIndex);
        if (place == null) {
            return new InaccessibleSlot(inaccessiblePlaceholder, top, positionIndex, magicX, magicY);
        }
        if (place.isContainer()) {
            int referringTo = place.ordinal() - PlayerInventorySlot.CONTAINER_00.ordinal();
            return new Slot((IInventory)top, referringTo, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_BOOTS) {
            int referringTo = 36;
            return new BootsSlot(top, 36, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_LEGGINGS) {
            int referringTo = 37;
            return new LeggingsSlot(top, 37, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_CHESTPLATE) {
            int referringTo = 38;
            return new ChestplateSlot(top, 38, magicX, magicY);
        }
        if (place == PlayerInventorySlot.ARMOUR_HELMET) {
            int referringTo = 39;
            return new HelmetSlot(top, 39, magicX, magicY);
        }
        if (place.isOffHand()) {
            int referringTo = 40;
            return new OffhandSlot(top, 40, magicX, magicY);
        }
        if (place.isBody()) {
            int referringTo = 41;
            return new BodySlot(top, 41, magicX, magicY);
        }
        if (place.isSaddle()) {
            int referringTo = 42;
            return new SaddleSlot(top, 42, magicX, magicY);
        }
        if (place.isCursor() && !spectatingOwnInventory) {
            int referringTo = 43;
            return new CursorSlot(top, 43, magicX, magicY);
        }
        if (place.isPersonal()) {
            int referringTo = place.ordinal() - PlayerInventorySlot.PERSONAL_00.ordinal() + 45;
            return new PersonalSlot(inaccessiblePlaceholder, top, referringTo, magicX, magicY);
        }
        return new InaccessibleSlot(inaccessiblePlaceholder, top, positionIndex, magicX, magicY);
    }

    public void a(int i, int j, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        List<ItemStack> contentsBefore = null;
        if (this.tracker != null) {
            contentsBefore = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).toList();
        }
        super.a(i, j, inventoryclicktype, entityhuman);
        if (this.tracker != null) {
            List<ItemStack> contentsAfter = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).toList();
            this.tracker.onClick(contentsBefore, contentsAfter);
        }
    }

    public void a(EntityHuman entityhuman) {
        super.a(entityhuman);
        if (this.tracker != null && Objects.equals(entityhuman, this.player)) {
            this.tracker.onClose();
        }
    }

    MainNmsContainer(int id, MainNmsInventory nmsInventory, PlayerInventory bottomInventory, EntityHuman spectator, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(Containers.f, id);
        int magicY;
        int magicX;
        int index;
        int xPos;
        this.top = nmsInventory;
        this.bottom = bottomInventory;
        this.player = spectator;
        this.spectatingOwnInventory = spectator.cY().equals(nmsInventory.targetPlayerUuid);
        this.creationOptions = creationOptions;
        Target target = Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName);
        this.originalTitle = creationOptions.getTitle().titleFor(target);
        Mirror<PlayerInventorySlot> mirror = creationOptions.getMirror();
        LogOptions logOptions = creationOptions.getLogOptions();
        Plugin plugin = creationOptions.getPlugin();
        if (!LogOptions.isEmpty(logOptions)) {
            this.tracker = new DifferenceTracker(LogOutput.make(plugin, this.player.cY(), this.player.da(), target, logOptions), logOptions.getGranularity());
            this.tracker.onOpen();
        } else {
            this.tracker = null;
        }
        net.minecraft.world.item.ItemStack inaccessibleSlotPlaceholder = CraftItemStack.asNMSCopy((ItemStack)creationOptions.getPlaceholderPalette().inaccessible());
        for (int yPos = 0; yPos < 6; ++yPos) {
            for (xPos = 0; xPos < 9; ++xPos) {
                index = xPos + yPos * 9;
                magicX = 8 + xPos * 18;
                magicY = 18 + yPos * 18;
                this.a(MainNmsContainer.makeSlot(mirror, this.spectatingOwnInventory, this.top, index, magicX, magicY, inaccessibleSlotPlaceholder));
            }
        }
        int magicAddY = 36;
        for (int yPos = 1; yPos < 4; ++yPos) {
            for (int xPos2 = 0; xPos2 < 9; ++xPos2) {
                int index2 = xPos2 + yPos * 9;
                int magicX2 = 8 + xPos2 * 18;
                int magicY2 = 103 + yPos * 18 + magicAddY;
                this.a(new Slot((IInventory)bottomInventory, index2, magicX2, magicY2));
            }
        }
        for (xPos = 0; xPos < 9; ++xPos) {
            index = xPos;
            magicX = 8 + xPos * 18;
            magicY = 161 + magicAddY;
            this.a(new Slot((IInventory)bottomInventory, index, magicX, magicY));
        }
    }

    public MainBukkitInventoryView getBukkitView() {
        if (this.bukkitView == null) {
            this.bukkitView = new MainBukkitInventoryView(this);
        }
        return this.bukkitView;
    }

    public boolean b(EntityHuman player) {
        return true;
    }

    public net.minecraft.world.item.ItemStack b(EntityHuman entityHuman, int rawIndex) {
        if (this.spectatingOwnInventory) {
            return net.minecraft.world.item.ItemStack.l;
        }
        net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.l;
        Slot slot = this.b(rawIndex);
        int topRows = 6;
        if (slot != null && slot.h()) {
            net.minecraft.world.item.ItemStack clickedSlotItem = slot.g();
            itemStack = clickedSlotItem.v();
            if (rawIndex < 54 ? !this.a(clickedSlotItem, 54, this.k.size(), true) : !this.a(clickedSlotItem, 0, 54, false)) {
                return net.minecraft.world.item.ItemStack.l;
            }
            if (clickedSlotItem.f()) {
                slot.f(net.minecraft.world.item.ItemStack.l);
            } else {
                slot.d();
            }
        }
        return itemStack;
    }

    public String title() {
        return this.title != null ? this.title : this.originalTitle;
    }
}

