/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_21_11_R7;

import com.janboerman.invsee.spigot.impl_1_21_11_R7.FakeEntityPlayer;
import com.janboerman.invsee.utils.FuzzyReflection;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.WorldNBTStorage;

public final class HybridServerSupport {
    private HybridServerSupport() {
    }

    public static File getPlayerDir(WorldNBTStorage worldNBTStorage) {
        try {
            return worldNBTStorage.getPlayerDir();
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            try {
                Method method = worldNBTStorage.getClass().getMethod("getPlayerDataFolder", new Class[0]);
                return (File)method.invoke((Object)worldNBTStorage, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException forgeMethodNotFound) {
                Field[] fields;
                Field[] fieldArray = fields = FuzzyReflection.getFieldOfType(WorldNBTStorage.class, File.class);
                int n = fieldArray.length;
                int n2 = 0;
                if (n2 < n) {
                    Field field = fieldArray[n2];
                    try {
                        return (File)field.get(worldNBTStorage);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Could not access player data folder field from PlayerDataStorage", e);
                    }
                }
                RuntimeException ex = new RuntimeException("No method known of getting the player directory");
                ex.addSuppressed(craftbukkitMethodNotFound);
                ex.addSuppressed(forgeMethodNotFound);
                throw ex;
            }
        }
    }

    public static int nextContainerCounter(EntityPlayer nmsPlayer) {
        try {
            return nmsPlayer.nextContainerCounter();
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                MethodHandle methodHandle = lookup.findVirtual(nmsPlayer.getClass(), "nextContainerCounterInt", MethodType.methodType(Integer.TYPE));
                return methodHandle.invoke(nmsPlayer);
            }
            catch (Throwable magmaMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of incrementing the player's container counter");
                ex.addSuppressed(craftbukkitMethodNotFound);
                ex.addSuppressed(magmaMethodNotFound);
                throw ex;
            }
        }
    }

    public static NonNullList<ItemStack> enderChestItems(InventoryEnderChest enderChest) {
        try {
            return enderChest.c;
        }
        catch (IllegalAccessError | NoSuchFieldError vanillaFieldIsActuallyPrivate) {
            try {
                return (NonNullList)enderChest.getContents();
            }
            catch (Throwable forgeMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of getting the enderchest items");
                ex.addSuppressed(vanillaFieldIsActuallyPrivate);
                ex.addSuppressed(forgeMethodNotFound);
                throw ex;
            }
        }
    }

    public static Optional<ValueInput> load(WorldNBTStorage playerIO, String name, String uuid, ProblemReporter problemReporter, IRegistryCustom registryAccess) {
        try {
            return playerIO.a(new NameAndId(UUID.fromString(uuid), name)).map(compoundTag -> TagValueInput.a((ProblemReporter)problemReporter, (HolderLookup.a)registryAccess, (NBTTagCompound)compoundTag));
        }
        catch (NoSuchMethodError craftbukkitMethodNotFound) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                MethodHandle methodHandle = lookup.findVirtual(WorldNBTStorage.class, "load", MethodType.methodType(Optional.class, String.class, String.class, ProblemReporter.class));
                Optional optionalCompoundTag = methodHandle.invoke(playerIO, name, uuid, problemReporter);
                return optionalCompoundTag.map(compoundTag -> TagValueInput.a((ProblemReporter)problemReporter, (HolderLookup.a)registryAccess, (NBTTagCompound)compoundTag));
            }
            catch (Throwable paperMethodNotFound) {
                RuntimeException ex = new RuntimeException("No method known of loading the player's data file");
                ex.addSuppressed(craftbukkitMethodNotFound);
                ex.addSuppressed(paperMethodNotFound);
                throw ex;
            }
        }
    }

    public static MinecraftServer getServer(EntityPlayer nmsPlayer) {
        try {
            return nmsPlayer.cL;
        }
        catch (IllegalAccessError error) {
            Field[] fields = FuzzyReflection.getFieldOfType(EntityPlayer.class, MinecraftServer.class);
            if (fields.length == 1) {
                try {
                    return (MinecraftServer)fields[0].get(nmsPlayer);
                }
                catch (IllegalAccessException exception) {
                    RuntimeException ex = new RuntimeException("No method known of obtaining the EntityPlayer's MinecraftServer");
                    ex.addSuppressed(error);
                    ex.addSuppressed(exception);
                    throw ex;
                }
            }
            throw error;
        }
    }

    public static Optional<NBTTagCompound> loadPlayerData(WorldNBTStorage worldNbtStorage, EntityHuman entityHuman) {
        try {
            return worldNbtStorage.load(entityHuman);
        }
        catch (NoSuchMethodError nsme) {
            return worldNbtStorage.a(entityHuman.gJ());
        }
    }

    public static void spawnIn(FakeEntityPlayer fakeEntityPlayer, World world) {
        try {
            fakeEntityPlayer.spawnIn(world, true);
        }
        catch (NoSuchMethodError e1) {
            RuntimeException ex = new RuntimeException("No method known to set the player's location.");
            ex.addSuppressed(e1);
            try {
                Method method = EntityPlayer.class.getDeclaredMethod("spawnIn", WorldServer.class);
                method.invoke((Object)fakeEntityPlayer, world);
            }
            catch (ReflectiveOperationException e3) {
                ex.addSuppressed(e3);
                throw ex;
            }
        }
    }
}

