/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_20_4_R3;

import com.janboerman.invsee.spigot.impl_1_20_4_R3.EnderNmsInventory;
import com.janboerman.invsee.spigot.internal.inventory.EnderInventory;
import java.util.HashMap;
import net.minecraft.world.IInventory;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventory;
import org.bukkit.inventory.ItemStack;

class EnderBukkitInventory
extends CraftInventory
implements EnderInventory<EnderNmsInventory, EnderBukkitInventory> {
    protected EnderBukkitInventory(EnderNmsInventory inventory) {
        super((IInventory)inventory);
    }

    @Override
    public EnderNmsInventory getInventory() {
        return (EnderNmsInventory)super.getInventory();
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack[] items) {
        HashMap<Integer, ItemStack> leftOvers = new HashMap<Integer, ItemStack>();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ItemStack leftOver = this.addItem(items[i]);
                if (leftOver == null || leftOver.getAmount() <= 0) continue;
                leftOvers.put(i, leftOver);
            }
        }
        return leftOvers;
    }

    private ItemStack addItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getAmount() == 0) {
            return null;
        }
        ItemStack[] storageContents = this.getStorageContents();
        EnderBukkitInventory.addItem(storageContents, itemStack, this.getMaxStackSize());
        this.setStorageContents(storageContents);
        return itemStack;
    }

    private static void addItem(ItemStack[] contents, ItemStack add, int inventoryMaxStackSize) {
        assert (contents != null && add != null);
        for (int i = 0; i < contents.length && add.getAmount() > 0; ++i) {
            int maxMergeAmount;
            ItemStack existingStack = contents[i];
            if (existingStack == null || !existingStack.isSimilar(add)) continue;
            int maxStackSizeForThisItem = Math.min(inventoryMaxStackSize, Math.max(existingStack.getMaxStackSize(), add.getAmount()));
            if (existingStack.getAmount() >= maxStackSizeForThisItem || (maxMergeAmount = Math.min(maxStackSizeForThisItem - existingStack.getAmount(), add.getAmount())) <= 0) continue;
            if (add.getAmount() <= maxMergeAmount) {
                existingStack.setAmount(existingStack.getAmount() + add.getAmount());
                add.setAmount(0);
                continue;
            }
            assert (maxStackSizeForThisItem == existingStack.getAmount() + maxMergeAmount);
            existingStack.setAmount(maxStackSizeForThisItem);
            add.setAmount(add.getAmount() - maxMergeAmount);
        }
        int maxStackSizeForThisItem = Math.min(inventoryMaxStackSize, Math.max(add.getMaxStackSize(), add.getAmount()));
        for (int i = 0; i < contents.length && add.getAmount() > 0; ++i) {
            if (contents[i] != null && contents[i].getAmount() != 0 && contents[i].getType() != Material.AIR) continue;
            if (add.getAmount() <= maxStackSizeForThisItem) {
                contents[i] = add.clone();
                add.setAmount(0);
                continue;
            }
            ItemStack clone = add.clone();
            clone.setAmount(maxStackSizeForThisItem);
            contents[i] = clone;
            add.setAmount(add.getAmount() - maxStackSizeForThisItem);
        }
    }
}

