/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_18_2_R2;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.impl_1_18_2_R2.EnderBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_18_2_R2.EnderNmsInventory;
import com.janboerman.invsee.spigot.impl_1_18_2_R2.InaccessiblePlaceholderSlot;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class EnderNmsContainer
extends Container {
    final EntityHuman player;
    final EnderNmsInventory top;
    final PlayerInventory bottom;
    final String title;
    final CreationOptions<EnderChestSlot> creationOptions;
    private final int topRows;
    private EnderBukkitInventoryView bukkitView;
    final DifferenceTracker tracker;

    private static Containers<?> determineMenuType(EnderNmsInventory inv) {
        return switch (inv.b()) {
            case 9 -> Containers.a;
            case 18 -> Containers.b;
            case 27 -> Containers.c;
            case 36 -> Containers.d;
            case 45 -> Containers.e;
            case 54 -> Containers.f;
            default -> Containers.c;
        };
    }

    private static Slot makeSlot(Mirror<EnderChestSlot> mirror, EnderNmsInventory top, int positionIndex, int magicX, int magicY, net.minecraft.world.item.ItemStack inaccessiblePlaceholder) {
        EnderChestSlot place = mirror.getSlot(positionIndex);
        if (place == null) {
            return new InaccessiblePlaceholderSlot(inaccessiblePlaceholder, top, positionIndex, magicX, magicY);
        }
        int referringTo = place.ordinal();
        return new Slot((IInventory)top, referringTo, magicX, magicY);
    }

    public void a(int i, int j, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        List<ItemStack> contentsBefore = null;
        if (this.tracker != null) {
            contentsBefore = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).toList();
        }
        super.a(i, j, inventoryclicktype, entityhuman);
        if (this.tracker != null) {
            List<ItemStack> contentsAfter = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).toList();
            this.tracker.onClick(contentsBefore, contentsAfter);
        }
    }

    public void b(EntityHuman entityhuman) {
        super.b(entityhuman);
        if (this.tracker != null && Objects.equals(entityhuman, this.player)) {
            this.tracker.onClose();
        }
    }

    EnderNmsContainer(int containerId, EnderNmsInventory nmsInventory, PlayerInventory playerInventory, EntityHuman player, CreationOptions<EnderChestSlot> creationOptions) {
        super(EnderNmsContainer.determineMenuType(nmsInventory), containerId);
        int magicY;
        int magicX;
        int index;
        int xPos;
        this.topRows = nmsInventory.b() / 9;
        this.player = player;
        this.top = nmsInventory;
        this.bottom = playerInventory;
        this.creationOptions = creationOptions;
        this.title = creationOptions.getTitle().titleFor(Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName));
        Mirror<EnderChestSlot> mirror = creationOptions.getMirror();
        LogOptions logOptions = creationOptions.getLogOptions();
        Plugin plugin = creationOptions.getPlugin();
        if (!LogOptions.isEmpty(logOptions)) {
            this.tracker = new DifferenceTracker(LogOutput.make(plugin, player.cm(), player.co(), Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName), logOptions), logOptions.getGranularity());
            this.tracker.onOpen();
        } else {
            this.tracker = null;
        }
        for (int yPos = 0; yPos < this.topRows; ++yPos) {
            for (xPos = 0; xPos < 9; ++xPos) {
                index = xPos + yPos * 9;
                magicX = 8 + xPos * 18;
                magicY = 18 + yPos * 18;
                this.a(EnderNmsContainer.makeSlot(mirror, this.top, index, magicX, magicY, CraftItemStack.asNMSCopy((ItemStack)creationOptions.getPlaceholderPalette().inaccessible())));
            }
        }
        int magicAddY = (this.topRows - 4) * 18;
        for (int yPos = 1; yPos < 4; ++yPos) {
            for (int xPos2 = 0; xPos2 < 9; ++xPos2) {
                int index2 = xPos2 + yPos * 9;
                int magicX2 = 8 + xPos2 * 18;
                int magicY2 = 103 + yPos * 18 + magicAddY;
                this.a(new Slot((IInventory)this.bottom, index2, magicX2, magicY2));
            }
        }
        for (xPos = 0; xPos < 9; ++xPos) {
            index = xPos;
            magicX = 8 + xPos * 18;
            magicY = 161 + magicAddY;
            this.a(new Slot((IInventory)this.bottom, index, magicX, magicY));
        }
    }

    public EnderBukkitInventoryView getBukkitView() {
        if (this.bukkitView == null) {
            this.bukkitView = new EnderBukkitInventoryView(this);
        }
        return this.bukkitView;
    }

    public boolean a(EntityHuman player) {
        return true;
    }

    public net.minecraft.world.item.ItemStack b(EntityHuman player, int rawIndex) {
        net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.b;
        Slot slot = this.b(rawIndex);
        if (slot != null && slot.f()) {
            net.minecraft.world.item.ItemStack clickedSlotItem = slot.e();
            itemStack = clickedSlotItem.n();
            if (rawIndex < this.topRows * 9 ? !this.a(clickedSlotItem, this.topRows * 9, this.i.size(), true) : !this.a(clickedSlotItem, 0, this.topRows * 9, false)) {
                return net.minecraft.world.item.ItemStack.b;
            }
            if (clickedSlotItem.b()) {
                slot.d(net.minecraft.world.item.ItemStack.b);
            } else {
                slot.d();
            }
        }
        return itemStack;
    }
}

