/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_17_1_R1;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventory;
import com.janboerman.invsee.spigot.api.EnderSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.MainSpectatorInventoryView;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.event.SpectatorInventorySaveEvent;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderGroup;
import com.janboerman.invsee.spigot.api.placeholder.PlaceholderPalette;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.NotOpenedReason;
import com.janboerman.invsee.spigot.api.response.OpenResponse;
import com.janboerman.invsee.spigot.api.response.SaveResponse;
import com.janboerman.invsee.spigot.api.response.SpectateResponse;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.BootsSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.ChestplateSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.CursorSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.EnderBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.EnderNmsContainer;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.EnderNmsInventory;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.FakeCraftPlayer;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.FakeEntityHuman;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.FakeEntityPlayer;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.HelmetSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.InaccessibleSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.LeggingsSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.MainBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.MainBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.MainNmsContainer;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.MainNmsInventory;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.NameSearchSaveFilesStrategy;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.OffhandSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.PersonalSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.Placeholders;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.UUIDSearchSaveFilesStrategy;
import com.janboerman.invsee.spigot.internal.EventHelper;
import com.janboerman.invsee.spigot.internal.InvseePlatform;
import com.janboerman.invsee.spigot.internal.NamesAndUUIDs;
import com.janboerman.invsee.spigot.internal.OpenSpectatorsCache;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InvseeImpl
implements InvseePlatform {
    static final net.minecraft.world.item.ItemStack EMPTY_STACK = net.minecraft.world.item.ItemStack.b;
    private final Plugin plugin;
    private final OpenSpectatorsCache cache;
    private final Scheduler scheduler;

    public InvseeImpl(Plugin plugin, NamesAndUUIDs lookup, Scheduler scheduler, OpenSpectatorsCache cache) {
        this.plugin = plugin;
        this.cache = cache;
        this.scheduler = scheduler;
        if (lookup.onlineMode(plugin.getServer())) {
            lookup.uuidResolveStrategies.add(new UUIDSearchSaveFilesStrategy(plugin, scheduler));
        } else {
            lookup.uuidResolveStrategies.add(lookup.uuidResolveStrategies.size() - 1, new UUIDSearchSaveFilesStrategy(plugin, scheduler));
        }
        lookup.nameResolveStrategies.add(2, new NameSearchSaveFilesStrategy(plugin, scheduler));
    }

    @Override
    public OpenResponse<MainSpectatorInventoryView> openMainSpectatorInventory(Player spectator, MainSpectatorInventory inv, CreationOptions<PlayerInventorySlot> options) {
        Target target = Target.byGameProfile(inv.getSpectatedPlayerId(), inv.getSpectatedPlayerName());
        String title = options.getTitle().titleFor(target);
        CraftPlayer bukkitPlayer = (CraftPlayer)spectator;
        EntityPlayer nmsPlayer = bukkitPlayer.getHandle();
        MainBukkitInventory bukkitInventory = (MainBukkitInventory)inv;
        MainNmsInventory nmsInventory = bukkitInventory.getInventory();
        int windowId = nmsPlayer.nextContainerCounter();
        PlayerInventory bottom = nmsPlayer.getInventory();
        MainNmsContainer nmsWindow = new MainNmsContainer(windowId, nmsInventory, bottom, (EntityHuman)nmsPlayer, options);
        nmsWindow.setTitle(CraftChatMessage.fromString((String)(title != null ? title : inv.getTitle()))[0]);
        Optional<InventoryOpenEvent> eventCancelled = InvseeImpl.callInventoryOpenEvent(nmsPlayer, nmsWindow);
        if (eventCancelled.isPresent()) {
            return OpenResponse.closed(NotOpenedReason.inventoryOpenEventCancelled(eventCancelled.get()));
        }
        nmsPlayer.bV = nmsWindow;
        nmsPlayer.b.sendPacket((Packet)new PacketPlayOutOpenWindow(windowId, nmsWindow.getType(), nmsWindow.getTitle()));
        nmsPlayer.initMenu((Container)nmsWindow);
        MainBukkitInventoryView bukkitView = nmsWindow.getBukkitView();
        Mirror<PlayerInventorySlot> mirror = options.getMirror();
        PlaceholderPalette palette = options.getPlaceholderPalette();
        net.minecraft.world.item.ItemStack inaccessible = CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
        for (int i = PlayerInventorySlot.CONTAINER_35.defaultIndex() + 1; i < nmsInventory.getSize(); ++i) {
            Integer idx = mirror.getIndex(PlayerInventorySlot.byDefaultIndex(i));
            if (idx == null) {
                InvseeImpl.sendItemChange(nmsPlayer, i, inaccessible);
                continue;
            }
            int rawIndex = idx;
            Slot slot = nmsWindow.getSlot(rawIndex);
            if (slot.hasItem()) continue;
            if (slot instanceof InaccessibleSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, inaccessible);
                continue;
            }
            if (slot instanceof BootsSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourBoots()));
                continue;
            }
            if (slot instanceof LeggingsSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourLeggings()));
                continue;
            }
            if (slot instanceof ChestplateSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourChestplate()));
                continue;
            }
            if (slot instanceof HelmetSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.armourHelmet()));
                continue;
            }
            if (slot instanceof OffhandSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.offHand()));
                continue;
            }
            if (slot instanceof CursorSlot) {
                InvseeImpl.sendItemChange(nmsPlayer, rawIndex, CraftItemStack.asNMSCopy((ItemStack)palette.cursor()));
                continue;
            }
            if (!(slot instanceof PersonalSlot)) continue;
            PersonalSlot personal = (PersonalSlot)slot;
            InvseeImpl.sendItemChange(nmsPlayer, rawIndex, personal.works() ? CraftItemStack.asNMSCopy((ItemStack)palette.generic()) : inaccessible);
        }
        return OpenResponse.open(bukkitView);
    }

    @Override
    public MainSpectatorInventory spectateInventory(HumanEntity player, CreationOptions<PlayerInventorySlot> options) {
        MainNmsInventory spectatorInv = new MainNmsInventory(((CraftHumanEntity)player).getHandle(), options);
        MainBukkitInventory bukkitInventory = (MainBukkitInventory)spectatorInv.bukkit();
        InventoryView targetView = player.getOpenInventory();
        bukkitInventory.watch(targetView);
        this.cache.cache(bukkitInventory);
        return bukkitInventory;
    }

    @Override
    public CompletableFuture<SpectateResponse<MainSpectatorInventory>> createOfflineInventory(UUID playerId, String playerName, CreationOptions<PlayerInventorySlot> options) {
        return this.createOffline(playerId, playerName, options, this::spectateInventory);
    }

    @Override
    public CompletableFuture<SaveResponse> saveInventory(MainSpectatorInventory newInventory) {
        return this.save(newInventory, this::spectateInventory, MainSpectatorInventory::setContents);
    }

    @Override
    public OpenResponse<EnderSpectatorInventoryView> openEnderSpectatorInventory(Player spectator, EnderSpectatorInventory inv, CreationOptions<EnderChestSlot> options) {
        Target target = Target.byGameProfile(inv.getSpectatedPlayerId(), inv.getSpectatedPlayerName());
        String title = options.getTitle().titleFor(target);
        CraftPlayer bukkitPlayer = (CraftPlayer)spectator;
        EntityPlayer nmsPlayer = bukkitPlayer.getHandle();
        EnderBukkitInventory bukkitInventory = (EnderBukkitInventory)inv;
        EnderNmsInventory nmsInventory = bukkitInventory.getInventory();
        int windowId = nmsPlayer.nextContainerCounter();
        PlayerInventory bottom = nmsPlayer.getInventory();
        EnderNmsContainer nmsWindow = new EnderNmsContainer(windowId, nmsInventory, bottom, (EntityHuman)nmsPlayer, options);
        nmsWindow.setTitle(CraftChatMessage.fromString((String)(title != null ? title : inv.getTitle()))[0]);
        Optional<InventoryOpenEvent> eventCancelled = InvseeImpl.callInventoryOpenEvent(nmsPlayer, nmsWindow);
        if (eventCancelled.isPresent()) {
            return OpenResponse.closed(NotOpenedReason.inventoryOpenEventCancelled(eventCancelled.get()));
        }
        nmsPlayer.bV = nmsWindow;
        nmsPlayer.b.sendPacket((Packet)new PacketPlayOutOpenWindow(windowId, nmsWindow.getType(), nmsWindow.getTitle()));
        nmsPlayer.initMenu((Container)nmsWindow);
        return OpenResponse.open(nmsWindow.getBukkitView());
    }

    @Override
    public EnderSpectatorInventory spectateEnderChest(HumanEntity player, CreationOptions<EnderChestSlot> options) {
        UUID uuid = player.getUniqueId();
        String name = player.getName();
        CraftInventory craftInventory = (CraftInventory)player.getEnderChest();
        InventoryEnderChest nmsInventory = (InventoryEnderChest)craftInventory.getInventory();
        EnderNmsInventory spectatorInv = new EnderNmsInventory(uuid, name, (NonNullList<net.minecraft.world.item.ItemStack>)nmsInventory.c, options);
        EnderBukkitInventory bukkitInventory = (EnderBukkitInventory)spectatorInv.bukkit();
        this.cache.cache(bukkitInventory);
        return bukkitInventory;
    }

    @Override
    public CompletableFuture<SpectateResponse<EnderSpectatorInventory>> createOfflineEnderChest(UUID playerId, String playerName, CreationOptions<EnderChestSlot> options) {
        return this.createOffline(playerId, playerName, options, this::spectateEnderChest);
    }

    @Override
    public CompletableFuture<SaveResponse> saveEnderChest(EnderSpectatorInventory newInventory) {
        return this.save(newInventory, this::spectateEnderChest, EnderSpectatorInventory::setContents);
    }

    private <Slot, IS extends SpectatorInventory<Slot>> CompletableFuture<SpectateResponse<IS>> createOffline(UUID player, String name, CreationOptions<Slot> options, BiFunction<? super HumanEntity, ? super CreationOptions<Slot>, IS> invCreator) {
        CraftServer server = (CraftServer)this.plugin.getServer();
        DedicatedPlayerList playerList = server.getHandle();
        WorldNBTStorage worldNBTStorage = playerList.r;
        CraftWorld world = (CraftWorld)server.getWorlds().get(0);
        Location spawn = world.getSpawnLocation();
        float yaw = 0.0f;
        GameProfile gameProfile = new GameProfile(player, name);
        FakeEntityHuman fakeEntityHuman = new FakeEntityHuman((World)world.getHandle(), new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), yaw, gameProfile);
        return CompletableFuture.supplyAsync(() -> {
            NBTTagCompound playerCompound = worldNBTStorage.load((EntityHuman)fakeEntityHuman);
            if (playerCompound == null) {
                if (!options.isUnknownPlayerSupported()) {
                    return SpectateResponse.fail(NotCreatedReason.unknownTarget(Target.byGameProfile(player, name)));
                }
            } else {
                fakeEntityHuman.loadData(playerCompound);
            }
            CraftHumanEntity craftHumanEntity = new CraftHumanEntity(server, (EntityHuman)fakeEntityHuman);
            return SpectateResponse.succeed(EventHelper.callSpectatorInventoryOfflineCreatedEvent((Server)server, (SpectatorInventory)invCreator.apply((HumanEntity)craftHumanEntity, (Object)options)));
        }, runnable -> this.scheduler.executeSyncPlayer(player, runnable, null));
    }

    private <Slot, SI extends SpectatorInventory<Slot>> CompletableFuture<SaveResponse> save(SI newInventory, BiFunction<? super HumanEntity, ? super CreationOptions<Slot>, SI> currentInvProvider, BiConsumer<SI, SI> transfer) {
        CraftServer server = (CraftServer)this.plugin.getServer();
        SpectatorInventorySaveEvent event = EventHelper.callSpectatorInventorySaveEvent((Server)server, newInventory);
        if (event.isCancelled()) {
            return CompletableFuture.completedFuture(SaveResponse.notSaved(newInventory));
        }
        DedicatedPlayerList playerList = server.getHandle();
        WorldNBTStorage worldNBTStorage = playerList.r;
        CraftWorld world = (CraftWorld)server.getWorlds().get(0);
        UUID playerId = newInventory.getSpectatedPlayerId();
        GameProfile gameProfile = new GameProfile(playerId, newInventory.getSpectatedPlayerName());
        FakeEntityPlayer fakeEntityPlayer = new FakeEntityPlayer((MinecraftServer)server.getServer(), world.getHandle(), gameProfile);
        return CompletableFuture.supplyAsync(() -> {
            NBTTagCompound playerCompound = worldNBTStorage.load((EntityHuman)fakeEntityPlayer);
            if (playerCompound != null) {
                fakeEntityPlayer.load(playerCompound);
            }
            FakeCraftPlayer craftHumanEntity = fakeEntityPlayer.getBukkitEntity();
            CreationOptions creationOptions = newInventory.getCreationOptions();
            SpectatorInventory currentInv = (SpectatorInventory)currentInvProvider.apply((HumanEntity)craftHumanEntity, (Object)creationOptions);
            transfer.accept(currentInv, newInventory);
            worldNBTStorage.save((EntityHuman)fakeEntityPlayer);
            return SaveResponse.saved(currentInv);
        }, runnable -> this.scheduler.executeSyncPlayer(playerId, runnable, null));
    }

    public static Optional<InventoryOpenEvent> callInventoryOpenEvent(EntityPlayer player, Container container) {
        if (player.bV != player.bU) {
            player.b.a(new PacketPlayInCloseWindow(player.bV.j));
        }
        CraftServer server = player.t.getCraftServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.bV.transferTo(container, (CraftHumanEntity)craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            container.transferTo(player.bV, (CraftHumanEntity)craftPlayer);
            return Optional.of(event);
        }
        return Optional.empty();
    }

    @Override
    public PlaceholderPalette getPlaceholderPalette(String name) {
        return switch (name) {
            case "glass panes" -> Placeholders.PALETTE_GLASS;
            case "icons" -> Placeholders.PALETTE_ICONS;
            default -> PlaceholderPalette.empty();
        };
    }

    static void sendItemChange(EntityPlayer entityPlayer, int rawIndex, net.minecraft.world.item.ItemStack toSend) {
        Container container = entityPlayer.bV;
        entityPlayer.b.sendPacket((Packet)new PacketPlayOutSetSlot(container.j, container.incrementStateId(), rawIndex, toSend));
    }

    static net.minecraft.world.item.ItemStack getItemOrPlaceholder(PlaceholderPalette palette, MainBukkitInventoryView view, int rawIndex, PlaceholderGroup group) {
        Slot slot = view.nms.getSlot(rawIndex);
        if (slot.hasItem()) {
            return slot.getItem();
        }
        if (slot instanceof InaccessibleSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
        }
        if (slot instanceof BootsSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourBoots());
        }
        if (slot instanceof LeggingsSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourLeggings());
        }
        if (slot instanceof ChestplateSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourChestplate());
        }
        if (slot instanceof HelmetSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.armourLeggings());
        }
        if (slot instanceof OffhandSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.offHand());
        }
        if (slot instanceof CursorSlot) {
            return CraftItemStack.asNMSCopy((ItemStack)palette.cursor());
        }
        if (slot instanceof PersonalSlot) {
            PersonalSlot personalSlot = (PersonalSlot)slot;
            if (!personalSlot.works()) {
                return CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
            }
            if (group == null) {
                return net.minecraft.world.item.ItemStack.b;
            }
            Mirror<PlayerInventorySlot> mirror = view.nms.creationOptions.getMirror();
            PlayerInventorySlot pis = mirror.getSlot(rawIndex);
            if (pis == null) {
                return CraftItemStack.asNMSCopy((ItemStack)palette.inaccessible());
            }
            return CraftItemStack.asNMSCopy((ItemStack)palette.getPersonalSlotPlaceholder(pis, group));
        }
        return net.minecraft.world.item.ItemStack.b;
    }
}

