/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_17_1_R1;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.EnderBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_17_1_R1.EnderNmsContainer;
import com.janboerman.invsee.spigot.internal.inventory.AbstractNmsInventory;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;

class EnderNmsInventory
extends AbstractNmsInventory<EnderChestSlot, EnderBukkitInventory, EnderNmsInventory>
implements IInventory,
ITileInventory {
    protected NonNullList<ItemStack> storageContents;

    EnderNmsInventory(UUID targetPlayerUuid, String targetPlayerName, NonNullList<ItemStack> storageContents, CreationOptions<EnderChestSlot> creationOptions) {
        super(targetPlayerUuid, targetPlayerName, creationOptions);
        this.storageContents = storageContents;
    }

    @Override
    protected EnderBukkitInventory createBukkit() {
        return new EnderBukkitInventory(this);
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(EnderNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.update();
    }

    public Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman player) {
        return new EnderNmsContainer(containerId, this, playerInventory, player, this.creationOptions);
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromStringOrNull((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName)));
    }

    public void clear() {
        this.storageContents.clear();
    }

    public int getSize() {
        return this.storageContents.size();
    }

    public List<ItemStack> getContents() {
        return this.storageContents;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return ItemStack.b;
        }
        return (ItemStack)this.storageContents.get(slot);
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.storageContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void onClose(CraftHumanEntity bukkitPlayer) {
        super.onClose((HumanEntity)bukkitPlayer);
    }

    public void onOpen(CraftHumanEntity bukkitPlayer) {
        super.onOpen((HumanEntity)bukkitPlayer);
    }

    public ItemStack splitStack(int slot, int amount) {
        if (slot < 0 || slot >= this.getSize()) {
            return ItemStack.b;
        }
        ItemStack stack = ContainerUtil.a(this.storageContents, (int)slot, (int)amount);
        if (!stack.isEmpty()) {
            this.update();
        }
        return stack;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return ItemStack.b;
        }
        ItemStack stack = (ItemStack)this.storageContents.get(slot);
        if (stack.isEmpty()) {
            return ItemStack.b;
        }
        this.storageContents.set(slot, (Object)ItemStack.b);
        return stack;
    }

    public void update() {
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.getSize()) {
            return;
        }
        this.storageContents.set(slot, (Object)itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public boolean a(EntityHuman player) {
        return true;
    }
}

