/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_16_R3;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_16_R3.InvseeImpl;
import com.janboerman.invsee.spigot.impl_1_16_R3.MainBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_16_R3.MainNmsContainer;
import com.janboerman.invsee.spigot.internal.inventory.ShallowCopy;
import com.janboerman.invsee.utils.ConcatList;
import com.janboerman.invsee.utils.Ref;
import com.janboerman.invsee.utils.SingletonList;
import com.janboerman.invsee.utils.UUIDHelper;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.NonNullList;
import net.minecraft.server.v1_16_R3.PlayerInventory;
import net.minecraft.server.v1_16_R3.TileEntityContainer;
import net.minecraft.server.v1_16_R3.TileEntityTypes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class MainNmsInventory
extends TileEntityContainer
implements ShallowCopy<MainNmsInventory> {
    private static final TileEntityTypes TileEntityTypeFakePlayerInventory = new TileEntityTypes(MainNmsInventory::new, Set.of(), (Type)new EmptyPart());
    protected final UUID spectatedPlayerUuid;
    protected final String spectatedPlayerName;
    protected NonNullList<ItemStack> storageContents;
    protected NonNullList<ItemStack> armourContents;
    protected NonNullList<ItemStack> offHand;
    protected Ref<ItemStack> onCursor;
    protected List<ItemStack> playerCraftingContents;
    protected List<ItemStack> personalContents;
    private MainBukkitInventory bukkit;
    protected CreationOptions<PlayerInventorySlot> creationOptions;
    private int maxStack = 64;
    private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    protected InventoryHolder owner;

    private MainNmsInventory() {
        super(TileEntityTypeFakePlayerInventory);
        this.spectatedPlayerUuid = null;
        this.spectatedPlayerName = null;
    }

    protected MainNmsInventory(EntityHuman target, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(TileEntityTypeFakePlayerInventory);
        this.spectatedPlayerUuid = UUIDHelper.copy(target.getUniqueID());
        this.spectatedPlayerName = target.getName();
        final PlayerInventory inv = target.inventory;
        this.storageContents = inv.items;
        this.armourContents = inv.armor;
        this.offHand = inv.extraSlots;
        this.onCursor = new Ref<ItemStack>(this){
            final /* synthetic */ MainNmsInventory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void set(ItemStack item) {
                inv.setCarried(item);
            }

            @Override
            public ItemStack get() {
                return inv.getCarried();
            }
        };
        this.personalContents = this.playerCraftingContents = target.defaultContainer.j().getContents();
        this.creationOptions = creationOptions;
    }

    public MainBukkitInventory bukkit() {
        return this.bukkit == null ? (this.bukkit = new MainBukkitInventory(this)) : this.bukkit;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(MainNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.armourContents = from.armourContents;
        this.offHand = from.offHand;
        this.onCursor = from.onCursor;
        this.playerCraftingContents = from.playerCraftingContents;
        this.personalContents = from.personalContents;
        this.update();
    }

    private Ref<ItemStack> decideWhichItem(int slot) {
        int idx;
        int storageSize = this.storageContents.size();
        if (0 <= slot && slot < storageSize) {
            int idx2 = slot;
            return Ref.ofList(idx2, this.storageContents);
        }
        int armourSize = this.armourContents.size();
        if (storageSize <= slot && slot < storageSize + armourSize) {
            int idx3 = slot - storageSize;
            return Ref.ofList(idx3, this.armourContents);
        }
        int offhandSize = this.offHand.size();
        if (storageSize + armourSize <= slot && slot < storageSize + armourSize + offhandSize) {
            int idx4 = slot - storageSize - armourSize;
            return Ref.ofList(idx4, this.offHand);
        }
        if (storageSize + armourSize + offhandSize == slot) {
            return this.onCursor;
        }
        if (45 <= slot && slot < 54 && (idx = slot - 45) < this.personalContents.size()) {
            return Ref.ofList(idx, this.personalContents);
        }
        return null;
    }

    public int getSize() {
        return 54;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.armourContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.storageContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.offHand) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.personalContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return this.onCursor.get().isEmpty();
    }

    public ItemStack getItem(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        return ref.get();
    }

    public ItemStack splitStack(int slot, int subtractAmount) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ref.get();
        if (!stack.isEmpty() && subtractAmount > 0) {
            ItemStack oldStackCopy = ref.get().cloneAndSubtract(subtractAmount);
            if (!oldStackCopy.isEmpty()) {
                this.update();
            }
            return oldStackCopy;
        }
        return InvseeImpl.EMPTY_STACK;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ref.get();
        if (stack.isEmpty()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ref.set(InvseeImpl.EMPTY_STACK);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return;
        }
        ref.set(itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public void update() {
        for (HumanEntity viewer : this.getViewers()) {
            if (!(viewer instanceof Player)) continue;
            ((Player)viewer).updateInventory();
        }
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public List<ItemStack> getContents() {
        NonNullList paddingOne = NonNullList.a((int)(45 - this.storageContents.size() - this.armourContents.size() - this.offHand.size() - 1), (Object)InvseeImpl.EMPTY_STACK);
        NonNullList paddingTwo = NonNullList.a((int)(9 - this.personalContents.size()), (Object)InvseeImpl.EMPTY_STACK);
        return new ConcatList<ItemStack>((List<ItemStack>)this.storageContents, (List<ItemStack>)new ConcatList<ItemStack>((List<ItemStack>)this.armourContents, (List<ItemStack>)new ConcatList<ItemStack>((List<ItemStack>)this.offHand, (List<ItemStack>)new ConcatList<ItemStack>(new SingletonList<ItemStack>(this.onCursor), new ConcatList<ItemStack>((List<ItemStack>)paddingOne, (List<ItemStack>)new ConcatList<ItemStack>(this.personalContents, (List<ItemStack>)paddingTwo))))));
    }

    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public InventoryHolder getOwner() {
        return this.owner;
    }

    public void setMaxStackSize(int maxStack) {
        this.maxStack = maxStack;
    }

    public Location getLocation() {
        return null;
    }

    public void clear() {
        this.storageContents.clear();
        this.armourContents.clear();
        this.offHand.clear();
        this.onCursor.set(InvseeImpl.EMPTY_STACK);
        this.playerCraftingContents.clear();
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromStringOrNull((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.spectatedPlayerUuid, this.spectatedPlayerName)));
    }

    protected IChatBaseComponent getContainerName() {
        return new ChatMessage("minecraft:generic_9x6");
    }

    protected Container createContainer(int containerId, PlayerInventory playerInventory) {
        return new MainNmsContainer(containerId, this, playerInventory, playerInventory.player, this.creationOptions);
    }

    public boolean e(EntityHuman entityhuman) {
        return true;
    }

    public boolean func_191420_l() {
        return this.isEmpty();
    }

    public ItemStack func_70301_a(int idx) {
        return this.getItem(idx);
    }

    public int func_70302_i_() {
        return this.getSize();
    }

    public ItemStack func_70298_a(int slot, int subtractAmount) {
        return this.splitStack(slot, subtractAmount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.splitWithoutUpdate(slot);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.setItem(slot, itemStack);
    }

    public int func_70297_j_() {
        return this.getMaxStackSize();
    }

    public void func_70296_d() {
        this.update();
    }

    public boolean func_70300_a(EntityHuman playerEntity) {
        return this.a(playerEntity);
    }
}

