/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_16_R3;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.impl_1_16_R3.EnderBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_16_R3.EnderNmsInventory;
import com.janboerman.invsee.spigot.impl_1_16_R3.InaccessiblePlaceholderSlot;
import com.janboerman.invsee.spigot.impl_1_16_R3.InvseeImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.Containers;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.ICrafting;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.InventoryClickType;
import net.minecraft.server.v1_16_R3.PlayerInventory;
import net.minecraft.server.v1_16_R3.Slot;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class EnderNmsContainer
extends Container {
    final EntityHuman player;
    final EnderNmsInventory top;
    final IInventory bottom;
    final String title;
    final CreationOptions<EnderChestSlot> creationOptions;
    private final int topRows;
    private EnderBukkitInventoryView bukkitView;
    final DifferenceTracker tracker;

    private static Containers determineContainerType(EnderNmsInventory inv) {
        switch (inv.getSize()) {
            case 9: {
                return Containers.GENERIC_9X1;
            }
            case 18: {
                return Containers.GENERIC_9X2;
            }
            case 27: {
                return Containers.GENERIC_9X3;
            }
            case 36: {
                return Containers.GENERIC_9X4;
            }
            case 45: {
                return Containers.GENERIC_9X5;
            }
            case 54: {
                return Containers.GENERIC_9X6;
            }
        }
        return Containers.GENERIC_9X3;
    }

    private static Slot makeSlot(Mirror<EnderChestSlot> mirror, EnderNmsInventory top, int positionIndex, int magicX, int magicY, net.minecraft.server.v1_16_R3.ItemStack inaccessiblePlaceholder) {
        EnderChestSlot place = mirror.getSlot(positionIndex);
        if (place == null) {
            return new InaccessiblePlaceholderSlot(inaccessiblePlaceholder, (IInventory)top, positionIndex, magicX, magicY);
        }
        int referringTo = place.ordinal();
        return new Slot((IInventory)top, referringTo, magicX, magicY);
    }

    public net.minecraft.server.v1_16_R3.ItemStack a(int i, int j, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        List<ItemStack> contentsBefore = null;
        if (this.tracker != null) {
            contentsBefore = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        net.minecraft.server.v1_16_R3.ItemStack result = super.a(i, j, inventoryclicktype, entityhuman);
        if (this.tracker != null) {
            List<ItemStack> contentsAfter = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
            this.tracker.onClick(contentsBefore, contentsAfter);
        }
        return result;
    }

    public void b(EntityHuman entityhuman) {
        super.b(entityhuman);
        if (this.tracker != null && Objects.equals(entityhuman, this.player)) {
            this.tracker.onClose();
        }
    }

    EnderNmsContainer(int containerId, EnderNmsInventory nmsInventory, PlayerInventory playerInventory, EntityHuman player, CreationOptions<EnderChestSlot> creationOptions) {
        super(EnderNmsContainer.determineContainerType(nmsInventory), containerId);
        int magicY;
        int magicX;
        int index;
        int xPos;
        this.topRows = nmsInventory.getSize() / 9;
        this.player = player;
        this.top = nmsInventory;
        this.bottom = playerInventory;
        this.creationOptions = creationOptions;
        this.title = creationOptions.getTitle().titleFor(Target.byGameProfile(nmsInventory.spectatedPlayerUuid, nmsInventory.spectatedPlayerName));
        Mirror<EnderChestSlot> mirror = creationOptions.getMirror();
        LogOptions logOptions = creationOptions.getLogOptions();
        Plugin plugin = creationOptions.getPlugin();
        if (!LogOptions.isEmpty(logOptions)) {
            this.tracker = new DifferenceTracker(LogOutput.make(plugin, player.getUniqueID(), player.getName(), Target.byGameProfile(nmsInventory.spectatedPlayerUuid, nmsInventory.spectatedPlayerName), logOptions), logOptions.getGranularity());
            this.tracker.onOpen();
        } else {
            this.tracker = null;
        }
        for (int yPos = 0; yPos < this.topRows; ++yPos) {
            for (xPos = 0; xPos < 9; ++xPos) {
                index = xPos + yPos * 9;
                magicX = 8 + xPos * 18;
                magicY = 18 + yPos * 18;
                super.a(EnderNmsContainer.makeSlot(mirror, this.top, index, magicX, magicY, CraftItemStack.asNMSCopy((ItemStack)creationOptions.getPlaceholderPalette().inaccessible())));
            }
        }
        int magicAddY = (this.topRows - 4) * 18;
        for (int yPos = 1; yPos < 4; ++yPos) {
            for (int xPos2 = 0; xPos2 < 9; ++xPos2) {
                int index2 = xPos2 + yPos * 9;
                int magicX2 = 8 + xPos2 * 18;
                int magicY2 = 103 + yPos * 18 + magicAddY;
                super.a(new Slot((IInventory)playerInventory, index2, magicX2, magicY2));
            }
        }
        for (xPos = 0; xPos < 9; ++xPos) {
            index = xPos;
            magicX = 8 + xPos * 18;
            magicY = 161 + magicAddY;
            super.a(new Slot((IInventory)playerInventory, index, magicX, magicY));
        }
    }

    public EnderBukkitInventoryView getBukkitView() {
        if (this.bukkitView == null) {
            this.bukkitView = new EnderBukkitInventoryView(this);
        }
        return this.bukkitView;
    }

    public boolean canUse(EntityHuman entityHuman) {
        return true;
    }

    public net.minecraft.server.v1_16_R3.ItemStack shiftClick(EntityHuman entityhuman, int rawIndex) {
        List slots = this.slots;
        net.minecraft.server.v1_16_R3.ItemStack itemstack = InvseeImpl.EMPTY_STACK;
        Slot slot = (Slot)slots.get(rawIndex);
        if (slot != null && slot.hasItem()) {
            net.minecraft.server.v1_16_R3.ItemStack clickedSlotItem = slot.getItem();
            itemstack = clickedSlotItem.cloneItemStack();
            if (rawIndex < this.topRows * 9 ? !this.doShiftClickTransfer(clickedSlotItem, this.topRows * 9, slots.size(), true) : !this.doShiftClickTransfer(clickedSlotItem, 0, this.topRows * 9, false)) {
                return InvseeImpl.EMPTY_STACK;
            }
            if (clickedSlotItem.isEmpty()) {
                slot.set(InvseeImpl.EMPTY_STACK);
            } else {
                slot.d();
            }
        }
        return itemstack;
    }

    private boolean doShiftClickTransfer(net.minecraft.server.v1_16_R3.ItemStack clickedSlotItem, int targetMinIndex, int targetMaxIndex, boolean topClicked) {
        return super.a(clickedSlotItem, targetMinIndex, targetMaxIndex, topClicked);
    }

    public Containers<?> getType() {
        return super.getType();
    }

    public Slot getSlot(int rawIndex) {
        return super.getSlot(rawIndex);
    }

    public void addSlotListener(ICrafting icrafting) {
        super.addSlotListener(icrafting);
    }

    public boolean func_75145_c(EntityHuman playerEntity) {
        return this.canUse(playerEntity);
    }

    public net.minecraft.server.v1_16_R3.ItemStack func_184996_a(int a2, int b, InventoryClickType clickType, EntityHuman playerEntity) {
        return this.a(a2, b, clickType, playerEntity);
    }

    public void func_75134_a(EntityHuman playerEntity) {
        this.b(playerEntity);
    }

    public net.minecraft.server.v1_16_R3.ItemStack func_82846_b(EntityHuman playerEntity, int rawIndex) {
        return this.shiftClick(playerEntity, rawIndex);
    }
}

