/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_12_R1;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.PlayerInventorySlot;
import com.janboerman.invsee.spigot.impl_1_12_R1.InvseeImpl;
import com.janboerman.invsee.spigot.impl_1_12_R1.MainBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_12_R1.MainNmsContainer;
import com.janboerman.invsee.spigot.internal.inventory.AbstractNmsInventory;
import com.janboerman.invsee.utils.ConcatList;
import com.janboerman.invsee.utils.Ref;
import com.janboerman.invsee.utils.SingletonList;
import java.util.List;
import net.minecraft.server.v1_12_R1.Container;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.ITileEntityContainer;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.NonNullList;
import net.minecraft.server.v1_12_R1.PlayerInventory;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;

class MainNmsInventory
extends AbstractNmsInventory<PlayerInventorySlot, MainBukkitInventory, MainNmsInventory>
implements IInventory,
ITileEntityContainer {
    protected NonNullList<ItemStack> storageContents;
    protected NonNullList<ItemStack> armourContents;
    protected NonNullList<ItemStack> offHand;
    protected Ref<ItemStack> onCursor;
    protected List<ItemStack> playerCraftingContents;
    protected List<ItemStack> personalContents;

    MainNmsInventory(EntityHuman target, CreationOptions<PlayerInventorySlot> creationOptions) {
        super(target.getUniqueID(), target.getName(), creationOptions);
        final PlayerInventory inv = target.inventory;
        this.storageContents = inv.items;
        this.armourContents = inv.armor;
        this.offHand = inv.extraSlots;
        this.onCursor = new Ref<ItemStack>(){
            final /* synthetic */ MainNmsInventory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void set(ItemStack item) {
                inv.setCarried(item);
            }

            @Override
            public ItemStack get() {
                return inv.getCarried();
            }
        };
        IInventory playerCrafting = ((CraftInventory)target.defaultContainer.getBukkitView().getTopInventory()).getInventory();
        this.personalContents = this.playerCraftingContents = playerCrafting.getContents();
    }

    @Override
    protected MainBukkitInventory createBukkit() {
        return new MainBukkitInventory(this);
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(MainNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.armourContents = from.armourContents;
        this.offHand = from.offHand;
        this.onCursor = from.onCursor;
        this.playerCraftingContents = from.playerCraftingContents;
        this.personalContents = from.personalContents;
        this.update();
    }

    private Ref<ItemStack> decideWhichItem(int slot) {
        int idx;
        int storageSize = this.storageContents.size();
        if (0 <= slot && slot < storageSize) {
            int idx2 = slot;
            return Ref.ofList(idx2, this.storageContents);
        }
        int armourSize = this.armourContents.size();
        if (storageSize <= slot && slot < storageSize + armourSize) {
            int idx3 = slot - storageSize;
            return Ref.ofList(idx3, this.armourContents);
        }
        int offhandSize = this.offHand.size();
        if (storageSize + armourSize <= slot && slot < storageSize + armourSize + offhandSize) {
            int idx4 = slot - storageSize - armourSize;
            return Ref.ofList(idx4, this.offHand);
        }
        if (storageSize + armourSize + offhandSize == slot) {
            return this.onCursor;
        }
        if (45 <= slot && slot < 54 && (idx = slot - 45) < this.personalContents.size()) {
            return Ref.ofList(idx, this.personalContents);
        }
        return null;
    }

    public int getSize() {
        return 54;
    }

    public boolean x_() {
        for (ItemStack stack : this.armourContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.storageContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.offHand) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (ItemStack stack : this.personalContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return this.onCursor.get().isEmpty();
    }

    public ItemStack getItem(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        return ref.get();
    }

    public ItemStack splitStack(int slot, int subtractAmount) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ref.get();
        if (!stack.isEmpty() && subtractAmount > 0) {
            ItemStack oldStackCopy = ref.get().cloneAndSubtract(subtractAmount);
            if (!oldStackCopy.isEmpty()) {
                this.update();
            }
            return oldStackCopy;
        }
        return InvseeImpl.EMPTY_STACK;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ref.get();
        if (stack.isEmpty()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ref.set(InvseeImpl.EMPTY_STACK);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        Ref<ItemStack> ref = this.decideWhichItem(slot);
        if (ref == null) {
            return;
        }
        ref.set(itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public void update() {
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public void startOpen(EntityHuman entityHuman) {
        this.onOpen(entityHuman.getBukkitEntity());
    }

    public void closeContainer(EntityHuman entityHuman) {
        this.onClose(entityHuman.getBukkitEntity());
    }

    public boolean b(int slot, ItemStack itemStack) {
        return true;
    }

    public int getProperty(int idx) {
        return 0;
    }

    public void setProperty(int idx, int value) {
    }

    public int h() {
        return 0;
    }

    public List<ItemStack> getContents() {
        NonNullList paddingOne = NonNullList.a((int)(45 - this.storageContents.size() - this.armourContents.size() - this.offHand.size() - 1), (Object)InvseeImpl.EMPTY_STACK);
        NonNullList paddingTwo = NonNullList.a((int)(9 - this.personalContents.size()), (Object)InvseeImpl.EMPTY_STACK);
        return new ConcatList<ItemStack>((List<ItemStack>)this.storageContents, (List<ItemStack>)new ConcatList<ItemStack>((List<ItemStack>)this.armourContents, (List<ItemStack>)new ConcatList<ItemStack>((List<ItemStack>)this.offHand, (List<ItemStack>)new ConcatList<ItemStack>(new SingletonList<ItemStack>(this.onCursor), new ConcatList<ItemStack>((List<ItemStack>)paddingOne, (List<ItemStack>)new ConcatList<ItemStack>(this.personalContents, (List<ItemStack>)paddingTwo))))));
    }

    public void onOpen(CraftHumanEntity who) {
        super.onOpen((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        super.onClose((HumanEntity)who);
    }

    public void clear() {
        this.storageContents.clear();
        this.armourContents.clear();
        this.offHand.clear();
        this.onCursor.set(InvseeImpl.EMPTY_STACK);
        this.personalContents.clear();
        if (this.personalContents != this.playerCraftingContents) {
            this.playerCraftingContents.clear();
        }
    }

    public Container createContainer(PlayerInventory playerInventory, EntityHuman entityHuman) {
        EntityPlayer entityPlayer = (EntityPlayer)entityHuman;
        return new MainNmsContainer(entityPlayer.nextContainerCounter(), this, playerInventory, entityHuman, this.creationOptions);
    }

    public String getContainerName() {
        return "minecraft:container";
    }

    public String getName() {
        return this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName));
    }

    public boolean hasCustomName() {
        return this.creationOptions.getTitle() != null;
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromString((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName)))[0];
    }
}

