/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_12_R1;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.impl_1_12_R1.EnderBukkitInventory;
import com.janboerman.invsee.spigot.impl_1_12_R1.EnderNmsContainer;
import com.janboerman.invsee.spigot.impl_1_12_R1.InvseeImpl;
import com.janboerman.invsee.spigot.internal.inventory.AbstractNmsInventory;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_12_R1.Container;
import net.minecraft.server.v1_12_R1.ContainerUtil;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.ITileEntityContainer;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.NonNullList;
import net.minecraft.server.v1_12_R1.PlayerInventory;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;

class EnderNmsInventory
extends AbstractNmsInventory<EnderChestSlot, EnderBukkitInventory, EnderNmsInventory>
implements IInventory,
ITileEntityContainer {
    protected NonNullList<ItemStack> storageContents;

    EnderNmsInventory(UUID spectatedPlayerUuid, String spectatedPlayerName, NonNullList<ItemStack> storageContents, CreationOptions<EnderChestSlot> creationOptions) {
        super(spectatedPlayerUuid, spectatedPlayerName, creationOptions);
        this.storageContents = storageContents;
    }

    @Override
    protected EnderBukkitInventory createBukkit() {
        return new EnderBukkitInventory(this);
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public int defaultMaxStack() {
        return 64;
    }

    @Override
    public void shallowCopyFrom(EnderNmsInventory from) {
        this.setMaxStackSize(from.getMaxStackSize());
        this.storageContents = from.storageContents;
        this.update();
    }

    public int getSize() {
        return this.storageContents.size();
    }

    public boolean x_() {
        for (ItemStack stack : this.storageContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        return (ItemStack)this.storageContents.get(slot);
    }

    public ItemStack splitStack(int slot, int subtractAmount) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = ContainerUtil.a(this.storageContents, (int)slot, (int)subtractAmount);
        if (!stack.isEmpty()) {
            this.update();
        }
        return stack;
    }

    public ItemStack splitWithoutUpdate(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            return InvseeImpl.EMPTY_STACK;
        }
        ItemStack stack = (ItemStack)this.storageContents.get(slot);
        if (stack.isEmpty()) {
            return InvseeImpl.EMPTY_STACK;
        }
        this.storageContents.set(slot, (Object)InvseeImpl.EMPTY_STACK);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.getSize()) {
            return;
        }
        this.storageContents.set(slot, (Object)itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.update();
    }

    public void update() {
    }

    public boolean a(EntityHuman entityHuman) {
        return true;
    }

    public void startOpen(EntityHuman entityHuman) {
        this.onOpen(entityHuman.getBukkitEntity());
    }

    public void closeContainer(EntityHuman entityHuman) {
        this.onClose(entityHuman.getBukkitEntity());
    }

    public boolean b(int slot, ItemStack itemStack) {
        return true;
    }

    public int getProperty(int idx) {
        return 0;
    }

    public void setProperty(int idx, int prop) {
    }

    public int h() {
        return 0;
    }

    public List<ItemStack> getContents() {
        return this.storageContents;
    }

    public void onOpen(CraftHumanEntity who) {
        super.onOpen((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        super.onClose((HumanEntity)who);
    }

    public void clear() {
        this.storageContents.clear();
    }

    public String getName() {
        return this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName));
    }

    public boolean hasCustomName() {
        return this.creationOptions.getTitle() != null;
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromString((String)this.creationOptions.getTitle().titleFor(Target.byGameProfile(this.targetPlayerUuid, this.targetPlayerName)))[0];
    }

    public Container createContainer(PlayerInventory playerInventory, EntityHuman entityHuman) {
        EntityPlayer entityPlayer = (EntityPlayer)entityHuman;
        return new EnderNmsContainer(entityPlayer.nextContainerCounter(), this, playerInventory, playerInventory.player, this.creationOptions);
    }

    public String getContainerName() {
        return "minecraft:container";
    }
}

