/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.impl_1_12_R1;

import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.logging.DifferenceTracker;
import com.janboerman.invsee.spigot.api.logging.LogOptions;
import com.janboerman.invsee.spigot.api.logging.LogOutput;
import com.janboerman.invsee.spigot.api.target.Target;
import com.janboerman.invsee.spigot.api.template.EnderChestSlot;
import com.janboerman.invsee.spigot.api.template.Mirror;
import com.janboerman.invsee.spigot.impl_1_12_R1.EnderBukkitInventoryView;
import com.janboerman.invsee.spigot.impl_1_12_R1.EnderNmsInventory;
import com.janboerman.invsee.spigot.impl_1_12_R1.InaccessiblePlaceholderSlot;
import com.janboerman.invsee.spigot.impl_1_12_R1.InvseeImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.server.v1_12_R1.Container;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.InventoryClickType;
import net.minecraft.server.v1_12_R1.PlayerInventory;
import net.minecraft.server.v1_12_R1.Slot;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EnderNmsContainer
extends Container {
    final EntityHuman player;
    final EnderNmsInventory top;
    final IInventory bottom;
    final String title;
    final CreationOptions<EnderChestSlot> creationOptions;
    private final int topRows;
    private EnderBukkitInventoryView bukkitView;
    final DifferenceTracker tracker;

    private static Slot makeSlot(Mirror<EnderChestSlot> mirror, EnderNmsInventory top, int positionIndex, int magicX, int magicY, net.minecraft.server.v1_12_R1.ItemStack inaccessiblePlaceholder) {
        EnderChestSlot place = mirror.getSlot(positionIndex);
        if (place == null) {
            return new InaccessiblePlaceholderSlot(inaccessiblePlaceholder, top, positionIndex, magicX, magicY);
        }
        int referringTo = place.ordinal();
        return new Slot((IInventory)top, referringTo, magicX, magicY);
    }

    public net.minecraft.server.v1_12_R1.ItemStack a(int i, int j, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        List<ItemStack> contentsBefore = null;
        if (this.tracker != null) {
            contentsBefore = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        net.minecraft.server.v1_12_R1.ItemStack result = super.a(i, j, inventoryclicktype, entityhuman);
        if (this.tracker != null) {
            List<ItemStack> contentsAfter = this.top.getContents().stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
            this.tracker.onClick(contentsBefore, contentsAfter);
        }
        return result;
    }

    public void b(EntityHuman entityhuman) {
        super.b(entityhuman);
        if (this.tracker != null && Objects.equals(entityhuman, this.player)) {
            this.tracker.onClose();
        }
    }

    EnderNmsContainer(int containerId, EnderNmsInventory nmsInventory, PlayerInventory playerInventory, EntityHuman player, CreationOptions<EnderChestSlot> creationOptions) {
        int magicY;
        int magicX;
        int index;
        int xPos;
        this.windowId = containerId;
        this.topRows = nmsInventory.getSize() / 9;
        this.player = player;
        this.top = nmsInventory;
        this.bottom = playerInventory;
        nmsInventory.startOpen(player);
        this.creationOptions = creationOptions;
        this.title = creationOptions.getTitle().titleFor(Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName));
        Mirror<EnderChestSlot> mirror = creationOptions.getMirror();
        LogOptions logOptions = creationOptions.getLogOptions();
        Plugin plugin = creationOptions.getPlugin();
        if (!LogOptions.isEmpty(logOptions)) {
            this.tracker = new DifferenceTracker(LogOutput.make(plugin, player.getUniqueID(), player.getName(), Target.byGameProfile(nmsInventory.targetPlayerUuid, nmsInventory.targetPlayerName), logOptions), logOptions.getGranularity());
            this.tracker.onOpen();
        } else {
            this.tracker = null;
        }
        for (int yPos = 0; yPos < this.topRows; ++yPos) {
            for (xPos = 0; xPos < 9; ++xPos) {
                index = xPos + yPos * 9;
                magicX = 8 + xPos * 18;
                magicY = 18 + yPos * 18;
                this.a(EnderNmsContainer.makeSlot(mirror, this.top, index, magicX, magicY, CraftItemStack.asNMSCopy((ItemStack)creationOptions.getPlaceholderPalette().inaccessible())));
            }
        }
        int magicAddY = (this.topRows - 4) * 18;
        for (int yPos = 1; yPos < 4; ++yPos) {
            for (int xPos2 = 0; xPos2 < 9; ++xPos2) {
                int index2 = xPos2 + yPos * 9;
                int magicX2 = 8 + xPos2 * 18;
                int magicY2 = 103 + yPos * 18 + magicAddY;
                this.a(new Slot((IInventory)playerInventory, index2, magicX2, magicY2));
            }
        }
        for (xPos = 0; xPos < 9; ++xPos) {
            index = xPos;
            magicX = 8 + xPos * 18;
            magicY = 161 + magicAddY;
            this.a(new Slot((IInventory)playerInventory, index, magicX, magicY));
        }
    }

    public EnderBukkitInventoryView getBukkitView() {
        if (this.bukkitView == null) {
            this.bukkitView = new EnderBukkitInventoryView(this);
        }
        return this.bukkitView;
    }

    public boolean canUse(EntityHuman entityHuman) {
        return true;
    }

    public net.minecraft.server.v1_12_R1.ItemStack shiftClick(EntityHuman entityhuman, int rawIndex) {
        net.minecraft.server.v1_12_R1.ItemStack itemstack = InvseeImpl.EMPTY_STACK;
        Slot slot = (Slot)this.slots.get(rawIndex);
        if (slot != null && slot.hasItem()) {
            net.minecraft.server.v1_12_R1.ItemStack clickedSlotItem = slot.getItem();
            itemstack = clickedSlotItem.cloneItemStack();
            if (rawIndex < this.topRows * 9 ? !this.doShiftClickTransfer(clickedSlotItem, this.topRows * 9, this.slots.size(), true) : !this.doShiftClickTransfer(clickedSlotItem, 0, this.topRows * 9, false)) {
                return InvseeImpl.EMPTY_STACK;
            }
            if (clickedSlotItem.isEmpty()) {
                slot.set(InvseeImpl.EMPTY_STACK);
            } else {
                slot.f();
            }
        }
        return itemstack;
    }

    private boolean doShiftClickTransfer(net.minecraft.server.v1_12_R1.ItemStack clickedSlotItem, int targetMinIndex, int targetMaxIndex, boolean topClicked) {
        return super.a(clickedSlotItem, targetMinIndex, targetMaxIndex, topClicked);
    }
}

