/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.response;

import com.janboerman.invsee.spigot.api.SpectatorInventory;
import com.janboerman.invsee.spigot.api.response.Fail;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.Succeed;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;

public interface SpectateResponse<SI extends SpectatorInventory<?>> {
    public boolean isSuccess();

    public SI getInventory() throws NoSuchElementException;

    public NotCreatedReason getReason() throws NoSuchElementException;

    default public void ifSuccess(Consumer<? super SI> inventoryConsumer) {
        if (this.isSuccess()) {
            inventoryConsumer.accept(this.getInventory());
        }
    }

    default public void ifFailure(Consumer<? super NotCreatedReason> reasonConsumer) {
        if (!this.isSuccess()) {
            reasonConsumer.accept(this.getReason());
        }
    }

    public static <SI extends SpectatorInventory<?>> SpectateResponse<SI> succeed(SI spectatorInventory) {
        return new Succeed<SI>(spectatorInventory);
    }

    public static <SI extends SpectatorInventory<?>> SpectateResponse<SI> fail(NotCreatedReason reason) {
        return new Fail(reason);
    }

    public static <SI extends SpectatorInventory<?>> SpectateResponse<SI> fromOptional(Optional<SI> optional, NotCreatedReason ifEmpty) {
        if (optional.isPresent()) {
            return SpectateResponse.succeed((SpectatorInventory)optional.get());
        }
        return SpectateResponse.fail(ifEmpty);
    }

    public static <SI extends SpectatorInventory<?>> SpectateResponse<SI> fromOptional(Optional<SI> optional) {
        return SpectateResponse.fromOptional(optional, NotCreatedReason.generic());
    }

    public static <SI extends SpectatorInventory<?>> Optional<SI> toOptional(SpectateResponse<SI> response) {
        if (response.isSuccess()) {
            return Optional.ofNullable(response.getInventory());
        }
        return Optional.empty();
    }
}

