/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.resolve;

import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.TechsCode.UltraPermissions.UltraPermissions;
import me.TechsCode.UltraPermissions.UltraPermissionsAPI;
import me.TechsCode.UltraPermissions.storage.collection.UserList;
import me.TechsCode.UltraPermissions.storage.objects.User;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.platform.bukkit.BukkitPlugin;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.UserManager;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.worlds.WorldsHolder;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class UUIDPermissionPluginStrategy
implements UUIDResolveStrategy {
    private final Plugin plugin;
    private final Server server;
    private final Scheduler scheduler;

    public UUIDPermissionPluginStrategy(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.scheduler = scheduler;
    }

    private static Optional<UUID> firstPresentOptional(Optional<UUID> one, Optional<UUID> two) {
        if (one.isPresent()) {
            return one;
        }
        return two;
    }

    @Override
    public CompletableFuture<Optional<UUID>> resolveUniqueId(String userName) {
        return ((CompletableFuture)((CompletableFuture)this.resolveUsingLuckPerms(userName).thenCombine(this.resolveUsingGroupManager(userName), UUIDPermissionPluginStrategy::firstPresentOptional)).thenCombine(this.resolveUsingBungeePerms(userName), UUIDPermissionPluginStrategy::firstPresentOptional)).thenCombine(this.resolveUsingUltraPermissions(userName), UUIDPermissionPluginStrategy::firstPresentOptional);
    }

    private CompletableFuture<Optional<UUID>> resolveUsingLuckPerms(String userName) {
        CompletableFuture<Optional<UUID>> resultFuture = new CompletableFuture<Optional<UUID>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("LuckPerms")) {
                LuckPerms api = LuckPermsProvider.get();
                UserManager userManager = api.getUserManager();
                net.luckperms.api.model.user.User user = userManager.getUser(userName);
                if (user != null) {
                    resultFuture.complete(Optional.ofNullable(user.getUniqueId()));
                } else {
                    CompletableFuture luckPermsFuture = userManager.lookupUniqueId(userName);
                    luckPermsFuture.whenComplete((uuid, error) -> {
                        if (error != null) {
                            resultFuture.complete(Optional.ofNullable(uuid));
                        } else {
                            resultFuture.complete(Optional.empty());
                        }
                    });
                }
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }

    private CompletableFuture<Optional<UUID>> resolveUsingGroupManager(String userName) {
        CompletableFuture<Optional<UUID>> resultFuture = new CompletableFuture<Optional<UUID>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("GroupManager")) {
                GroupManager groupManager = (GroupManager)this.server.getPluginManager().getPlugin("GroupManager");
                WorldsHolder worldsHolder = groupManager.getWorldsHolder();
                OverloadedWorldHolder overloadedWorldHolder = worldsHolder.getWorldDataByPlayerName(userName);
                if (overloadedWorldHolder == null) {
                    overloadedWorldHolder = worldsHolder.getDefaultWorld();
                }
                org.anjocaido.groupmanager.data.User user = overloadedWorldHolder.getUser(userName);
                String userId = user.getUUID();
                try {
                    resultFuture.complete(userId == null ? Optional.empty() : Optional.of(UUID.fromString(userId)));
                }
                catch (IllegalArgumentException e) {
                    resultFuture.complete(Optional.empty());
                }
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }

    private CompletableFuture<Optional<UUID>> resolveUsingBungeePerms(String userName) {
        CompletableFuture<Optional<UUID>> resultFuture = new CompletableFuture<Optional<UUID>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("BungeePerms")) {
                BukkitPlugin bukkitPlugin = (BukkitPlugin)this.server.getPluginManager().getPlugin("BungeePerms");
                BungeePerms bungeePerms = bukkitPlugin.getBungeeperms();
                PermissionsManager permissionsManager = bungeePerms.getPermissionsManager();
                this.scheduler.executeAsync(() -> {
                    try {
                        net.alpenblock.bungeeperms.User user = permissionsManager.getUser(userName, true);
                        if (user == null) {
                            resultFuture.complete(Optional.empty());
                        } else {
                            resultFuture.complete(Optional.ofNullable(user.getUUID()));
                        }
                    }
                    catch (Throwable t) {
                        resultFuture.complete(Optional.empty());
                    }
                });
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }

    private CompletableFuture<Optional<UUID>> resolveUsingUltraPermissions(String userName) {
        CompletableFuture<Optional<UUID>> resultFuture = new CompletableFuture<Optional<UUID>>();
        this.scheduler.executeSyncGlobal(() -> {
            if (this.server.getPluginManager().isPluginEnabled("UltraPermissions")) {
                UltraPermissionsAPI api = UltraPermissions.getAPI();
                this.scheduler.executeAsync(() -> {
                    try {
                        UserList userList = api.getUsers();
                        Optional optUser = userList.name(userName);
                        resultFuture.complete(optUser.map(User::getUuid));
                    }
                    catch (Throwable t) {
                        resultFuture.complete(Optional.empty());
                    }
                });
            } else {
                resultFuture.complete(Optional.empty());
            }
        });
        return resultFuture;
    }
}

