/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.resolve;

import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import com.janboerman.invsee.spigot.internal.CompletedEmpty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class UUIDPaperCacheStrategy
implements UUIDResolveStrategy {
    private final Plugin plugin;
    private final Scheduler scheduler;
    private final Server server;
    private final Method method;

    public UUIDPaperCacheStrategy(Plugin plugin, Scheduler scheduler) {
        Method method;
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.scheduler = scheduler;
        try {
            method = this.server.getClass().getMethod("getOfflinePlayerIfCached", String.class);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        this.method = method;
    }

    @Override
    public CompletableFuture<Optional<UUID>> resolveUniqueId(String userName) {
        if (this.method == null) {
            return CompletedEmpty.the();
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                OfflinePlayer offlinePlayer = (OfflinePlayer)this.method.invoke((Object)this.server, userName);
                if (offlinePlayer == null) {
                    return Optional.empty();
                }
                return Optional.of(offlinePlayer.getUniqueId());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }, this.scheduler::executeSyncGlobal);
    }
}

