/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.api.resolve;

import com.janboerman.invsee.mojangapi.ElectroidAPI;
import com.janboerman.invsee.spigot.api.resolve.UUIDResolveStrategy;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class UUIDElectroidAPIStrategy
implements UUIDResolveStrategy {
    private final Plugin plugin;
    private final ElectroidAPI electroidApi;

    public UUIDElectroidAPIStrategy(Plugin plugin, ElectroidAPI electroidApi) {
        this.plugin = Objects.requireNonNull(plugin);
        this.electroidApi = Objects.requireNonNull(electroidApi);
    }

    @Override
    public CompletableFuture<Optional<UUID>> resolveUniqueId(String userName) {
        return this.electroidApi.lookupUniqueId(userName).handle((success, error) -> {
            if (error == null) {
                return success;
            }
            this.plugin.getLogger().log(Level.WARNING, "Could not request profile for username " + userName + " from Electroid's Mojang API", (Throwable)error);
            return Optional.empty();
        });
    }
}

